/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.dlm;

import com.ovopark.device.modules.dlm.OnOffEvent;
import com.ovopark.device.modules.dlm.OnOffSnapshot;
import com.ovopark.iohub.sdk.client.outstream.RenderJob;
import com.ovopark.iohub.sdk.client.outstream.RenderJobManager;
import com.ovopark.iohub.sdk.model.proto.CellDataType;
import com.ovopark.iohub.sdk.model.proto.CellDef;
import com.ovopark.iohub.sdk.model.proto.HeaderDef;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.springframework.beans.BeanUtils;

public class SimpleOnOffSnapshot
implements OnOffSnapshot {
    private final TreeMap<Long, OnOffEvent> onOffEventTreeMap = new TreeMap();

    @Override
    public void collect(OnOffEvent onOffEvent) {
        this.onOffEventTreeMap.put(onOffEvent.getTimestampMs(), onOffEvent);
    }

    @Override
    public void mergeIntervalsThenSubscribe(Consumer<OnOffEvent> consumer) {
        this.mergeIntervals().forEach((k, v) -> consumer.accept((OnOffEvent)v));
    }

    @Override
    public void write2ExcelThenSubscribe(Consumer<String> consumer) {
        String url;
        block3: {
            RenderJob renderJob = RenderJobManager.newJob((boolean)false);
            OutStore outStore = renderJob.outStore();
            OutStore.SegmentWriter segment = outStore.createSegment("sheet1");
            segment.header().all(DeviceOnOffExcel.class);
            for (OnOffEvent offEvent : this.onOffEventTreeMap.values()) {
                DeviceOnOffExcel deviceOnOffExcel = new DeviceOnOffExcel();
                BeanUtils.copyProperties((Object)offEvent, (Object)deviceOnOffExcel);
                deviceOnOffExcel.setTimestampStr(Util.formatTime((LocalDateTime)Util.dateTime((long)deviceOnOffExcel.getTimestampMs()), (String[])new String[0]));
                segment.append((Model)deviceOnOffExcel);
            }
            segment.commit();
            String fileName = "onOffSnapshot-" + Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]);
            outStore.fileName(fileName);
            Util.log.info("write2ExcelThenSubscribe , to render excel");
            final RenderJob.RenderFuture renderFuture = renderJob.render2Excel();
            Util.log.info("already send to remote render server ,  wait result???");
            url = null;
            try {
                url = renderFuture.get(60L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (renderFuture.cancelled()) break block3;
                renderFuture.setRenderListener(new RenderJob.RenderListener(){

                    public void onRender(String outFileUrl, Throwable t) {
                        if (renderFuture.cancelled()) {
                            Util.log.info("cancelled");
                        }
                        Util.log.info("error( " + (t != null) + " ), get url???: " + outFileUrl, t);
                    }
                });
            }
        }
        consumer.accept(url);
    }

    @Override
    public int size() {
        return this.onOffEventTreeMap.size();
    }

    @Override
    public void close() {
        this.onOffEventTreeMap.clear();
    }

    @Override
    public void mergeIntervals2ESModelThenSubscribe(Consumer<OnOffSnapshot.OnOffESModel> consumer, Predicate<OnOffEvent> predicate) {
        HashMap<String, OnOffSnapshot.OnOffESModel> onOffESModelMap = new HashMap<String, OnOffSnapshot.OnOffESModel>();
        TreeMap<Long, OnOffEvent> offEventTreeMap = this.mergeIntervals();
        for (Map.Entry<Long, OnOffEvent> entry : offEventTreeMap.entrySet()) {
            Long key = entry.getKey();
            OnOffEvent onOffEvent = entry.getValue();
            if (!predicate.test(onOffEvent)) continue;
            String k = onOffEvent.getNvrMac() + ":" + onOffEvent.getChannel() + ":" + onOffEvent.getMac();
            OnOffSnapshot.OnOffESModel onOffESModel = onOffESModelMap.computeIfAbsent(k, s -> {
                OnOffSnapshot.OnOffESModel t = new OnOffSnapshot.OnOffESModel();
                t.setNvrMac(onOffEvent.getNvrMac());
                t.setChannel(onOffEvent.getChannel());
                t.setMac(onOffEvent.getMac());
                t.setTempStringBuilder(new StringBuilder());
                return t;
            });
            onOffESModel.getTempStringBuilder().append(key + "," + onOffEvent.getOnOff() + ";");
            if (onOffESModel.getFromTime() == 0L) {
                onOffESModel.setFromTime(onOffEvent.getTimestampMs());
            }
            onOffESModel.setEndTime(onOffEvent.getTimestampMs());
        }
        for (OnOffSnapshot.OnOffESModel onOffESModel : onOffESModelMap.values()) {
            onOffESModel.setOnOffList(onOffESModel.getTempStringBuilder().toString());
            consumer.accept(onOffESModel);
        }
    }

    TreeMap<Long, OnOffEvent> mergeIntervals() {
        TreeMap<Long, OnOffEvent> afterMap = new TreeMap<Long, OnOffEvent>();
        OnOffEvent before = null;
        for (Map.Entry<Long, OnOffEvent> entry : this.onOffEventTreeMap.entrySet()) {
            Long key = entry.getKey();
            OnOffEvent onOffEvent = entry.getValue();
            if (before == null) {
                afterMap.put(key, onOffEvent);
                before = onOffEvent;
                continue;
            }
            if (Util.compare2((Comparable)Integer.valueOf(before.getOnOff()), (Comparable)Integer.valueOf(onOffEvent.getOnOff())) == 0) continue;
            afterMap.put(key, onOffEvent);
            before = onOffEvent;
        }
        return afterMap;
    }

    @HeaderDef
    public static class DeviceOnOffExcel
    implements Model {
        @CellDef(showName="nvrMac")
        private String nvrMac;
        @CellDef(showName="mac")
        private String mac;
        @CellDef(showName="channel")
        private Integer channel;
        @CellDef(showName="timestampMs", cellDataType=CellDataType.STRING)
        private long timestampMs;
        @CellDef(showName="onOff")
        private int onOff;
        @CellDef(showName="source")
        private String source;
        @CellDef(showName="timestampStr")
        private String timestampStr;

        public String getNvrMac() {
            return this.nvrMac;
        }

        public String getMac() {
            return this.mac;
        }

        public Integer getChannel() {
            return this.channel;
        }

        public long getTimestampMs() {
            return this.timestampMs;
        }

        public int getOnOff() {
            return this.onOff;
        }

        public String getSource() {
            return this.source;
        }

        public String getTimestampStr() {
            return this.timestampStr;
        }

        public void setNvrMac(String nvrMac) {
            this.nvrMac = nvrMac;
        }

        public void setMac(String mac) {
            this.mac = mac;
        }

        public void setChannel(Integer channel) {
            this.channel = channel;
        }

        public void setTimestampMs(long timestampMs) {
            this.timestampMs = timestampMs;
        }

        public void setOnOff(int onOff) {
            this.onOff = onOff;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public void setTimestampStr(String timestampStr) {
            this.timestampStr = timestampStr;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeviceOnOffExcel)) {
                return false;
            }
            DeviceOnOffExcel other = (DeviceOnOffExcel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimestampMs() != other.getTimestampMs()) {
                return false;
            }
            if (this.getOnOff() != other.getOnOff()) {
                return false;
            }
            Integer this$channel = this.getChannel();
            Integer other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
                return false;
            }
            String this$nvrMac = this.getNvrMac();
            String other$nvrMac = other.getNvrMac();
            if (this$nvrMac == null ? other$nvrMac != null : !this$nvrMac.equals(other$nvrMac)) {
                return false;
            }
            String this$mac = this.getMac();
            String other$mac = other.getMac();
            if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$timestampStr = this.getTimestampStr();
            String other$timestampStr = other.getTimestampStr();
            return !(this$timestampStr == null ? other$timestampStr != null : !this$timestampStr.equals(other$timestampStr));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DeviceOnOffExcel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestampMs = this.getTimestampMs();
            result = result * 59 + (int)($timestampMs >>> 32 ^ $timestampMs);
            result = result * 59 + this.getOnOff();
            Integer $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            String $nvrMac = this.getNvrMac();
            result = result * 59 + ($nvrMac == null ? 43 : $nvrMac.hashCode());
            String $mac = this.getMac();
            result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $timestampStr = this.getTimestampStr();
            result = result * 59 + ($timestampStr == null ? 43 : $timestampStr.hashCode());
            return result;
        }

        public String toString() {
            return "SimpleOnOffSnapshot.DeviceOnOffExcel(nvrMac=" + this.getNvrMac() + ", mac=" + this.getMac() + ", channel=" + this.getChannel() + ", timestampMs=" + this.getTimestampMs() + ", onOff=" + this.getOnOff() + ", source=" + this.getSource() + ", timestampStr=" + this.getTimestampStr() + ")";
        }
    }
}

