/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.dlm;

import com.ovopark.device.modules.dlm.OnOffSnapshot;
import com.ovopark.device.modules.dlm.OnOffStorage;
import com.ovopark.device.modules.platform.ConditionOnDLMJob4MainDevice;
import com.ovopark.jobhub.sdk.client.JobContext;
import com.ovopark.jobhub.sdk.client.JobLog;
import com.ovopark.jobhub.sdk.client.JobService;
import com.ovopark.jobhub.sdk.client.JobTaskListener;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.es7x.Document;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@ConditionOnDLMJob4MainDevice
@ConditionalOnExpression(value="#{'MULTI_INDEX'.equals(environment.getProperty('DEVICE_JOB_DLM_ONOFF_STORAGE')) || environment.getProperty('DEVICE_JOB_DLM_ONOFF_STORAGE') == null || environment.getProperty('DEVICE_JOB_DLM_ONOFF_STORAGE').trim().length() == 0}")
@Component(value="MultiIndexOnOffStorage")
public class MultiIndexOnOffStorage
implements OnOffStorage,
JobTaskListener,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(MultiIndexOnOffStorage.class);
    public static final String BEAN_NAME = "MultiIndexOnOffStorage";
    public static final String DEVICE_ONOFFDAY_PREFIX = "device-onoffday-";
    @Autowired
    private ElasticsearchOperations elasticsearchOperations;
    @Autowired
    private JobService jobService;

    public MultiIndexOnOffStorage() {
        log.info("use MULTI_INDEX storage");
    }

    @Override
    public OnOffSnapshot.OnOffESModel get(String id, String dayRouter) {
        return (OnOffSnapshot.OnOffESModel)this.elasticsearchOperations.get(this.readIndex(dayRouter), id, OnOffSnapshot.OnOffESModel.class);
    }

    @Override
    public void upsert(OnOffSnapshot.OnOffESModel onOffESModel, String dayRouter) {
        this.elasticsearchOperations.upsert(this.writeIndex(dayRouter), (Document)onOffESModel);
    }

    private String readIndex(String dayRouter) {
        String realIndex = DEVICE_ONOFFDAY_PREFIX + dayRouter;
        return realIndex;
    }

    private String writeIndex(String dayRouter) {
        String realIndex = DEVICE_ONOFFDAY_PREFIX + dayRouter;
        return realIndex;
    }

    public void on(JobContext jobContext, JobLog jobLog) {
        String dayStr = Util.formatTime((LocalDate)LocalDate.now(), (String[])new String[]{"yyyyMMdd"});
        String index = DEVICE_ONOFFDAY_PREFIX + dayStr;
        boolean f = this.elasticsearchOperations.createIndexAtTemplate(index);
        log.info("createIndexAtTemplate: " + f + " , index: " + index);
        LocalDate oldLocalDate = LocalDate.now().minusDays(45L);
        dayStr = Util.formatTime((LocalDate)oldLocalDate, (String[])new String[]{"yyyyMMdd"});
        index = DEVICE_ONOFFDAY_PREFIX + dayStr;
        f = this.elasticsearchOperations.deleteIndexIfExists(index);
        log.info("deleteIndexIfExists: " + f + " , index: " + index);
    }

    public void run(String ... args) throws Exception {
        try {
            Long id = this.jobService.cronTaskRegister(MultiIndexOnOffStorage.class.getSimpleName(), BEAN_NAME, "*/5 * * * * *");
            log.info("create cron task result: " + id);
        }
        catch (Exception e) {
            log.error("create cron task result: " + e.getMessage(), (Throwable)e);
        }
    }
}

