/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.onlinereport;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.DateUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.modules.onlinereport.OnlineDetailService;
import com.ovopark.device.modules.onlinereport.mysql.DeviceOnlineLogDay;
import com.ovopark.device.modules.onlinereport.mysql.DeviceOnlineLogDayDetail;
import com.ovopark.device.modules.onlinereport.mysql.DeviceOnlineLogDayDetailMapper;
import com.ovopark.device.modules.onlinereport.mysql.DeviceOnlineLogDayMapper;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.modules.reportdevice.DeviceOnlineCountDto;
import com.ovopark.device.modules.reportdevice.DeviceStatusRecordServiceImpl;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.DepIdsAndUserMo;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.OrganizeApi;
import com.ovopark.organize.sdk.api.UserDepartmentApi;
import jakarta.annotation.Resource;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OnlineDetailServiceImpl
implements OnlineDetailService {
    private static final Logger log = LoggerFactory.getLogger(OnlineDetailServiceImpl.class);
    @Autowired
    private RPCFacade rpcFacade;
    @Autowired
    private DeviceStatusService deviceStatusService;
    @Autowired
    private DeviceStatusRecordServiceImpl deviceStatusRecordService;
    @Autowired
    private DepartmentFacade departmentFacade;
    @Autowired
    private MessageSource messageSource;
    @Resource
    private UserDepartmentApi userDepartmentApi;
    @Resource
    private DepartmentApi departmentApi;
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;
    @Resource
    private OrganizeApi organizeApi;
    @Autowired
    private DeviceOnlineLogDayMapper deviceOnlineLogDayMapper;
    @Autowired
    private DeviceOnlineLogDayDetailMapper deviceOnlineLogDayDetailMapper;
    @Autowired
    private RPCFacade rpcService;
    public static final DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public void deviceOnlineDetail(List<DeviceStatus> deviceStatusByDepIds, Integer groupId, LocalDate startLocalDate, LocalDate endLocalDate, boolean allGroupDeptFlag, List<Integer> deptIds, List<Integer> types, Locale locale, OutStore outStore) {
        String value;
        String key;
        List<DeviceOnlineLogDay> listGroupByMacAndChannelId1 = this.deviceOnlineLogDayMapper.getDeviceOnlineLogDayList(groupId, startLocalDate, endLocalDate);
        HashMap<CallSite, LocalDate> deviceCreateMap = new HashMap<CallSite, LocalDate>(deviceStatusByDepIds.size());
        HashMap<CallSite, Integer> macChannelIdAndIdMap = new HashMap<CallSite, Integer>(deviceStatusByDepIds.size());
        HashMap<String, DeviceStatus> deviceStatusMap = new HashMap<String, DeviceStatus>();
        for (DeviceStatus deviceStatus : deviceStatusByDepIds) {
            String mac = deviceStatus.getMac();
            deviceStatusMap.put(mac, deviceStatus);
            LocalDateTime createTime = deviceStatus.getCreateTime();
            if (deviceStatus.getIsDelete() == 1 || createTime == null || StringUtils.isEmpty((CharSequence)mac)) continue;
            deviceCreateMap.put((CallSite)((Object)(deviceStatus.getGroupId() + "|" + deviceStatus.getDepId() + "|" + deviceStatus.getMac() + "|" + deviceStatus.getChannelId())), createTime.toLocalDate());
            macChannelIdAndIdMap.put((CallSite)((Object)(deviceStatus.getMac() + "|" + deviceStatus.getChannelId())), deviceStatus.getId());
        }
        ArrayList<DeviceOnlineLogDay> finalDeviceOnlineLogDayAggr = new ArrayList<DeviceOnlineLogDay>();
        for (DeviceOnlineLogDay item : listGroupByMacAndChannelId1) {
            String deviceCreateMappKey = item.getGroupId() + "|" + item.getDeptId() + "|" + item.getMac() + "|" + item.getChannelId();
            LocalDate createTime = (LocalDate)deviceCreateMap.get(deviceCreateMappKey);
            if (createTime == null) continue;
            finalDeviceOnlineLogDayAggr.add(item);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<Integer> deviceStatusIds = new ArrayList<Integer>(finalDeviceOnlineLogDayAggr.size());
        for (DeviceOnlineLogDay item : finalDeviceOnlineLogDayAggr) {
            Integer deptId = item.getDeptId();
            hashSet.add(deptId);
            Integer channelId = item.getChannelId();
            String mac = item.getMac();
            Integer deviceStatusId = (Integer)macChannelIdAndIdMap.get((String)mac + "|" + channelId);
            deviceStatusIds.add(deviceStatusId);
        }
        List<DeviceOnlineCountDto> onlineCountInTimesGroupByDeviceId = this.deviceStatusRecordService.getOnlineCountInTimesGroupByDeviceId(startLocalDate.format(fmt) + " 00:00:00", endLocalDate.format(fmt) + " 23:59:59", deviceStatusIds);
        HashMap<Integer, DeviceOnlineCountDto> deviceOnlineCountDtoMap = new HashMap<Integer, DeviceOnlineCountDto>(onlineCountInTimesGroupByDeviceId.size());
        for (DeviceOnlineCountDto item : onlineCountInTimesGroupByDeviceId) {
            deviceOnlineCountDtoMap.put(item.getDeviceId(), item);
        }
        deptIds = new ArrayList<Integer>(hashSet);
        List<DeviceOnlineLogDay> deviceOnlineLogDayList = this.getList(groupId, allGroupDeptFlag ? null : deptIds, startLocalDate, endLocalDate);
        ArrayList<Integer> deviceOnlineLogDayIds = new ArrayList<Integer>(deviceOnlineLogDayList.size());
        for (DeviceOnlineLogDay item : deviceOnlineLogDayList) {
            deviceOnlineLogDayIds.add(item.getId());
        }
        List<DeviceOnlineLogDayDetail> byDeviceOnlineLogDayIds = this.getByDeviceOnlineLogDayIds(deviceOnlineLogDayIds);
        HashMap<Integer, DeviceOnlineLogDayDetail> deviceOnlineLogDayDetailMap = new HashMap<Integer, DeviceOnlineLogDayDetail>();
        for (DeviceOnlineLogDayDetail item : byDeviceOnlineLogDayIds) {
            deviceOnlineLogDayDetailMap.put(item.getDeviceOnlineLogDayId(), item);
        }
        HashMap<CallSite, String> dayDetailMap = new HashMap<CallSite, String>(byDeviceOnlineLogDayIds.size());
        HashMap<CallSite, DeviceOnlineLogDay> map1 = new HashMap<CallSite, DeviceOnlineLogDay>(byDeviceOnlineLogDayIds.size());
        for (DeviceOnlineLogDay item : deviceOnlineLogDayList) {
            Integer id = item.getId();
            DeviceOnlineLogDayDetail deviceOnlineLogDayDetail = (DeviceOnlineLogDayDetail)deviceOnlineLogDayDetailMap.get(id);
            String key2 = item.getGroupId() + "|" + item.getDeptId() + "|" + item.getMac() + "|" + item.getChannelId() + "|" + item.getDataDate().format(fmt);
            map1.put((CallSite)((Object)key2), item);
            if (deviceOnlineLogDayDetail == null) {
                dayDetailMap.put((CallSite)((Object)key2), "00:00:00~23:59:59offline");
                continue;
            }
            dayDetailMap.put((CallSite)((Object)key2), deviceOnlineLogDayDetail.getDetail());
        }
        BaseResult depPathById = this.departmentApi.getDepPathById(groupId, deptIds);
        HashMap<Integer, String> depIdAndOrgNameMap = new HashMap<Integer, String>(deptIds.size());
        List data = (List)depPathById.getData();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)data)) {
            for (SimplePojo simplePojo : data) {
                depIdAndOrgNameMap.put(simplePojo.getId(), simplePojo.getName());
            }
        }
        List list = finalDeviceOnlineLogDayAggr.stream().map(DeviceOnlineLogDay::getDeptId).collect(Collectors.toList());
        List departmentList = this.rpcService.departmentList(list);
        Map<Object, Object> departmentPojoMap = new HashMap();
        if (Util.isNotEmpty((Collection)departmentList)) {
            departmentPojoMap = departmentList.stream().collect(Collectors.toMap(DepartmentPojo::getId, v -> v));
        }
        log.info("departmentPojoMap: " + JSONAccessor.impl().format(departmentPojoMap));
        if (outStore == null) {
            return;
        }
        String sheetName = "\u8bbe\u5907\u8be6\u60c5\u8868_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        OutStore.SegmentWriter segment = outStore.createSegment(sheetName);
        String title = this.messageSource.getMessage("DeviceReport.device.sheet.excel", null, locale) + "_" + DateUtils.parseTime((LocalDateTime)LocalDateTime.now(), (DateUtils.Format)DateUtils.Format.LONG_DATE_FORMAT_NONE_CHAR);
        segment.title().title(title);
        Segment.Header header = segment.header();
        header.upset(null, "org_name", null, p -> this.messageSource.getMessage("device.online.detail.org-name", null, locale));
        header.upset(null, "dept_name", null, p -> this.messageSource.getMessage("device.online.detail.dept-name", null, locale));
        header.upset(null, "store_id", null, p -> this.messageSource.getMessage("device.online.detail.store-id", null, locale));
        header.upset(null, "device_name", null, p -> this.messageSource.getMessage("device.online.detail.device-name", null, locale));
        header.upset(null, "device_type_name", null, p -> this.messageSource.getMessage("device.online.detail.device-type-name", null, locale));
        header.upset(null, "device_type", null, p -> this.messageSource.getMessage("device.online.detail.device-type", null, locale));
        header.upset(null, "device_mac", null, p -> this.messageSource.getMessage("device.online.detail.device-mac", null, locale));
        header.upset(null, "online_days", null, p -> this.messageSource.getMessage("device.online.detail.online_days", null, locale));
        header.upset(null, "offline_days", null, p -> this.messageSource.getMessage("device.online.detail.offline_days", null, locale));
        long days = endLocalDate.toEpochDay() - startLocalDate.toEpochDay();
        for (long i = 0L; i < days; ++i) {
            String dateStr = startLocalDate.plusDays(i).format(fmt);
            if (types.contains(2)) {
                header.upset(null, dateStr + "2", p -> 30, p -> dateStr + this.messageSource.getMessage("device.online.detail.online-detail", null, locale));
            }
            if (types.contains(3)) {
                header.upset(null, dateStr + "3", p -> 30, p -> dateStr + this.messageSource.getMessage("device.online.detail.offline-detail", null, locale));
            }
            if (types.contains(4)) {
                header.upset(null, dateStr + "4", p -> 30, p -> dateStr + this.messageSource.getMessage("device.online.detail.online-time", null, locale));
            }
            if (types.contains(5)) {
                header.upset(null, dateStr + "5", p -> 30, p -> dateStr + this.messageSource.getMessage("device.online.detail.open-online-time", null, locale));
            }
            if (!types.contains(6)) continue;
            header.upset(null, dateStr + "6", p -> 30, p -> dateStr + this.messageSource.getMessage("device.online.detail.offline-time", null, locale));
        }
        for (DeviceOnlineLogDay item : finalDeviceOnlineLogDayAggr) {
            String mac = item.getMac();
            Integer channelId = item.getChannelId();
            String deviceWithoutDayKey = item.getGroupId() + "|" + item.getDeptId() + "|" + mac + "|" + channelId;
            Integer deviceId = (Integer)macChannelIdAndIdMap.get(mac + "|" + channelId);
            LocalDate createTime = (LocalDate)deviceCreateMap.get(deviceWithoutDayKey);
            if (createTime == null) continue;
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            Integer deptId = item.getDeptId();
            rowData.put("org_name", depIdAndOrgNameMap.getOrDefault(deptId, "-"));
            DepartmentPojo departmentPojo = (DepartmentPojo)departmentPojoMap.get(item.getDeptId());
            rowData.put("dept_name", departmentPojo.getName());
            rowData.put("store_id", Util.convert2Self((Object)departmentPojo.getShopId(), (Object)"-"));
            rowData.put("device_name", Util.convert2Self((Object)item.getDeviceName(), (Object)"-"));
            rowData.put("device_type", null);
            rowData.put("device_type_name", Util.convert2Self((Object)item.getDeviceType(), (Object)"-"));
            rowData.put("device_mac", Util.convert2Self((Object)mac, (Object)"-"));
            if (deviceId == null || deviceOnlineCountDtoMap.get(deviceId) == null) {
                rowData.put("online_days", null);
                rowData.put("offline_days", null);
            } else {
                DeviceOnlineCountDto deviceOnlineCountDto = (DeviceOnlineCountDto)deviceOnlineCountDtoMap.get(deviceId);
                Integer n = deviceOnlineCountDto.getOnlineCount();
                Integer offlineCount = deviceOnlineCountDto.getOfflineCount();
                rowData.put("online_days", n == null ? "-" : n.toString());
                rowData.put("offline_days", offlineCount == null ? "-" : offlineCount.toString());
            }
            int i = 0;
            while ((long)i <= days) {
                DeviceOnlineLogDay deviceOnlineLogDay;
                int length;
                LocalDate localDate = startLocalDate.plusDays(i);
                String dateStr = startLocalDate.plusDays(i).format(fmt);
                key = deviceWithoutDayKey + "|" + localDate.format(fmt);
                value = (String)dayDetailMap.get(key);
                if (createTime == null || createTime.compareTo(localDate) > 0) {
                    value = "";
                }
                Object offlineStr = "";
                Object offStart = "";
                if (StringUtils.isNotEmpty((CharSequence)value) && value.length() > 16) {
                    if (!value.startsWith("00:00:00")) {
                        offStart = "00:00:00~" + value.substring(0, 8) + "offline";
                    }
                    offlineStr = ((String)(offlineStr = value.substring(9).replace("~", "offline").replace("online", "~"))).endsWith("23:59:59~") ? ((String)offlineStr).replace("23:59:59~", "") : (String)offlineStr + "23:59:59offline";
                    if (StringUtils.isNotEmpty((CharSequence)offStart)) {
                        offlineStr = (String)offStart + (String)offlineStr;
                    }
                }
                if (types.contains(2)) {
                    if (StringUtils.isEmpty((CharSequence)value)) {
                        rowData.put(dateStr + "2", "-");
                    } else {
                        length = value.length();
                        if (length < 100) {
                            rowData.put(dateStr + "2", value);
                        } else {
                            rowData.put(dateStr + "2", this.messageSource.getMessage("device.online.detail.device-error", null, locale));
                        }
                    }
                }
                if (types.contains(3)) {
                    if (StringUtils.isEmpty((CharSequence)value)) {
                        rowData.put(dateStr + "3", "-");
                    } else {
                        length = value.length();
                        if (length < 100) {
                            rowData.put(dateStr + "3", offlineStr);
                        } else {
                            rowData.put(dateStr + "3", this.messageSource.getMessage("device.online.detail.device-error", null, locale));
                        }
                    }
                }
                if ((deviceOnlineLogDay = (DeviceOnlineLogDay)map1.get(key)) == null) {
                    if (types.contains(4)) {
                        rowData.put(dateStr + "4", "-");
                    }
                    if (types.contains(5)) {
                        rowData.put(dateStr + "5", "-");
                    }
                    if (types.contains(6)) {
                        rowData.put(dateStr + "6", "-");
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)value) && value.length() > 100) {
                    if (types.contains(4)) {
                        rowData.put(dateStr + "4", this.messageSource.getMessage("device.online.detail.device-error", null, locale));
                    }
                    if (types.contains(5)) {
                        rowData.put(dateStr + "5", this.messageSource.getMessage("device.online.detail.device-error", null, locale));
                    }
                    if (types.contains(6)) {
                        rowData.put(dateStr + "6", this.messageSource.getMessage("device.online.detail.device-error", null, locale));
                    }
                } else {
                    if (types.contains(4)) {
                        rowData.put(dateStr + "4", String.format("%.2f", deviceOnlineLogDay.getOnlineTime().doubleValue() / 3600.0));
                    }
                    if (types.contains(5)) {
                        rowData.put(dateStr + "5", String.format("%.2f", deviceOnlineLogDay.getOpenTimeOnlineTime().doubleValue() / 3600.0));
                    }
                    if (types.contains(6)) {
                        rowData.put(dateStr + "6", String.format("%.2f", deviceOnlineLogDay.getOfflineTime().doubleValue() / 3600.0));
                    }
                }
                ++i;
            }
            for (Map.Entry entry : rowData.entrySet()) {
                Object value2 = entry.getValue();
                if (!(value2 instanceof String)) continue;
                String c = (String)value2;
                if ("00:00:00~23:59:59online".equalsIgnoreCase(c)) {
                    entry.setValue(this.messageSource.getMessage("device.online.detail.full-online", null, locale));
                    continue;
                }
                if ("00:00:00~23.59.59offline".equalsIgnoreCase(c)) {
                    entry.setValue(this.messageSource.getMessage("device.online.detail.full-offline", null, locale));
                    continue;
                }
                if ("-".equalsIgnoreCase(c)) {
                    entry.setValue(this.messageSource.getMessage("device.online.detail.fail-search", null, locale));
                    continue;
                }
                if (!"\u8bbe\u5907\u5f02\u5e38".equalsIgnoreCase(c)) continue;
            }
            this.replaceOnlineOffline(rowData);
            segment.append(rowData);
        }
        segment.commit();
        int i = 0;
        while ((long)i <= days) {
            String mMdd = startLocalDate.plusDays(i).format(DateTimeFormatter.ofPattern("MMdd"));
            segment = outStore.createSegment(mMdd + "\u5168\u65f6\u6bb5\u8be6\u60c5");
            header = segment.header();
            header.upset(null, "org_name", null, p -> this.messageSource.getMessage("device.online.detail.org-name", null, locale));
            header.upset(null, "dept_name", null, p -> this.messageSource.getMessage("device.online.detail.dept-name", null, locale));
            header.upset(null, "store_id", null, p -> this.messageSource.getMessage("device.online.detail.store-id", null, locale));
            header.upset(null, "device_name", null, p -> this.messageSource.getMessage("device.online.detail.device-name", null, locale));
            header.upset(null, "device_type_name", null, p -> this.messageSource.getMessage("device.online.detail.device-type-name", null, locale));
            header.upset(null, "device_type", null, p -> this.messageSource.getMessage("device.online.detail.device-type", null, locale));
            header.upset(null, "device_mac", null, p -> this.messageSource.getMessage("device.online.detail.device-mac", null, locale));
            for (int h = 0; h < 24; ++h) {
                String property = Util.leftPad((long)h, (int)2) + ":00:00-" + Util.leftPad((long)h, (int)2) + ":59:59";
                header.upset(null, property, p -> 30, p -> property);
            }
            for (DeviceOnlineLogDay item : finalDeviceOnlineLogDayAggr) {
                String mac = item.getMac();
                Integer channelId = item.getChannelId();
                String deviceWithoutDayKey = item.getGroupId() + "|" + item.getDeptId() + "|" + mac + "|" + channelId;
                Integer deviceId = (Integer)macChannelIdAndIdMap.get(mac + "|" + channelId);
                LocalDate createTime = (LocalDate)deviceCreateMap.get(deviceWithoutDayKey);
                if (createTime == null) continue;
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                Integer deptId = item.getDeptId();
                rowData.put("org_name", depIdAndOrgNameMap.getOrDefault(deptId, "-"));
                DepartmentPojo departmentPojo = (DepartmentPojo)departmentPojoMap.get(item.getDeptId());
                rowData.put("dept_name", departmentPojo.getName());
                rowData.put("store_id", Util.convert2Self((Object)departmentPojo.getShopId(), (Object)"-"));
                rowData.put("device_name", Util.convert2Self((Object)item.getDeviceName(), (Object)"-"));
                rowData.put("device_type", null);
                rowData.put("device_type_name", Util.convert2Self((Object)item.getDeviceType(), (Object)"-"));
                rowData.put("device_mac", Util.convert2Self((Object)mac, (Object)"-"));
                LocalDate date = startLocalDate.plusDays(i);
                key = deviceWithoutDayKey + "|" + date.format(fmt);
                value = (String)dayDetailMap.get(key);
                List<String> strings = OnlineDetailServiceImpl.hourlyStatus(value);
                for (int h = 0; h < 24; ++h) {
                    String df = strings.get(h);
                    String xk = Util.leftPad((long)h, (int)2) + ":00:00-" + Util.leftPad((long)h, (int)2) + ":59:59";
                    rowData.put(xk, df);
                    if (!df.contains(",")) continue;
                    List ls = Util.convert2StrList((String)df);
                    rowData.put(xk, ls);
                }
                this.replaceOnlineOffline(rowData);
                segment.append(rowData);
            }
            segment.feature().supportRangeMerge(true);
            segment.commit();
            ++i;
        }
    }

    private List<DeviceOnlineLogDay> getList(Integer groupId, List<Integer> deptIds, LocalDate startLocalDate, LocalDate endLocalDate) {
        if (groupId == null) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper deviceOnlineLogDayLambdaQueryWrapper = new LambdaQueryWrapper();
        deviceOnlineLogDayLambdaQueryWrapper.eq(DeviceOnlineLogDay::getGroupId, (Object)groupId);
        deviceOnlineLogDayLambdaQueryWrapper.le(DeviceOnlineLogDay::getDataDate, (Object)endLocalDate);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(deptIds)) {
            deviceOnlineLogDayLambdaQueryWrapper.in(DeviceOnlineLogDay::getDeptId, deptIds);
        }
        deviceOnlineLogDayLambdaQueryWrapper.ge(DeviceOnlineLogDay::getDataDate, (Object)startLocalDate);
        return this.deviceOnlineLogDayMapper.selectList((Wrapper)deviceOnlineLogDayLambdaQueryWrapper);
    }

    public List<DeviceOnlineLogDayDetail> getByDeviceOnlineLogDayIds(List<Integer> deviceOnlineLogDayIdList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(deviceOnlineLogDayIdList)) {
            ArrayList<DeviceOnlineLogDayDetail> result = new ArrayList<DeviceOnlineLogDayDetail>(deviceOnlineLogDayIdList.size());
            List split = Lists.partition(deviceOnlineLogDayIdList, (int)1000);
            for (List deviceOnlineLogDayIds : split) {
                List deviceOnlineLogDayDetails = this.deviceOnlineLogDayDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().in(DeviceOnlineLogDayDetail::getDeviceOnlineLogDayId, (Collection)deviceOnlineLogDayIds));
                if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)deviceOnlineLogDayDetails)) continue;
                result.addAll(deviceOnlineLogDayDetails);
            }
            return result;
        }
        return Lists.newArrayList();
    }

    private List<DeviceOnlineLogDay> getListGroupByMacAndChannelId(Integer groupId, List<Integer> deptIds, LocalDate startLocalDate, LocalDate endLocalDate) {
        if (groupId == null) {
            return Lists.newArrayList();
        }
        return this.deviceOnlineLogDayMapper.getDeviceOnlineLogDayList(groupId, startLocalDate, endLocalDate);
    }

    static List<String> hourlyStatus(String detail) {
        ArrayList<String> res = new ArrayList<String>(Collections.nCopies(24, "00:00-59:59offline"));
        List<Interval> normalized = OnlineDetailServiceImpl.normalizeDetail(detail);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(normalized)) {
            return res;
        }
        for (int hour = 0; hour < 24; ++hour) {
            LocalTime hStart = LocalTime.of(hour, 0, 0);
            LocalTime hEnd = LocalTime.of(hour, 59, 59);
            ArrayList<CallSite> parts = new ArrayList<CallSite>();
            for (Interval interval : normalized) {
                if (interval.end.isBefore(hStart) || interval.start.isAfter(hEnd)) continue;
                LocalTime segStart = interval.start.isBefore(hStart) ? hStart : interval.start;
                LocalTime segEnd = interval.end.isAfter(hEnd) ? hEnd : interval.end;
                parts.add((CallSite)((Object)(OnlineDetailServiceImpl.formatMmSs(segStart) + "-" + OnlineDetailServiceImpl.formatMmSs(segEnd) + interval.status)));
            }
            res.set(hour, parts.isEmpty() ? "00:00-59:59offline" : String.join((CharSequence)", ", parts));
        }
        return res;
    }

    static String trimHourlyStatus(String window, String hourlySegments) {
        if (StringUtils.isBlank((CharSequence)hourlySegments)) {
            return hourlySegments;
        }
        String[] windowParts = window.split("-");
        if (windowParts.length != 2) {
            return hourlySegments;
        }
        LocalTime windowStart = LocalTime.parse(windowParts[0]);
        LocalTime windowEnd = LocalTime.parse(windowParts[1]);
        int winStartSec = windowStart.getMinute() * 60 + windowStart.getSecond();
        int winEndSec = windowEnd.getMinute() * 60 + windowEnd.getSecond();
        if (winEndSec < winStartSec) {
            return hourlySegments;
        }
        ArrayList<CallSite> resultSegments = new ArrayList<CallSite>();
        Matcher matcher = Pattern.compile("(\\d{2}:\\d{2})-(\\d{2}:\\d{2})(online|offline)").matcher(hourlySegments);
        while (matcher.find()) {
            int clippedEnd;
            int clippedStart;
            int startSec = OnlineDetailServiceImpl.parseMmSsToSeconds(matcher.group(1));
            int endSec = OnlineDetailServiceImpl.parseMmSsToSeconds(matcher.group(2));
            if (startSec < 0 || endSec < 0 || (clippedStart = Math.max(startSec, winStartSec)) > (clippedEnd = Math.min(endSec, winEndSec))) continue;
            resultSegments.add((CallSite)((Object)(OnlineDetailServiceImpl.formatMmSs(clippedStart) + "-" + OnlineDetailServiceImpl.formatMmSs(clippedEnd) + matcher.group(3))));
        }
        if (resultSegments.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)", ", resultSegments);
    }

    private List<TimeWindow> fetchCustomTimeWindows() {
        return Arrays.asList(new TimeWindow(LocalTime.of(3, 20, 0), LocalTime.of(7, 59, 59)), new TimeWindow(LocalTime.of(8, 0, 0), LocalTime.of(11, 59, 59)), new TimeWindow(LocalTime.of(12, 0, 0), LocalTime.of(17, 30, 0)));
    }

    private List<TimeWindow> expandToHourly(List<TimeWindow> windows) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(windows)) {
            return Collections.emptyList();
        }
        ArrayList<TimeWindow> res = new ArrayList<TimeWindow>();
        block0: for (TimeWindow window : windows) {
            LocalTime cursor = window.start;
            while (!cursor.isAfter(window.end)) {
                LocalTime hourEnd = LocalTime.of(cursor.getHour(), 59, 59);
                LocalTime sliceEnd = hourEnd.isBefore(window.end) ? hourEnd : window.end;
                res.add(new TimeWindow(cursor, sliceEnd));
                if (sliceEnd.equals(window.end)) continue block0;
                cursor = sliceEnd.plusSeconds(1L);
            }
        }
        return res;
    }

    static String sliceStatus(String detail, TimeWindow timeWindow) {
        List<Interval> normalized = OnlineDetailServiceImpl.normalizeDetail(detail);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(normalized)) {
            return "";
        }
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        for (Interval interval : normalized) {
            LocalTime segEnd;
            if (interval.end.isBefore(timeWindow.start) || interval.start.isAfter(timeWindow.end)) continue;
            LocalTime segStart = interval.start.isBefore(timeWindow.start) ? timeWindow.start : interval.start;
            LocalTime localTime = segEnd = interval.end.isAfter(timeWindow.end) ? timeWindow.end : interval.end;
            if (segStart.isAfter(segEnd)) continue;
            parts.add((CallSite)((Object)(OnlineDetailServiceImpl.formatHms(segStart) + "~" + OnlineDetailServiceImpl.formatHms(segEnd) + interval.status)));
        }
        return String.join((CharSequence)", ", parts);
    }

    private static List<Interval> normalizeDetail(String detail) {
        if (StringUtils.isBlank((CharSequence)detail)) {
            return Collections.emptyList();
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        Matcher m = Pattern.compile("(\\d{2}:\\d{2}:\\d{2})~(\\d{2}:\\d{2}:\\d{2})(online|offline)").matcher(detail);
        while (m.find()) {
            intervals.add(new Interval(LocalTime.parse(m.group(1)), LocalTime.parse(m.group(2)), m.group(3)));
        }
        intervals.sort(Comparator.comparing(o -> o.start));
        ArrayList<Interval> normalized = new ArrayList<Interval>();
        LocalTime cursor = LocalTime.MIN;
        LocalTime dayEnd = LocalTime.of(23, 59, 59);
        for (Interval interval : intervals) {
            LocalTime effectiveStart;
            LocalTime start = interval.start.isBefore(LocalTime.MIN) ? LocalTime.MIN : interval.start;
            LocalTime end = interval.end.isAfter(dayEnd) ? dayEnd : interval.end;
            if (end.isBefore(LocalTime.MIN) || start.isAfter(dayEnd) || end.isBefore(start)) continue;
            if (start.isAfter(cursor)) {
                normalized.add(new Interval(cursor, start, "offline"));
            }
            if (end.isBefore(effectiveStart = start.isBefore(cursor) ? cursor : start)) continue;
            normalized.add(new Interval(effectiveStart, end, interval.status));
            cursor = end.isAfter(cursor) ? end : cursor;
        }
        if (cursor.isBefore(dayEnd)) {
            normalized.add(new Interval(cursor, dayEnd, "offline"));
        }
        return normalized;
    }

    private static String formatHms(LocalTime time) {
        return time.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    private static String formatMmSs(LocalTime time) {
        return String.format("%02d:%02d", time.getMinute(), time.getSecond());
    }

    private static String formatMmSs(int secondOfHour) {
        int minute = secondOfHour / 60;
        int second = secondOfHour % 60;
        return String.format("%02d:%02d", minute, second);
    }

    private static int parseMmSsToSeconds(String mmss) {
        try {
            String[] parts = mmss.split(":");
            int minute = Integer.parseInt(parts[0]);
            int second = Integer.parseInt(parts[1]);
            if (minute < 0 || minute > 59 || second < 0 || second > 59) {
                return -1;
            }
            return minute * 60 + second;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public List<Integer> getDepIdsByOrganizeIdsByDepStatus(String organizeIds, Integer userGroupId, Integer userId, String depStatus) {
        if (Util.isEmpty((CharSequence)organizeIds) && userGroupId == null) {
            return Lists.newArrayList();
        }
        List depStatusList = new ArrayList();
        if (Objects.nonNull(depStatus)) {
            depStatusList = Util.convert2List((String)depStatus, Integer::parseInt, (String)",");
        }
        if (Util.isEmpty((CharSequence)organizeIds)) {
            try {
                BaseResult apiResult = this.userDepartmentApi.getDepIdsByUser(userId, userGroupId);
                if (!apiResult.getIsError().booleanValue()) {
                    if (!CollectionUtils.isEmpty(depStatusList)) {
                        DepAndTagsPojo var1 = new DepAndTagsPojo();
                        var1.setOpenStatue(depStatusList);
                        var1.setDepartmentIds((List)apiResult.getData());
                        BaseResult deptByIdAndStatusAndType = this.departmentApi.getDeptByIdAndStatusAndType(var1);
                        if (!deptByIdAndStatusAndType.getIsError().booleanValue()) {
                            return (List)deptByIdAndStatusAndType.getData();
                        }
                    }
                    return (List)apiResult.getData();
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u7528departmentApi.queryDeptIdsByUserId \u5931\u8d25,\u53c2\u6570{},\u5f02\u5e38\u5185\u5bb9{}", (Object)(userGroupId + "|" + userId), (Object)LogUtil.getStackTraceInfo((Exception)e));
            }
            return Lists.newArrayList();
        }
        try {
            BaseResult depIdsByOrganizeIds;
            DepIdsAndUserMo mo = new DepIdsAndUserMo();
            if (Util.isNotEmpty((CharSequence)organizeIds)) {
                mo.setOrganizeId(organizeIds);
            }
            mo.setUserGroupId(userGroupId);
            mo.setUserId(userId);
            if (!CollectionUtils.isEmpty(depStatusList)) {
                mo.setStatus(depStatusList);
            }
            if (!(depIdsByOrganizeIds = this.userDepartmentApi.getDepIdsByOrganizeIds(mo)).getIsError().booleanValue()) {
                return (List)depIdsByOrganizeIds.getData();
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528userDepartmentApi.getDepIdsByOrganizeIds \u5931\u8d25,\u53c2\u6570{},\u5f02\u5e38\u5185\u5bb9{}", (Object)(organizeIds + "|" + userGroupId + "|" + userId), (Object)LogUtil.getStackTraceInfo((Exception)e));
        }
        return Lists.newArrayList();
    }

    public List<DeviceStatus> getDeviceStatusListByGroupId(Integer groupId, Integer delFlag) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DeviceStatus::getGroupId, (Object)groupId);
        if (delFlag != null) {
            queryWrapper.eq(DeviceStatus::getIsDelete, (Object)delFlag);
        }
        return this.deviceStatusMapper.selectList((Wrapper)queryWrapper);
    }

    public List<DeviceStatus> getDeviceStatusByDepIds(List<Integer> depIds) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(depIds)) {
            return Lists.newArrayList();
        }
        return this.getDeviceStatusByDepIds(depIds, new ArrayList<Integer>());
    }

    public List<DeviceStatus> getDeviceStatusByDepIds(List<Integer> depIds, List<Integer> dTypeList) {
        ArrayList<DeviceStatus> result = new ArrayList<DeviceStatus>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(depIds)) {
            List split = Lists.partition(depIds, (int)1000);
            for (List item : split) {
                List deviceStatuses;
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)queryWrapper.in(DeviceStatus::getDepId, (Collection)item)).eq(DeviceStatus::getIsDelete, (Object)0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dTypeList)) {
                    queryWrapper.in(DeviceStatus::getDType, dTypeList);
                }
                if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(deviceStatuses = this.deviceStatusMapper.selectList((Wrapper)queryWrapper)))) continue;
                result.addAll(deviceStatuses);
            }
        }
        return result;
    }

    public Boolean isRootNode(String nodeCode, Integer groupId) {
        try {
            BaseResult organizeIsRootByCode = this.organizeApi.getOrganizeIsRootByCode(nodeCode, groupId);
            if (!organizeIsRootByCode.getIsError().booleanValue()) {
                return (Boolean)organizeIsRootByCode.getData();
            }
            log.error("organizeApi.getOrganizeIsRootByCode \u8c03\u7528\u5931\u8d25:{}", (Object)organizeIsRootByCode.toString());
            return false;
        }
        catch (Exception e) {
            log.error(LogUtil.getStackTraceInfo((Exception)e));
            throw new CommonException(ExceptionEnum.CLOUD_EXCEPTION);
        }
    }

    public Map<String, Object> replaceOnlineOffline(Map<String, Object> source) {
        if (source == null || source.isEmpty()) {
            return source;
        }
        source.replaceAll((k, v) -> {
            if (v instanceof String) {
                return ((String)v).replace("online", "\u5728\u7ebf").replace("offline", "\u79bb\u7ebf");
            }
            if (v instanceof List) {
                List list = (List)v;
                ArrayList<String> replaced = new ArrayList<String>(list.size());
                for (Object o : list) {
                    if (o instanceof String) {
                        replaced.add(((String)o).replace("online", "\u5728\u7ebf").replace("offline", "\u79bb\u7ebf"));
                        continue;
                    }
                    replaced.add((String)o);
                }
                return replaced;
            }
            return v;
        });
        return source;
    }

    private static class Interval {
        LocalTime start;
        LocalTime end;
        String status;

        Interval(LocalTime start, LocalTime end, String status) {
            this.start = start;
            this.end = end;
            this.status = status;
        }
    }

    private static class TimeWindow {
        LocalTime start;
        LocalTime end;
        String label;

        TimeWindow(LocalTime start, LocalTime end) {
            this.start = start;
            this.end = end;
            this.label = start.format(DateTimeFormatter.ofPattern("HH:mm:ss")) + "-" + end.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        }
    }
}

