/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.onlinereport.report;

import com.ovopark.device.common.util.DateUtils;
import com.ovopark.device.modules.onlinereport.OnlineDetailServiceImpl;
import com.ovopark.device.modules.onlinereport.report.OnlineDetailRequestVo;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.reportdevice.DeviceStatusRecordServiceImpl;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.device.platform.api.UserRoleFacade;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.Session;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.UserDepartmentApi;
import jakarta.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="/ovopark-device-report-form/deviceReport/deviceOnlineDetail")
public class DeviceOnlineDetailReport
implements JobOutTaskFlow<OnlineDetailRequestVo> {
    private static final Logger log = LoggerFactory.getLogger(DeviceOnlineDetailReport.class);
    @Autowired
    private RPCFacade rpcFacade;
    @Autowired
    private DeviceStatusService deviceStatusService;
    @Autowired
    private DeviceStatusRecordServiceImpl deviceStatusRecordService;
    @Autowired
    private DepartmentFacade departmentFacade;
    @Autowired
    private MessageSource messageSource;
    @Resource
    private UserDepartmentApi userDepartmentApi;
    @Resource
    private DepartmentApi departmentApi;
    @Autowired
    private OnlineDetailServiceImpl onlineDetailService;
    @Autowired
    private UserRoleFacade userRoleFacade;
    public static final DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public OnlineDetailRequestVo requestParamBody(String requestBody, Session session) throws NoPrivilegeException {
        log.info("requestParamBody : " + requestBody);
        log.info("session: " + JSONAccessor.impl().format((Object)session));
        OnlineDetailRequestVo onlineDetailRequestVo = (OnlineDetailRequestVo)JSONAccessor.impl().read(requestBody, OnlineDetailRequestVo.class);
        onlineDetailRequestVo.setLocale(session.clientInfo().getLocale());
        Integer sessionGroupId = session.getGroupId();
        if (sessionGroupId != null) {
            onlineDetailRequestVo.setGroupId(sessionGroupId);
        }
        onlineDetailRequestVo.setUserId(session.getUserId());
        return onlineDetailRequestVo;
    }

    public void execute(OnlineDetailRequestVo param, OutStore outStore) {
        Integer groupId = param.getGroupId();
        String types = param.getTypes();
        String deptNodes = param.getDeptNodes();
        String endDate = param.getEndDate();
        String startDate = param.getStartDate();
        String openStatusList = param.openStatusList;
        Locale locale = param.getLocale();
        Integer userId = param.getUserId();
        LocalDate startTime = null;
        LocalDate endTime = null;
        List<Object> strings = new ArrayList();
        try {
            startTime = LocalDate.parse(startDate, fmt);
            endTime = LocalDate.parse(endDate, fmt);
            String[] split = deptNodes.split(",");
            strings = Arrays.asList(split);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        String[] split = types.split(",");
        for (int i = 0; i < split.length; ++i) {
            typeList.add(Integer.valueOf(split[i]));
        }
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(",").append(string);
        }
        List<Integer> depIdsByOrganizeIds = this.onlineDetailService.getDepIdsByOrganizeIdsByDepStatus(sb.substring(1), groupId, userId, openStatusList);
        Boolean bl = this.userRoleFacade.isSuperAdmin(userId, groupId);
        boolean allGroupDeptFlag = false;
        if (strings.size() == 1 && bl.booleanValue() && this.onlineDetailService.isRootNode((String)strings.get(0), groupId).booleanValue()) {
            allGroupDeptFlag = true;
        }
        List<Object> deviceStatusList = new ArrayList();
        deviceStatusList = allGroupDeptFlag ? this.onlineDetailService.getDeviceStatusListByGroupId(groupId, 0) : this.onlineDetailService.getDeviceStatusByDepIds(depIdsByOrganizeIds);
        this.onlineDetailService.deviceOnlineDetail(deviceStatusList, groupId, startTime, endTime, allGroupDeptFlag, null, typeList, locale, outStore);
        outStore.feature().supportRangeMerge(true);
    }

    public JobOutTaskFlow.ExportTaskInfoProvider exportTaskInfoProvider(final OnlineDetailRequestVo requestParamBody, Session session) {
        return new JobOutTaskFlow.ExportTaskInfoProvider(){

            public String name() {
                String excelName = DeviceOnlineDetailReport.this.messageSource.getMessage("DeviceReport.device.sheet.excel", null, requestParamBody.getLocale()) + "_" + DateUtils.parseTime((LocalDateTime)LocalDateTime.now(), (DateUtils.Format)DateUtils.Format.LONG_DATE_FORMAT_NONE_CHAR);
                return excelName;
            }
        };
    }
}

