/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportOfflineDetail.service;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.modules.platform.DeviceOfflineDetailService;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceOfflineDetail;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.reportOfflineDetail.model.mo.DeviceOfflineDetailMo;
import com.ovopark.device.modules.reportOfflineDetail.model.vo.DeviceOfflineDetailVo;
import com.ovopark.device.modules.reportOfflineDetail.service.DeviceOfflineReportService;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.organize.common.model.mo.DepIdsAndUserMo;
import com.ovopark.organize.common.model.mo.DepartmentOrgMo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceOfflineReportServiceImpl
implements DeviceOfflineReportService {
    private static final Logger log = LoggerFactory.getLogger(DeviceOfflineReportServiceImpl.class);
    @Autowired
    private DeviceOfflineDetailService deviceOfflineDetailService;
    @Autowired
    private DeviceStatusService deviceStatusService;
    @Autowired
    private DepartmentFacade departmentFacade;

    @Override
    public List<DeviceOfflineDetailVo> getDeviceOfflineDetailList(Integer userId, DeviceOfflineDetailMo mo) {
        ArrayList<DeviceOfflineDetailVo> result = new ArrayList<DeviceOfflineDetailVo>();
        Map<Integer, DepartmentOrgMo> userDepList = this.getUserDepList(userId, mo.getOrgIds(), mo.getGroupId());
        if (userDepList == null || userDepList.isEmpty()) {
            return result;
        }
        ArrayList<Integer> depIds = new ArrayList<Integer>(userDepList.keySet());
        Integer groupId = mo.getGroupId();
        LocalDateTime offlineStartTime = StringUtils.isNotEmpty((CharSequence)mo.getOfflineStartTime()) ? LocalDateTime.parse(mo.getOfflineStartTime()) : null;
        LocalDateTime offlineEndTime = StringUtils.isNotEmpty((CharSequence)mo.getOfflineEndTime()) ? LocalDateTime.parse(mo.getOfflineEndTime()) : null;
        List offlineTypeList = null;
        ArrayList<Integer> deviceStatusIds = new ArrayList<Integer>();
        ArrayList<Integer> dtypeList = new ArrayList<Integer>();
        dtypeList.add(22);
        List mainDmsDeviceList = this.deviceStatusService.getMainDmsDeviceList(groupId, depIds, mo.getMac(), dtypeList);
        HashMap<Integer, DeviceStatus> deviceStatusMap = new HashMap<Integer, DeviceStatus>();
        for (DeviceStatus deviceStatus : mainDmsDeviceList) {
            deviceStatusIds.add(deviceStatus.getId());
            deviceStatusMap.put(deviceStatus.getId(), deviceStatus);
        }
        Long minOfflineSecond = mo.getMinOfflineSecond();
        Long maxOfflineSecond = mo.getMaxOfflineSecond();
        List deviceOfflineDetailList = this.deviceOfflineDetailService.getDeviceOfflineDetailList(deviceStatusIds, depIds, groupId, offlineStartTime, offlineEndTime, offlineTypeList, minOfflineSecond, maxOfflineSecond, mo.getPageNum(), mo.getPageSize());
        List pojoList = this.departmentFacade.getDepPathById(groupId, depIds);
        HashMap<Integer, String> depOrgNameMap = new HashMap<Integer, String>();
        if (CollectionUtils.isNotEmpty((Collection)pojoList)) {
            for (SimplePojo simplePojo : pojoList) {
                depOrgNameMap.put(simplePojo.getId(), simplePojo.getName());
            }
        }
        for (DeviceOfflineDetail item : deviceOfflineDetailList) {
            Integer deviceStatusId = item.getDeviceStatusId();
            DeviceStatus deviceStatus = (DeviceStatus)deviceStatusMap.get(deviceStatusId);
            DeviceOfflineDetailVo vo = new DeviceOfflineDetailVo();
            vo.setId(item.getId());
            vo.setOfflineSecond(item.getOfflineSecond());
            vo.setOfflineType(item.getOfflineType());
            vo.setMac(deviceStatus.getMac());
            vo.setDeviceStatusId(deviceStatusId);
            vo.setDeviceName(deviceStatus.getDeviceName());
            vo.setDepId(deviceStatus.getDepId());
            DepartmentOrgMo departmentOrgMo = userDepList.get(deviceStatus.getDepId());
            if (departmentOrgMo != null) {
                vo.setDepName(departmentOrgMo.getName());
            }
            vo.setOrgName((String)depOrgNameMap.get(deviceStatus.getDepId()));
            vo.setOnlineTime(this.timestampToLocalDateTime(item.getOnlineTimestamp()));
            vo.setOfflineTime(this.timestampToLocalDateTime(item.getOfflineTimestamp()));
            result.add(vo);
        }
        return result;
    }

    public Map<Integer, DepartmentOrgMo> getUserDepList(Integer userId, List<String> orgIds, Integer groupId) {
        DepIdsAndUserMo mo = new DepIdsAndUserMo();
        mo.setIsDel(Integer.valueOf(0));
        mo.setOrganizeIdList(orgIds);
        mo.setUserGroupId(groupId);
        mo.setUserId(userId);
        return this.departmentFacade.getUserDepNameMapNew(mo);
    }

    public LocalDateTime timestampToLocalDateTime(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(timestamp), ZoneId.systemDefault());
    }
}

