/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportOfflineDetail.kafka;

import com.ovopark.device.modules.platform.ConditionOnKafka;
import com.ovopark.device.modules.reportOfflineDetail.model.kafka.OfflineReasonBaseKafkaMsg;
import com.ovopark.device.modules.reportOfflineDetail.service.DeviceOfflineReportService;
import com.ovopark.kernel.shared.Util;
import com.ovopark.privilege.util.JsonUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnKafka
@Component
public class DeviceOfflineReasonKafkaInStream {
    private static final Logger log = LoggerFactory.getLogger(DeviceOfflineReasonKafkaInStream.class);
    @Autowired
    private DeviceOfflineReportService deviceOfflineDetailService;

    @KafkaListener(concurrency="${messagehub.control.sdk.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="OFFLINE_REASON", groupId="${device.offlineReason.kafka.group:deviceOfflineReason}", containerFactory="dmsKafkaContainerFactory", id="device-offline-reason")
    public void offlineReason(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        String value = (String)record.value();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset + ",offline reason value: " + value);
        OfflineReasonBaseKafkaMsg msg = (OfflineReasonBaseKafkaMsg)JsonUtils.jsonToBean((String)value, OfflineReasonBaseKafkaMsg.class);
        String msg1 = msg.getMsg();
        if ("offline_log".equals(msg.getMsgType()) && Util.isNotEmpty((CharSequence)msg1)) {
            OfflineReasonBaseKafkaMsg.OfflineLogBean offlineLogBean = (OfflineReasonBaseKafkaMsg.OfflineLogBean)JsonUtils.jsonToBean((String)msg1, OfflineReasonBaseKafkaMsg.OfflineLogBean.class);
            this.deviceOfflineDetailService.addLog(offlineLogBean.getDevMac(), offlineLogBean.getOnlineTime(), offlineLogBean.getOfflineTime(), offlineLogBean.getReasonType(), offlineLogBean.getDurationSeconds());
        }
    }
}

