/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportOfflineDetail.service;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.modules.platform.DeviceOfflineDetailService;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceOfflineDetail;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.reportOfflineDetail.model.mo.DeviceOfflineDetailMo;
import com.ovopark.device.modules.reportOfflineDetail.model.vo.DeviceOfflineDetailVo;
import com.ovopark.device.modules.reportOfflineDetail.report.DeviceOfflineDetailExcel;
import com.ovopark.device.modules.reportOfflineDetail.service.DeviceOfflineReportService;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.organize.common.model.mo.DepIdsAndUserMo;
import com.ovopark.organize.common.model.mo.DepartmentOrgMo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceOfflineReportServiceImpl
implements DeviceOfflineReportService {
    private static final Logger log = LoggerFactory.getLogger(DeviceOfflineReportServiceImpl.class);
    @Autowired
    private DeviceOfflineDetailService deviceOfflineDetailService;
    @Autowired
    private DeviceStatusService deviceStatusService;
    @Autowired
    private DepartmentFacade departmentFacade;
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @Override
    public void addLog(String mac, Long onlineTimestamp, Long offlineTimestamp, String offlineType, Long offlineSecond) {
        this.deviceOfflineDetailService.addLog(mac, onlineTimestamp, offlineTimestamp, offlineType, offlineSecond);
    }

    public List<DeviceOfflineDetailVo> getDeviceOfflineDetailList0(DeviceOfflineDetailMo mo, OutStore.SegmentWriter segmentWriter) {
        Integer userId = mo.getSessionUserId();
        Locale locale = mo.getLocale();
        Map<Integer, DepartmentOrgMo> userDepList = this.getUserDepList(userId, mo.getOrgIds(), mo.getGroupId());
        if (userDepList == null || userDepList.isEmpty()) {
            return List.of();
        }
        ArrayList<Integer> depIds = new ArrayList<Integer>(userDepList.keySet());
        Integer groupId = mo.getGroupId();
        LocalDateTime offlineStartTime = StringUtils.isNotEmpty((CharSequence)mo.getOfflineStartTime()) ? LocalDateTime.parse(mo.getOfflineStartTime(), this.formatter) : null;
        LocalDateTime offlineEndTime = StringUtils.isNotEmpty((CharSequence)mo.getOfflineEndTime()) ? LocalDateTime.parse(mo.getOfflineEndTime(), this.formatter) : null;
        List offlineTypeList = null;
        ArrayList<Integer> deviceStatusIds = new ArrayList<Integer>();
        ArrayList<Integer> dtypeList = new ArrayList<Integer>();
        dtypeList.add(22);
        List mainDmsDeviceList = this.deviceStatusService.getMainDmsDeviceList(groupId, depIds, mo.getMac(), dtypeList);
        HashMap<Integer, DeviceStatus> deviceStatusMap = new HashMap<Integer, DeviceStatus>();
        for (DeviceStatus deviceStatus : mainDmsDeviceList) {
            deviceStatusIds.add(deviceStatus.getId());
            deviceStatusMap.put(deviceStatus.getId(), deviceStatus);
        }
        Long minOfflineSecond = mo.getMinOfflineSecond();
        Long maxOfflineSecond = mo.getMaxOfflineSecond();
        List pojoList = this.departmentFacade.getDepPathById(groupId, depIds);
        HashMap<Integer, String> depOrgNameMap = new HashMap<Integer, String>();
        if (CollectionUtils.isNotEmpty((Collection)pojoList)) {
            for (SimplePojo simplePojo : pojoList) {
                depOrgNameMap.put(simplePojo.getId(), simplePojo.getName());
            }
        }
        if (segmentWriter == null) {
            List deviceOfflineDetailList = this.deviceOfflineDetailService.getDeviceOfflineDetailList(deviceStatusIds, depIds, groupId, offlineStartTime, offlineEndTime, offlineTypeList, minOfflineSecond, maxOfflineSecond, mo.getPageNum(), mo.getPageSize());
            ArrayList<DeviceOfflineDetailVo> result = new ArrayList<DeviceOfflineDetailVo>();
            for (DeviceOfflineDetail item : deviceOfflineDetailList) {
                Integer deviceStatusId = item.getDeviceStatusId();
                DeviceStatus deviceStatus = (DeviceStatus)deviceStatusMap.get(deviceStatusId);
                DeviceOfflineDetailVo vo = new DeviceOfflineDetailVo();
                vo.setId(item.getId());
                vo.setOfflineSecond(item.getOfflineSecond());
                vo.setOfflineType(item.getOfflineType());
                vo.setOfflineTypeStr(this.offlineTypeToStr(item.getOfflineType(), locale));
                vo.setDevBigType(this.dtypeToBigType(deviceStatus.getDType(), Locale.CHINA));
                vo.setDeviceType(deviceStatus.getDeviceType());
                vo.setMac(deviceStatus.getMac());
                vo.setDeviceStatusId(deviceStatusId);
                vo.setDeviceName(deviceStatus.getDeviceName());
                vo.setDepId(deviceStatus.getDepId());
                DepartmentOrgMo departmentOrgMo = userDepList.get(deviceStatus.getDepId());
                if (departmentOrgMo != null) {
                    vo.setDepName(departmentOrgMo.getName());
                }
                vo.setOrgName((String)depOrgNameMap.get(deviceStatus.getDepId()));
                vo.setOnlineTime(this.timestampToLocalDateTime(item.getOnlineTimestamp()));
                vo.setOfflineTime(this.timestampToLocalDateTime(item.getOfflineTimestamp()));
                result.add(vo);
            }
            return result;
        }
        long pageNum = (Long)Util.convert2Self((Object)mo.getPageNum(), (Object)1L);
        List deviceOfflineDetailList;
        while (!Util.isEmpty((Collection)(deviceOfflineDetailList = this.deviceOfflineDetailService.getDeviceOfflineDetailList(deviceStatusIds, depIds, groupId, offlineStartTime, offlineEndTime, offlineTypeList, minOfflineSecond, maxOfflineSecond, Long.valueOf(pageNum), mo.getPageSize())))) {
            for (DeviceOfflineDetail item : deviceOfflineDetailList) {
                Integer deviceStatusId = item.getDeviceStatusId();
                DeviceStatus deviceStatus = (DeviceStatus)deviceStatusMap.get(deviceStatusId);
                DeviceOfflineDetailExcel offlineDetailExcel = new DeviceOfflineDetailExcel();
                String f = Util.formatTime((int)((int)(item.getOfflineSecond() * 1000L)), (int)1, (String)"\u5c0f\u65f6", (String)"\u5206\u949f", (String)"\u79d2");
                offlineDetailExcel.setOfflineKeepTime(f);
                offlineDetailExcel.setOfflineReason(this.offlineTypeToStr(item.getOfflineType(), locale));
                offlineDetailExcel.setDevBigType(this.dtypeToBigType(deviceStatus.getDType(), Locale.CHINA));
                offlineDetailExcel.setDeviceType(deviceStatus.getDeviceType());
                offlineDetailExcel.setMac(deviceStatus.getMac());
                offlineDetailExcel.setDeviceName(deviceStatus.getDeviceName());
                DepartmentOrgMo departmentOrgMo = userDepList.get(deviceStatus.getDepId());
                if (departmentOrgMo != null) {
                    offlineDetailExcel.setDepName(departmentOrgMo.getName());
                }
                offlineDetailExcel.setOrgName((String)depOrgNameMap.get(deviceStatus.getDepId()));
                offlineDetailExcel.setOfflineTime(this.timestampToLocalDateTime(item.getOfflineTimestamp()));
                segmentWriter.append((Model)offlineDetailExcel);
            }
            ++pageNum;
        }
        return List.of();
    }

    private String dtypeToBigType(Integer dtype, Locale locale) {
        switch (dtype) {
            case 22: {
                return "\u7f51\u7ba1\u6444\u50cf\u5934";
            }
            case 2: 
            case 20: {
                return "\u5f55\u50cf\u673a";
            }
        }
        return "\u5176\u4ed6";
    }

    private String offlineTypeToStr(String offlineType, Locale locale) {
        switch (offlineType) {
            case "POWER_FAILURE": {
                return "\u65ad\u7535";
            }
            case "NETWORK_FAILURE": {
                return "\u65ad\u7f51";
            }
            case "NETWORK_FLUCTUATION": {
                return "\u7f51\u7edc\u6ce2\u52a8";
            }
        }
        return "\u5176\u4ed6\u539f\u56e0";
    }

    public Map<Integer, DepartmentOrgMo> getUserDepList(Integer userId, List<String> orgIds, Integer groupId) {
        DepIdsAndUserMo mo = new DepIdsAndUserMo();
        mo.setIsDel(Integer.valueOf(0));
        mo.setOrganizeIdList(orgIds);
        mo.setUserGroupId(groupId);
        mo.setUserId(userId);
        return this.departmentFacade.getUserDepNameMapNew(mo);
    }

    public LocalDateTime timestampToLocalDateTime(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(timestamp), ZoneId.systemDefault());
    }

    @Override
    public List<DeviceOfflineDetailVo> getDeviceOfflineDetailList(DeviceOfflineDetailMo mo) {
        return this.getDeviceOfflineDetailList0(mo, null);
    }

    @Override
    public void getDeviceOfflineDetailList4Report(DeviceOfflineDetailMo mo, OutStore.SegmentWriter segmentWriter) {
        this.getDeviceOfflineDetailList0(mo, segmentWriter);
    }
}

