/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportdevice;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.ovopark.device.common.util.DateUtils;
import com.ovopark.device.common.util.ListUtil;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.common.util.StringUtil;
import com.ovopark.device.modules.platform.Device18Service;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.reportdevice.DeviceStatusRecordPojo;
import com.ovopark.device.modules.reportdevice.DeviceStatusRecordService;
import com.ovopark.device.modules.reportdevice.ReportDeviceConfig;
import com.ovopark.device.modules.reportdevice.mysql.DeviceStatusRecord;
import com.ovopark.device.modules.reportdevice.mysql.DeviceStatusRecordMapper;
import com.ovopark.device.modules.reportdevice.mysql.DeviceStatusRecordMonth;
import com.ovopark.device.modules.reportdevice.mysql.DeviceStatusRecordMonthMapper;
import com.ovopark.device.modules.reportdevice.vo.DeviceOnlineRateVo;
import com.ovopark.device.modules.reportdevice.vo.DeviceRecordCountVo;
import com.ovopark.device.modules.reportdevice.vo.DeviceRecordVo;
import com.ovopark.device.modules.reportdevice.vo.DeviceStatusReportVo;
import com.ovopark.device.modules.reportdevice.vo.EchartDataVo;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.device.platform.api.OnlineFacade;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.device.platform.api.UserDepartmentPrivilegeFacade;
import com.ovopark.device.platform.api.UsersFacade;
import com.ovopark.device.platform.api.model.OnOffVo;
import com.ovopark.device.signalling.contact.VersionConstant;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.PageModel;
import com.ovopark.module.shared.Session;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.SimpleNamePojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.privilege.pojo.UsersPojo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceStatusRecordServiceImpl
implements DeviceStatusRecordService {
    private static final Logger log = LoggerFactory.getLogger(DeviceStatusRecordServiceImpl.class);
    @Autowired
    private DeviceStatusRecordMonthMapper deviceStatusRecordMonthMapper;
    @Autowired
    private RPCFacade rpcService;
    @Autowired
    private DeviceStatusService deviceStatusService;
    @Autowired
    private Device18Service device18Service;
    @Autowired
    private DepartmentFacade departmentFacade;
    @Autowired
    private UsersFacade usersFacade;
    @Autowired
    private UserDepartmentPrivilegeFacade userDepartmentPrivilegeFacade;
    @Autowired
    private ReportDeviceConfig reportDeviceConfig;
    @Autowired
    private DeviceStatusRecordMapper deviceStatusRecordMapper;
    @Autowired
    private OnlineFacade onlineFacadeRPC;
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
    public static final int ON_LINE = 1;
    public static final int OFF_LINE = 0;
    public static final int ALL_LINE = 2;

    @Override
    public Map<Integer, String> queryRecordMonth(Integer groupId, Integer startDay, Integer endDay, Integer startMonth, Integer endMonth, Integer startYear, Integer endYear, Integer runningDays) {
        HashMap<Integer, String> deviceOnlineStrMap = new HashMap<Integer, String>();
        if ((runningDays == null || endDay >= runningDays) && startYear.equals(endYear) && startMonth.equals(endMonth)) {
            List deviceStatusRecordMonths = this.deviceStatusRecordMonthMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatusRecordMonth::getGroupId, (Object)groupId)).eq(DeviceStatusRecordMonth::getYear, (Object)startYear)).eq(DeviceStatusRecordMonth::getMonth, (Object)startMonth));
            for (DeviceStatusRecordMonth item : deviceStatusRecordMonths) {
                Integer deviceStatusId = item.getDeviceStatusId();
                String onlineStr = item.getOnlineStr();
                String substring = onlineStr.substring(startDay - 1, endDay);
                deviceOnlineStrMap.put(deviceStatusId, substring);
            }
        } else if (startYear.equals(endYear)) {
            String substring;
            String onlineStr;
            Integer deviceStatusId;
            if (endMonth - startMonth != 1) {
                return deviceOnlineStrMap;
            }
            List deviceStatusRecordMonths = this.deviceStatusRecordMonthMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatusRecordMonth::getGroupId, (Object)groupId)).eq(DeviceStatusRecordMonth::getYear, (Object)startYear)).eq(DeviceStatusRecordMonth::getMonth, (Object)endMonth));
            for (DeviceStatusRecordMonth item : deviceStatusRecordMonths) {
                deviceStatusId = item.getDeviceStatusId();
                onlineStr = item.getOnlineStr();
                substring = onlineStr.substring(0, endDay);
                deviceOnlineStrMap.put(deviceStatusId, substring);
            }
            deviceStatusRecordMonths = this.deviceStatusRecordMonthMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatusRecordMonth::getGroupId, (Object)groupId)).eq(DeviceStatusRecordMonth::getYear, (Object)startYear)).eq(DeviceStatusRecordMonth::getMonth, (Object)startMonth));
            for (DeviceStatusRecordMonth item : deviceStatusRecordMonths) {
                deviceStatusId = item.getDeviceStatusId();
                onlineStr = item.getOnlineStr();
                substring = onlineStr.substring(startDay - 1, DeviceStatusRecordServiceImpl.getDayNum(startYear, startMonth));
                String s = (String)deviceOnlineStrMap.get(deviceStatusId);
                if (!Util.isNotEmpty((CharSequence)s)) continue;
                deviceOnlineStrMap.put(deviceStatusId, substring + s);
            }
        } else {
            String substring;
            String onlineStr;
            Integer deviceStatusId;
            List deviceStatusRecordMonths = this.deviceStatusRecordMonthMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatusRecordMonth::getGroupId, (Object)groupId)).eq(DeviceStatusRecordMonth::getYear, (Object)startYear)).eq(DeviceStatusRecordMonth::getMonth, (Object)endMonth));
            for (DeviceStatusRecordMonth item : deviceStatusRecordMonths) {
                deviceStatusId = item.getDeviceStatusId();
                onlineStr = item.getOnlineStr();
                substring = onlineStr.substring(0, endDay);
                deviceOnlineStrMap.put(deviceStatusId, substring);
            }
            deviceStatusRecordMonths = this.deviceStatusRecordMonthMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatusRecordMonth::getGroupId, (Object)groupId)).eq(DeviceStatusRecordMonth::getYear, (Object)startYear)).eq(DeviceStatusRecordMonth::getMonth, (Object)startMonth));
            for (DeviceStatusRecordMonth item : deviceStatusRecordMonths) {
                deviceStatusId = item.getDeviceStatusId();
                onlineStr = item.getOnlineStr();
                substring = onlineStr.substring(startDay, DeviceStatusRecordServiceImpl.getDayNum(startYear, startMonth));
                String s = (String)deviceOnlineStrMap.get(deviceStatusId);
                if (!Util.isNotEmpty((CharSequence)s)) continue;
                deviceOnlineStrMap.put(deviceStatusId, substring + s);
            }
        }
        return deviceOnlineStrMap;
    }

    private static Integer getDayNum(Integer year, Integer month) {
        String monthStr = month < 10 ? "0" + month : "" + month;
        String date = year + monthStr + "01";
        try {
            Date parse = simpleDateFormat.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            return calendar.getActualMaximum(5);
        }
        catch (ParseException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)e));
            return 0;
        }
    }

    @Override
    public PageModel<DeviceRecordVo> getDeptDeviceRecordListTotal(String startDate, String endDate, Integer runningDays, Integer pageNum, Integer pageSize, String organizeId, Integer groupId, Integer type, Integer devType, Integer openStatus, String deviceTypes, List<Integer> deptTagList, Integer userId, Locale locale) {
        List<Object> deviceTypeList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)deviceTypes)) {
            String[] split = deviceTypes.split(",");
            deviceTypeList = Arrays.asList(split);
        }
        ArrayList<String> orgidList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            orgidList.addAll(Arrays.asList(split));
        }
        ArrayList<Integer> openStatusList = new ArrayList<Integer>();
        if (openStatus != null) {
            openStatusList.add(openStatus);
        }
        DepAndTagsPojo depAndTagsPojo = new DepAndTagsPojo();
        depAndTagsPojo.setOpenStatue(openStatusList);
        depAndTagsPojo.setUserId(userId);
        depAndTagsPojo.setGroupId(groupId);
        ArrayList<Object> typeIds = new ArrayList<Object>();
        if (Util.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            typeIds.addAll(Arrays.asList(split));
        }
        if (Util.isNotEmpty(deptTagList)) {
            typeIds.addAll(deptTagList.stream().map(v -> "T_" + v).collect(Collectors.toList()));
        }
        if (Util.isEmpty(typeIds)) {
            Integer rootOrganize = this.rpcService.getRootOrganize(groupId);
            typeIds.add("O_" + rootOrganize);
        }
        depAndTagsPojo.setTypeIds(typeIds);
        depAndTagsPojo.setContainAll(Boolean.valueOf(false));
        List deptIdList = this.rpcService.getUserPrivilegeDepByOrganizeIdsAndUser(depAndTagsPojo);
        List departmentList = this.rpcService.departmentList(deptIdList);
        Map<Integer, DepartmentPojo> userDepNameMapNew = departmentList.stream().collect(Collectors.toMap(DepartmentPojo::getId, v -> v));
        depAndTagsPojo = new DepAndTagsPojo();
        depAndTagsPojo.setDepartmentIds(deptIdList);
        depAndTagsPojo.setGroupId(groupId);
        Map tagByDepIdList = this.rpcService.getTagByDepIdList(depAndTagsPojo);
        HashMap<Integer, String> deptTagNameMap = new HashMap<Integer, String>();
        for (Map.Entry entry : tagByDepIdList.entrySet()) {
            Integer key = (Integer)entry.getKey();
            String s = ((List)entry.getValue()).stream().map(SimpleNamePojo::getName).collect(Collectors.joining(","));
            deptTagNameMap.put(key, s);
        }
        List depList = deptIdList;
        ArrayList<Integer> excludeDtypeList = new ArrayList<Integer>();
        excludeDtypeList.add(62);
        List userDeviceStatus = this.deviceStatusService.getUserDeviceStatus(userId, groupId, depList, null, excludeDtypeList);
        String[] startDateSplit = startDate.split("-");
        String[] endDateSplit = endDate.split("-");
        Map<Integer, String> queryRecordMonthMap = this.queryRecordMonth(groupId, Integer.parseInt(startDateSplit[2]), Integer.parseInt(endDateSplit[2]), Integer.parseInt(startDateSplit[1]), Integer.parseInt(endDateSplit[1]), Integer.parseInt(startDateSplit[0]), Integer.parseInt(endDateSplit[0]), runningDays);
        ArrayList<DeviceRecordVo> depDeviceStatusVoListFromDeviceStatusRecord = new ArrayList<DeviceRecordVo>();
        LocalDateTime dateTime = LocalDateTime.parse(endDate + " 23:59:59", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDate startDay = LocalDateTime.parse(startDate + " 23:59:59", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).toLocalDate();
        Long dataDays = dateTime.toLocalDate().toEpochDay() - startDay.toEpochDay() + 1L;
        System.out.println("dataDays" + dataDays);
        block9: for (DeviceStatus deviceStatus : userDeviceStatus) {
            Integer depId;
            String onlineStr;
            LocalDateTime createTime = deviceStatus.getCreateTime();
            if (createTime == null || createTime.isAfter(dateTime)) continue;
            Integer deviceStatusId = deviceStatus.getId();
            Integer dType = deviceStatus.getDType();
            String deviceType = deviceStatus.getDeviceType();
            if (Util.isNotEmpty(deviceTypeList) && !deviceTypeList.contains(deviceType) || StringUtils.isEmpty((CharSequence)(onlineStr = queryRecordMonthMap.get(deviceStatusId)))) continue;
            try {
                if (runningDays != null && onlineStr.substring(onlineStr.length() - runningDays).contains("1")) {
                }
            }
            catch (Exception e) {}
            continue;
            if (devType != null) {
                switch (devType) {
                    case 1: {
                        if (VersionConstant.box.contains(dType)) break;
                        continue block9;
                    }
                    case 2: {
                        if (VersionConstant.ipc.contains(dType)) break;
                        continue block9;
                    }
                    case 3: {
                        if (VersionConstant.alg.contains(dType)) break;
                        continue block9;
                    }
                    case 4: {
                        if (22 == dType) break;
                        continue block9;
                    }
                }
            }
            if ((depId = deviceStatus.getDepId()) == null) continue;
            DeviceRecordVo deviceRecordVo2 = new DeviceRecordVo();
            DepartmentPojo departmentTagSimpleVo = userDepNameMapNew.get(depId);
            if (departmentTagSimpleVo == null) continue;
            deviceRecordVo2.setMenDianId(departmentTagSimpleVo.getId());
            deviceRecordVo2.setDeptName(departmentTagSimpleVo.getName());
            deviceRecordVo2.setShopId(departmentTagSimpleVo.getShopId());
            deviceRecordVo2.setOpenStatus(departmentTagSimpleVo.getOpenStatus());
            deviceRecordVo2.setDeviceName(deviceStatus.getDeviceName());
            deviceRecordVo2.setMac(deviceStatus.getMac());
            deviceRecordVo2.setDeviceTypeName(this.device18Service.dType_18(deviceStatus.getDType(), locale));
            deviceRecordVo2.setDeviceType(deviceStatus.getDeviceType());
            deviceRecordVo2.setRegisterTime(DateUtils.parseTime((LocalDateTime)createTime, (DateUtils.Format)DateUtils.Format.LONG_DATE_FORMAT_SLASH));
            if (createTime.toLocalDate().compareTo(dateTime.toLocalDate()) > 0) {
                deviceRecordVo2.setOnlineStr(StringUtil.flushLeft((String)"0", (int)dataDays.intValue(), (String)"0"));
            } else if (createTime.toLocalDate().compareTo(startDay) > 0) {
                Long d = dateTime.toLocalDate().toEpochDay() - createTime.toLocalDate().toEpochDay();
                deviceRecordVo2.setOnlineStr(StringUtil.flushLeft((String)"0", (int)dataDays.intValue(), (String)onlineStr.substring(onlineStr.length() - 1 - d.intValue())));
            } else {
                deviceRecordVo2.setOnlineStr(onlineStr);
            }
            deviceRecordVo2.setDeviceStatusId(deviceStatusId);
            deviceRecordVo2.setTagNames((String)deptTagNameMap.get(deviceRecordVo2.getMenDianId()));
            depDeviceStatusVoListFromDeviceStatusRecord.add(deviceRecordVo2);
        }
        int size = depDeviceStatusVoListFromDeviceStatusRecord.size();
        List list = ListUtil.subList(depDeviceStatusVoListFromDeviceStatusRecord, (Integer)pageNum, (Integer)pageSize);
        PageModel result = new PageModel();
        result.setTotal((long)size);
        result.setPageNumber((long)pageNum.intValue());
        result.setPageSize(pageSize.intValue());
        result.setData(list);
        List shopIdList = list.stream().filter(deviceStatusReportVo -> deviceStatusReportVo.getMenDianId() != null).map(deviceRecordVo -> (int)deviceRecordVo.getMenDianId()).collect(Collectors.toList());
        List pojoList = this.departmentFacade.getDepPathById(groupId, shopIdList);
        if (Util.isNotEmpty((Collection)pojoList)) {
            block10: for (DeviceRecordVo deviceRecordVo3 : list) {
                for (SimplePojo simplePojo : pojoList) {
                    if (deviceRecordVo3.getMenDianId() == null || deviceRecordVo3.getMenDianId().compareTo(simplePojo.getId()) != 0) continue;
                    deviceRecordVo3.setOrgName(simplePojo.getName());
                    continue block10;
                }
            }
        }
        return result;
    }

    @Override
    public EchartDataVo getDeviceStatusTrend(Integer userId, Integer enterpriseId, String organizeId, String startTime, String endTime, Integer type, Integer lang, Integer devType, List<String> deviceTypeList, Integer openStatus, List<Integer> deptTagList) {
        UsersPojo user = this.usersFacade.getUsersById(userId);
        if (user != null && user.getGroupId() != null) {
            enterpriseId = user.getGroupId();
        }
        ArrayList<Integer> openStatusList = new ArrayList<Integer>();
        if (openStatus != null) {
            openStatusList.add(openStatus);
        }
        DepAndTagsPojo depAndTagsPojo = new DepAndTagsPojo();
        depAndTagsPojo.setOpenStatue(openStatusList);
        depAndTagsPojo.setUserId(userId);
        depAndTagsPojo.setGroupId(enterpriseId);
        ArrayList<Object> typeIds = new ArrayList<Object>();
        if (Util.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            typeIds.addAll(Arrays.asList(split));
        }
        if (Util.isNotEmpty(deptTagList)) {
            typeIds.addAll(deptTagList.stream().map(v -> "T_" + v).collect(Collectors.toList()));
        }
        if (Util.isEmpty(typeIds)) {
            Integer rootOrganize = this.rpcService.getRootOrganize(enterpriseId);
            typeIds.add("O_" + rootOrganize);
        }
        depAndTagsPojo.setTypeIds(typeIds);
        depAndTagsPojo.setContainAll(Boolean.valueOf(false));
        List deptIdList = this.rpcService.getUserPrivilegeDepByOrganizeIdsAndUser(depAndTagsPojo);
        return this.getTrendData(userId, enterpriseId, startTime, endTime, deptIdList, type, lang, devType, deviceTypeList);
    }

    /*
     * WARNING - void declaration
     */
    private EchartDataVo getTrendData(Integer userId, Integer enterpriseId, String startTime, String endTime, List<Integer> depIds, Integer type, Integer lang, Integer devType, List<String> deviceTypeList) {
        EchartDataVo charts = null;
        ArrayList dataName = new ArrayList();
        ArrayList<String> categories = new ArrayList<String>();
        List userDeviceStatus = this.deviceStatusService.getDeviceStatusList(enterpriseId, depIds, new ArrayList(), deviceTypeList);
        HashMap<Integer, LocalDate> deviceStatusIdAndCreateTimeMap = new HashMap<Integer, LocalDate>();
        block10: for (DeviceStatus deviceStatus : userDeviceStatus) {
            LocalDateTime createTime;
            Integer dType = deviceStatus.getDType();
            String string = deviceStatus.getDeviceType();
            if (Util.isNotEmpty(deviceTypeList) && !deviceTypeList.contains(string) || dType == 62) continue;
            if (devType != null) {
                switch (devType) {
                    case 1: {
                        if (VersionConstant.box.contains(dType)) break;
                        continue block10;
                    }
                    case 2: {
                        if (VersionConstant.ipc.contains(dType)) break;
                        continue block10;
                    }
                    case 3: {
                        if (VersionConstant.alg.contains(dType)) break;
                        continue block10;
                    }
                    case 4: {
                        if (22 == dType) break;
                        continue block10;
                    }
                }
            }
            if ((createTime = deviceStatus.getCreateTime()) == null) continue;
            deviceStatusIdAndCreateTimeMap.put(deviceStatus.getId(), createTime.toLocalDate());
        }
        if (Util.isNotEmpty((Collection)userDeviceStatus)) {
            Integer groupDataFlag = 0;
            List<Map<String, Object>> data = this.getDeviceStatusRecordList(enterpriseId, startTime, endTime, deviceStatusIdAndCreateTimeMap, groupDataFlag);
            for (Map map : data) {
                String recordTime;
                if (!dataName.contains(map.get("online").toString())) {
                    dataName.add(map.get("online").toString());
                }
                if (categories.contains(recordTime = DeviceStatusRecordServiceImpl.getShowTimeStr(map.get("recordTime").toString(), 2))) continue;
                categories.add(recordTime);
            }
            this.augment(categories, startTime, endTime);
            Collections.sort(categories);
            dataName = lang == 0 ? new ArrayList<String>(){
                private static final long serialVersionUID = 5272468575242893778L;
                {
                    this.add("\u79bb\u7ebf");
                    this.add("\u5728\u7ebf");
                    this.add("\u5168\u90e8");
                }
            } : new ArrayList<String>(){
                private static final long serialVersionUID = 4419564756424446303L;
                {
                    this.add("Offline");
                    this.add("Online");
                    this.add("Total");
                }
            };
            List<Map<String, Object>> series = this.createSeries(data, dataName, categories);
            charts = new EchartDataVo("", dataName, categories, series);
            switch (type) {
                case 1: {
                    Map<String, Object> serial;
                    void var18_22;
                    boolean bl = false;
                    while (var18_22 < series.size()) {
                        serial = series.get((int)var18_22);
                        if (((String)dataName.get(1)).equals(serial.get("name"))) {
                            series.remove((int)var18_22);
                        }
                        ++var18_22;
                    }
                    dataName.remove(1);
                    break;
                }
                case 2: {
                    void var18_24;
                    Map<String, Object> serial;
                    boolean bl = false;
                    while (var18_24 < series.size()) {
                        serial = series.get((int)var18_24);
                        if (((String)dataName.get(0)).equals(serial.get("name"))) {
                            series.remove((int)var18_24);
                        }
                        ++var18_24;
                    }
                    dataName.remove(0);
                    break;
                }
            }
        }
        return charts;
    }

    private List<Map<String, Object>> getDeviceStatusRecordList(Integer groupId, String startTime, String endTime, Map<Integer, LocalDate> deviceStatusIdAndCreateTimeMap, Integer groupDataFlag) {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        List<DeviceStatusRecordPojo> onlineDeviceStatusRecordList = this.getDeviceStatusRecordCountByOnlineAndRecordTime(groupId, 1, startTime, endTime, deviceStatusIdAndCreateTimeMap, groupDataFlag);
        List<Map<String, Object>> onlineMap = this.createMap(onlineDeviceStatusRecordList, 1);
        List<DeviceStatusRecordPojo> offlineDeviceStatusRecordList = this.getDeviceStatusRecordCountByOnlineAndRecordTime(groupId, 0, startTime, endTime, deviceStatusIdAndCreateTimeMap, groupDataFlag);
        List<Map<String, Object>> offlineMap = this.createMap(offlineDeviceStatusRecordList, 0);
        List<DeviceStatusRecordPojo> alllineDeviceStatusRecordList = this.getDeviceStatusRecordCountByOnlineAndRecordTime(groupId, null, startTime, endTime, deviceStatusIdAndCreateTimeMap, groupDataFlag);
        List<Map<String, Object>> alllineMap = this.createMap(alllineDeviceStatusRecordList, 2);
        data.addAll(onlineMap);
        data.addAll(offlineMap);
        data.addAll(alllineMap);
        return data;
    }

    private List<Map<String, Object>> createMap(List<DeviceStatusRecordPojo> deviceStatusRecordList, Integer type) {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (DeviceStatusRecordPojo deviceStatusRecord : deviceStatusRecordList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("online", type);
            map.put("total", deviceStatusRecord.getTotal());
            map.put("recordTime", DateUtils.parseTime((LocalDateTime)deviceStatusRecord.getRecordTime()));
            data.add(map);
        }
        return data;
    }

    @Override
    public List<DeviceStatusRecordPojo> getDeviceStatusRecordCountByOnlineAndRecordTime(Integer groupId, Integer online, String startTime, String endTime, Map<Integer, LocalDate> deviceStatusIdAndCreateTimeMap, Integer groupDataFlag) {
        if (this.reportDeviceConfig.getGetDeviceStatusRecordCountByOnlineAndRecordTimeNewFlag() == 1) {
            return this.getDeviceStatusRecordCountByOnlineAndRecordTimeNew(groupId, online, startTime, endTime, deviceStatusIdAndCreateTimeMap, groupDataFlag);
        }
        if (groupId != null && Util.isNotEmpty(deviceStatusIdAndCreateTimeMap)) {
            ArrayList<DeviceStatusRecordPojo> resultList = new ArrayList<DeviceStatusRecordPojo>();
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDate startDate = LocalDate.parse(startTime, dateTimeFormatter);
            LocalDate endDate = LocalDate.parse(endTime, dateTimeFormatter);
            while (startDate.compareTo(endDate) <= 0) {
                StringBuilder deviceIdsStr = new StringBuilder(deviceStatusIdAndCreateTimeMap.keySet().size() * 11);
                for (Integer item : deviceStatusIdAndCreateTimeMap.keySet()) {
                    LocalDate date = deviceStatusIdAndCreateTimeMap.get(item);
                    if (date == null || date.compareTo(startDate) > 0) continue;
                    deviceIdsStr.append(item).append(",");
                }
                if (StringUtils.isNotEmpty((CharSequence)deviceIdsStr)) {
                    deviceIdsStr.setLength(deviceIdsStr.length() - 1);
                    String a = "(" + String.valueOf(deviceIdsStr) + ")";
                    DeviceStatusRecordPojo deviceStatusRecordCountByOnlineAndRecordTime = this.deviceStatusRecordMapper.getDeviceStatusRecordCountByOnlineAndRecordTime(groupId, online, startDate.toString() + " 00:00:00", a, groupDataFlag);
                    if (deviceStatusRecordCountByOnlineAndRecordTime != null) {
                        resultList.add(deviceStatusRecordCountByOnlineAndRecordTime);
                    }
                }
                startDate = startDate.plusDays(1L);
            }
            return resultList;
        }
        return new ArrayList<DeviceStatusRecordPojo>();
    }

    private List<DeviceStatusRecordPojo> getDeviceStatusRecordCountByOnlineAndRecordTimeNew(Integer groupId, Integer online, String startTime, String endTime, Map<Integer, LocalDate> deviceStatusIdAndCreateTimeMap, Integer groupDataFlag) {
        if (groupId != null && Util.isNotEmpty(deviceStatusIdAndCreateTimeMap)) {
            ArrayList<DeviceStatusRecordPojo> resultList = new ArrayList<DeviceStatusRecordPojo>();
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDate startDate = LocalDate.parse(startTime, dateTimeFormatter);
            LocalDate endDate = LocalDate.parse(endTime, dateTimeFormatter);
            HashSet<Integer> deviceIds = new HashSet<Integer>();
            for (Map.Entry<Integer, LocalDate> entry : deviceStatusIdAndCreateTimeMap.entrySet()) {
                LocalDate date = entry.getValue();
                if (date == null || date.compareTo(startDate) > 0) continue;
                deviceIds.add(entry.getKey());
            }
            if (!deviceIds.isEmpty()) {
                String deviceIdsStr = deviceIds.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
                while (startDate.compareTo(endDate) <= 0) {
                    DeviceStatusRecordPojo deviceStatusRecordCountByOnlineAndRecordTime = this.deviceStatusRecordMapper.getDeviceStatusRecordCountByOnlineAndRecordTime(groupId, online, startDate.toString() + " 00:00:00", deviceIdsStr, groupDataFlag);
                    if (deviceStatusRecordCountByOnlineAndRecordTime != null) {
                        resultList.add(deviceStatusRecordCountByOnlineAndRecordTime);
                    }
                    startDate = startDate.plusDays(1L);
                }
            }
            return resultList;
        }
        return new ArrayList<DeviceStatusRecordPojo>();
    }

    public static String getShowTimeStr(String dateStr, int timeType) {
        Object output = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)e));
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (timeType) {
            case 0: {
                output = dateStr.substring(11, 16);
                break;
            }
            case 1: {
                output = dateStr.substring(11, 16);
                if (!"00:00".equals(output)) break;
                output = "24:00";
                break;
            }
            case 2: {
                output = dateStr.substring(0, 10);
                break;
            }
            case 3: {
                output = "\u7b2c" + cal.get(3) + "\u5468";
                break;
            }
            case 4: {
                int month = cal.get(2) + 1;
                String monthStr = month < 10 ? "0" + month : "" + month;
                output = monthStr + "\u6708";
                break;
            }
            case 5: {
                output = "\u7b2c" + (cal.get(2) / 3 + 1) + "\u5b63\u5ea6";
                break;
            }
            case 6: {
                output = "" + cal.get(1);
                break;
            }
            default: {
                output = dateStr.substring(11, 16);
            }
        }
        return output;
    }

    private void augment(List<String> categories, String stime, String etime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = sdf.parse(stime);
            endDate = sdf.parse(etime);
        }
        catch (ParseException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)e));
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        while (!cal.getTime().after(endDate)) {
            String dateStr = sdf.format(cal.getTime());
            String timeStr = DeviceStatusRecordServiceImpl.getShowTimeStr(dateStr, 2);
            if (!categories.contains(timeStr)) {
                categories.add(timeStr);
            }
            cal.add(5, 1);
        }
    }

    private List<Map<String, Object>> createSeries(List<Map<String, Object>> data, List<String> dataNames, List<String> categories) {
        ArrayList<Map<String, Object>> series = new ArrayList<Map<String, Object>>();
        for (String dataName : dataNames) {
            boolean dataNameExists = false;
            ArrayList<String> categoryLine = new ArrayList<String>();
            for (String category : categories) {
                boolean exists = false;
                for (Map<String, Object> map : data) {
                    Integer online = Integer.parseInt(map.get("online").toString());
                    if (!dataName.equals(dataNames.get(online))) continue;
                    dataNameExists = true;
                    String recordTime = DeviceStatusRecordServiceImpl.getShowTimeStr(map.get("recordTime").toString(), 2);
                    if (!category.equals(recordTime)) continue;
                    exists = true;
                    categoryLine.add(map.get("total").toString());
                    break;
                }
                if (!dataNameExists || exists) continue;
                categoryLine.add("0");
            }
            if (!dataNameExists) {
                for (int i = 0; i < categories.size(); ++i) {
                    categoryLine.add("0");
                }
            }
            HashMap<String, Object> serial = new HashMap<String, Object>();
            serial.put("data", categoryLine);
            serial.put("name", dataName);
            series.add(serial);
        }
        return series;
    }

    @Override
    public List<DeviceRecordCountVo> getDeviceStatusRecordNumByRecordTime(Integer groupId, String startTime, String endTime, List<Integer> deviceIds) {
        if (Util.isNotEmpty(deviceIds)) {
            Object deviceIdsStr = "";
            for (Integer item : deviceIds) {
                deviceIdsStr = (String)deviceIdsStr + "," + item;
            }
            if (StringUtils.isNotEmpty((CharSequence)deviceIdsStr)) {
                deviceIdsStr = "(" + ((String)deviceIdsStr).substring(1) + ")";
            }
            return this.deviceStatusRecordMapper.getDeviceStatusRecordNumByRecordTime(groupId, startTime, endTime, (String)deviceIdsStr);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<DeviceRecordVo> getDepDeviceStatusVoListFromDeviceStatusRecordV2(Integer userId, LocalDate date, List<Integer> deptIds, Integer groupId, Map<Integer, DeviceStatus> userDeviceStatusMap, Map<Integer, DepartmentPojo> depNameMap, Integer onlineFlag, Locale locale) {
        String time = date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00";
        ArrayList<DeviceRecordVo> result = new ArrayList<DeviceRecordVo>();
        ArrayList<Integer> deviceStatusIds = new ArrayList<Integer>(userDeviceStatusMap.keySet());
        if (Util.isNotEmpty(deviceStatusIds)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(DeviceStatusRecord::getGroupId, (Object)groupId)).eq(DeviceStatusRecord::getRecordTime, (Object)time)).select(new SFunction[]{DeviceStatusRecord::getDeviceId, DeviceStatusRecord::getOnline}).in(DeviceStatusRecord::getDeviceId, deviceStatusIds);
            if (onlineFlag != null) {
                queryWrapper.eq(DeviceStatusRecord::getOnline, (Object)onlineFlag);
            }
            List deviceStatusRecords = this.deviceStatusRecordMapper.selectList((Wrapper)queryWrapper);
            HashMap<Integer, DeviceStatusRecord> deviceStatusRecordMap = new HashMap<Integer, DeviceStatusRecord>(deviceStatusRecords.size());
            for (DeviceStatusRecord item : deviceStatusRecords) {
                deviceStatusRecordMap.put(item.getDeviceId(), item);
            }
            for (Integer deviceStatusId : deviceStatusRecordMap.keySet()) {
                DepartmentPojo departmentTagSimpleVo;
                LocalDateTime createTime1;
                Integer depId;
                DeviceStatus item = userDeviceStatusMap.get(deviceStatusId);
                if (item == null || (depId = item.getDepId()) == null || (createTime1 = item.getCreateTime()) == null || createTime1.toLocalDate().compareTo(date) > 0 || (departmentTagSimpleVo = depNameMap.get(depId)) == null) continue;
                DeviceRecordVo depDeviceStatusVo = new DeviceRecordVo();
                depDeviceStatusVo.setMenDianId(departmentTagSimpleVo.getId());
                depDeviceStatusVo.setDeptName(departmentTagSimpleVo.getName());
                depDeviceStatusVo.setDeviceName(item.getDeviceName());
                depDeviceStatusVo.setMac(item.getMac());
                Integer id = item.getId();
                DeviceStatusRecord deviceStatusRecord = (DeviceStatusRecord)deviceStatusRecordMap.get(id);
                int online = 0;
                if (deviceStatusRecord != null) {
                    online = deviceStatusRecord.getOnline();
                }
                depDeviceStatusVo.setOpenStatus(departmentTagSimpleVo.getOpenStatus());
                depDeviceStatusVo.setOnline(online);
                depDeviceStatusVo.setDeviceTypeName(this.device18Service.dType_18(item.getDType(), locale));
                depDeviceStatusVo.setDeviceType(item.getDeviceType());
                depDeviceStatusVo.setDeviceStatusId(item.getId());
                depDeviceStatusVo.setRegisterTime(DateUtils.parseTime((LocalDateTime)createTime1, (DateUtils.Format)DateUtils.Format.LONG_DATE_FORMAT_SLASH));
                depDeviceStatusVo.setShopId(departmentTagSimpleVo.getShopId());
                result.add(depDeviceStatusVo);
            }
            deviceStatusIds.clear();
            deviceStatusRecordMap.clear();
            deviceStatusRecords.clear();
        }
        return result;
    }

    @Override
    public DeviceOnlineRateVo getDeviceOnlineRate(Integer userId, Integer enterpriseId, String organizeId, List<String> deviceTypeList, Integer type, int offlineSecond, Integer deptStatus, List<Integer> deptTagList, Integer validateStatus) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        ArrayList<Integer> validateStatusList = new ArrayList<Integer>();
        DepAndTagsPojo depAndTagsPojo = new DepAndTagsPojo();
        if (deptStatus != null) {
            statusList.add(deptStatus);
        }
        if (validateStatus != null) {
            validateStatusList.add(validateStatus);
            depAndTagsPojo.setValidateStatus(validateStatusList);
        }
        depAndTagsPojo.setOpenStatue(statusList);
        depAndTagsPojo.setUserId(userId);
        depAndTagsPojo.setGroupId(enterpriseId);
        ArrayList<Object> typeIds = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            typeIds.addAll(Arrays.asList(split));
        }
        if (Util.isNotEmpty(deptTagList)) {
            typeIds.addAll(deptTagList.stream().map(v -> "T_" + v).collect(Collectors.toList()));
        }
        if (Util.isEmpty(typeIds)) {
            Integer rootOrganize = this.rpcService.getRootOrganize(enterpriseId);
            typeIds.add("O_" + rootOrganize);
        }
        depAndTagsPojo.setTypeIds(typeIds);
        depAndTagsPojo.setContainAll(Boolean.valueOf(false));
        List deptIdList = this.rpcService.getUserPrivilegeDepByOrganizeIdsAndUser(depAndTagsPojo);
        if (Util.isEmpty((Collection)deptIdList)) {
            return new DeviceOnlineRateVo();
        }
        List departmentList = this.rpcService.departmentList(deptIdList);
        Map<Integer, DepartmentPojo> userDepNameMapNew = departmentList.stream().collect(Collectors.toMap(DepartmentPojo::getId, v -> v));
        if (Util.isEmpty(userDepNameMapNew)) {
            return new DeviceOnlineRateVo();
        }
        List depIds = deptIdList;
        ArrayList<DeviceStatus> userDeviceStatus = new ArrayList();
        if (!Util.isEmpty((Collection)depIds)) {
            ArrayList<Integer> excludeDtypeList = new ArrayList<Integer>();
            excludeDtypeList.add(62);
            userDeviceStatus = this.deviceStatusService.getUserDeviceStatus(userId, enterpriseId, depIds, null, excludeDtypeList);
        }
        if (Util.isNotEmpty(userDeviceStatus)) {
            Map onlineMap = this.onlineFacadeRPC.onOffRT(userDeviceStatus.stream().map(DeviceStatus::getId).toList());
            Map dmsStatus = onlineMap == null ? new HashMap() : onlineMap;
            return this.getDeviceOnlineRate(userDeviceStatus, dmsStatus, type, deviceTypeList);
        }
        return new DeviceOnlineRateVo();
    }

    public DeviceOnlineRateVo getDeviceOnlineRate(List<DeviceStatus> userDeviceStatusList, Map<Integer, Integer> dmsOnlineMap, Integer type, List<String> deviceTypeList) {
        DeviceOnlineRateVo data = new DeviceOnlineRateVo();
        if (Util.isNotEmpty(userDeviceStatusList)) {
            Integer online;
            Integer id;
            int deviceOnlineNum = 0;
            int nvrOnlineNum = 0;
            int ipcOnlineNum = 0;
            int pcOnlineNum = 0;
            int gatewayIpcOnlineNum = 0;
            ArrayList<DeviceStatus> nvrList = new ArrayList<DeviceStatus>();
            ArrayList<DeviceStatus> ipcList = new ArrayList<DeviceStatus>();
            ArrayList<DeviceStatus> algList = new ArrayList<DeviceStatus>();
            ArrayList<DeviceStatus> gatewayIpcList = new ArrayList<DeviceStatus>();
            ArrayList<DeviceStatus> excludeList = new ArrayList<DeviceStatus>();
            if (Util.isNotEmpty(userDeviceStatusList)) {
                for (DeviceStatus nvr : userDeviceStatusList) {
                    if (!VersionConstant.box.contains(nvr.getDType()) || 150 == nvr.getDType()) continue;
                    if (type != null && type == 1 && Util.isNotEmpty(deviceTypeList)) {
                        if (deviceTypeList.contains(nvr.getDeviceType())) {
                            nvrList.add(nvr);
                            continue;
                        }
                        excludeList.add(nvr);
                        continue;
                    }
                    nvrList.add(nvr);
                }
            }
            if (Util.isNotEmpty(userDeviceStatusList)) {
                for (DeviceStatus ipc : userDeviceStatusList) {
                    if (!VersionConstant.ipc.contains(ipc.getDType())) continue;
                    if (type == 2 && Util.isNotEmpty(deviceTypeList)) {
                        if (deviceTypeList.contains(ipc.getDeviceType())) {
                            ipcList.add(ipc);
                            continue;
                        }
                        excludeList.add(ipc);
                        continue;
                    }
                    ipcList.add(ipc);
                }
            }
            if (Util.isNotEmpty(userDeviceStatusList)) {
                for (DeviceStatus alg : userDeviceStatusList) {
                    if (!VersionConstant.alg.contains(alg.getDType())) continue;
                    if (type == 3 && Util.isNotEmpty(deviceTypeList)) {
                        if (deviceTypeList.contains(alg.getDeviceType())) {
                            algList.add(alg);
                            continue;
                        }
                        excludeList.add(alg);
                        continue;
                    }
                    algList.add(alg);
                }
            }
            if (Util.isNotEmpty(userDeviceStatusList)) {
                for (DeviceStatus alg : userDeviceStatusList) {
                    if (22 != alg.getDType()) continue;
                    if (type == 4 && Util.isNotEmpty(deviceTypeList)) {
                        if (deviceTypeList.contains(alg.getDeviceType())) {
                            gatewayIpcList.add(alg);
                            continue;
                        }
                        excludeList.add(alg);
                        continue;
                    }
                    gatewayIpcList.add(alg);
                }
            }
            userDeviceStatusList.removeAll(excludeList);
            for (DeviceStatus item : userDeviceStatusList) {
                id = item.getId();
                online = dmsOnlineMap.get(id);
                if (online == null || online != 1) continue;
                ++deviceOnlineNum;
            }
            for (DeviceStatus item : nvrList) {
                id = item.getId();
                online = dmsOnlineMap.get(id);
                if (online == null || online != 1) continue;
                ++nvrOnlineNum;
            }
            for (DeviceStatus item : ipcList) {
                id = item.getId();
                online = dmsOnlineMap.get(id);
                if (online == null || online != 1) continue;
                ++ipcOnlineNum;
            }
            for (DeviceStatus item : algList) {
                id = item.getId();
                online = dmsOnlineMap.get(id);
                if (online == null || online != 1) continue;
                ++pcOnlineNum;
            }
            for (DeviceStatus item : gatewayIpcList) {
                id = item.getId();
                online = dmsOnlineMap.get(id);
                if (online == null || online != 1) continue;
                ++gatewayIpcOnlineNum;
            }
            data.setDeviceTotal(userDeviceStatusList.size());
            data.setNvrTotal(nvrList.size());
            data.setIpcTotal(ipcList.size());
            data.setPcTotal(algList.size());
            data.setDeviceOnlineNum(deviceOnlineNum);
            data.setNvrOnlineNum(nvrOnlineNum);
            data.setIpcOnlineNum(ipcOnlineNum);
            data.setPcOnlineNum(pcOnlineNum);
            data.setGatewayIpcOnlineNum(gatewayIpcOnlineNum);
            data.setGatewayIpcTotal(gatewayIpcList.size());
        }
        return data;
    }

    @Override
    public List<DeviceStatusReportVo> getDeviceStatusCurrentList(Integer userId, Integer enterpriseId, String organizeId, Integer type, Integer deviceOnline, String searchName, List<String> deviceTypeList, int offlineSecond, Integer deptStatus, Integer offLineTimeFilterSecond, Integer offLineTimeFilterType, List<Integer> deptTagList, Integer validateStatus) {
        ArrayList<DeviceStatusReportVo> data = new ArrayList<DeviceStatusReportVo>();
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        ArrayList<Integer> validateStatusList = new ArrayList<Integer>();
        if (deptStatus != null) {
            statusList.add(deptStatus);
        }
        DepAndTagsPojo depAndTagsPojo = new DepAndTagsPojo();
        depAndTagsPojo.setOpenStatue(statusList);
        depAndTagsPojo.setUserId(userId);
        depAndTagsPojo.setGroupId(enterpriseId);
        ArrayList<Object> typeIds = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            typeIds.addAll(Arrays.asList(split));
        }
        if (validateStatus != null) {
            validateStatusList.add(validateStatus);
            depAndTagsPojo.setValidateStatus(validateStatusList);
        }
        if (Util.isNotEmpty(deptTagList)) {
            typeIds.addAll(deptTagList.stream().map(v -> "T_" + v).collect(Collectors.toList()));
        }
        if (Util.isEmpty(typeIds)) {
            Integer rootOrganize = this.rpcService.getRootOrganize(enterpriseId);
            typeIds.add("O_" + rootOrganize);
        }
        depAndTagsPojo.setTypeIds(typeIds);
        depAndTagsPojo.setContainAll(Boolean.valueOf(false));
        List deptIdList = this.rpcService.getUserPrivilegeDepByOrganizeIdsAndUser(depAndTagsPojo);
        if (Util.isEmpty((Collection)deptIdList)) {
            return data;
        }
        List departmentList = this.rpcService.departmentList(deptIdList);
        Map<Integer, DepartmentPojo> userDepNameMapNew = departmentList.stream().collect(Collectors.toMap(DepartmentPojo::getId, v -> v));
        if (Util.isEmpty(userDepNameMapNew)) {
            return data;
        }
        HashMap<Integer, String> userDepNameMap = new HashMap<Integer, String>();
        for (Integer deptId : userDepNameMapNew.keySet()) {
            DepartmentPojo departmentOrgMo = userDepNameMapNew.get(deptId);
            if (departmentOrgMo == null) continue;
            userDepNameMap.put(deptId, departmentOrgMo.getName());
        }
        ArrayList depIds = new ArrayList(userDepNameMap.keySet());
        depAndTagsPojo = new DepAndTagsPojo();
        depAndTagsPojo.setDepartmentIds(depIds);
        depAndTagsPojo.setGroupId(enterpriseId);
        Map tagByDepIdList = this.rpcService.getTagByDepIdList(depAndTagsPojo);
        HashMap<Integer, String> deptTagNameMap = new HashMap<Integer, String>();
        for (Map.Entry entry : tagByDepIdList.entrySet()) {
            Integer key = (Integer)entry.getKey();
            String s = ((List)entry.getValue()).stream().map(SimpleNamePojo::getName).collect(Collectors.joining(","));
            deptTagNameMap.put(key, s);
        }
        if (CollectionUtils.isNotEmpty(depIds)) {
            ArrayList<Integer> excludeDtypeList = new ArrayList<Integer>();
            excludeDtypeList.add(62);
            List userDeviceStatusList = this.deviceStatusService.getUserDeviceStatus(userId, enterpriseId, depIds, deviceTypeList, excludeDtypeList);
            Map dmsOnlineMap = this.onlineFacadeRPC.onOffTimeRT(userDeviceStatusList.stream().map(DeviceStatus::getId).toList());
            List<DeviceStatusReportVo> reportVoList = this.getDeviceStatusCurrentList(userDepNameMap, type, deviceOnline, searchName, userDeviceStatusList, dmsOnlineMap, offlineSecond, offLineTimeFilterSecond, offLineTimeFilterType);
            List shopIdList = reportVoList.stream().filter(deviceStatusReportVo -> deviceStatusReportVo.getMenDianId() != null).map(deviceStatusReportVo -> (int)deviceStatusReportVo.getMenDianId()).collect(Collectors.toList());
            List pojoList = this.departmentFacade.getDepPathById(enterpriseId, shopIdList);
            if (Util.isNotEmpty((Collection)pojoList)) {
                block2: for (DeviceStatusReportVo deviceStatusReportVo2 : reportVoList) {
                    for (SimplePojo simplePojo : pojoList) {
                        if (deviceStatusReportVo2.getMenDianId() == null || deviceStatusReportVo2.getMenDianId().compareTo(simplePojo.getId()) != 0) continue;
                        deviceStatusReportVo2.setOrgName(simplePojo.getName());
                        continue block2;
                    }
                }
            }
            for (DeviceStatusReportVo deviceStatusReportVo2 : reportVoList) {
                Integer menDianId = deviceStatusReportVo2.getMenDianId();
                deviceStatusReportVo2.setTagNames((String)deptTagNameMap.get(menDianId));
            }
            return reportVoList;
        }
        return data;
    }

    public List<DeviceStatusReportVo> getDeviceStatusCurrentList(Map<Integer, String> userDepNameMap, Integer type, Integer deviceOnline, String searchName, List<DeviceStatus> userDeviceStatusList, Map<Integer, OnOffVo> dmsOnlineMap, int offlineSecond, Integer offLineTimeFilterSecond, Integer offLineTimeFilterType) {
        ArrayList<DeviceStatusReportVo> data = new ArrayList<DeviceStatusReportVo>();
        long now = new Date().getTime() / 1000L;
        ArrayList<Integer> depIds = new ArrayList<Integer>(userDepNameMap.keySet());
        List departmentByIds = this.rpcService.departmentList(depIds);
        HashMap<Integer, DepartmentPojo> departmentsMap = new HashMap<Integer, DepartmentPojo>();
        for (DepartmentPojo item : departmentByIds) {
            departmentsMap.put(item.getId(), item);
        }
        if (CollectionUtils.isNotEmpty(depIds)) {
            List<Object> deviceStatusList = new ArrayList();
            switch (type) {
                case 0: {
                    deviceStatusList = userDeviceStatusList;
                    break;
                }
                case 1: {
                    ArrayList<DeviceStatus> nvrList = new ArrayList<DeviceStatus>();
                    if (CollectionUtils.isNotEmpty(userDeviceStatusList)) {
                        for (DeviceStatus nvr : userDeviceStatusList) {
                            if (150 == nvr.getDType() || !VersionConstant.box.contains(nvr.getDType())) continue;
                            nvrList.add(nvr);
                        }
                    }
                    deviceStatusList = nvrList;
                    break;
                }
                case 2: {
                    ArrayList<DeviceStatus> ipcList = new ArrayList<DeviceStatus>();
                    if (CollectionUtils.isNotEmpty(userDeviceStatusList)) {
                        for (DeviceStatus ipc : userDeviceStatusList) {
                            if (!VersionConstant.ipc.contains(ipc.getDType())) continue;
                            ipcList.add(ipc);
                        }
                    }
                    deviceStatusList = ipcList;
                    break;
                }
                case 3: {
                    ArrayList<DeviceStatus> algList = new ArrayList<DeviceStatus>();
                    if (CollectionUtils.isNotEmpty(userDeviceStatusList)) {
                        for (DeviceStatus deviceStatus : userDeviceStatusList) {
                            if (!VersionConstant.alg.contains(deviceStatus.getDType())) continue;
                            algList.add(deviceStatus);
                        }
                    }
                    deviceStatusList = algList;
                    break;
                }
                case 4: {
                    ArrayList gatewayIpcList = new ArrayList();
                    if (CollectionUtils.isNotEmpty(userDeviceStatusList)) {
                        for (DeviceStatus alg : userDeviceStatusList) {
                            if (22 != alg.getDType()) continue;
                            gatewayIpcList.add(alg);
                        }
                    }
                    deviceStatusList = gatewayIpcList;
                }
            }
            ArrayList<DeviceStatusReportVo> deviceStatusReportVos = new ArrayList<DeviceStatusReportVo>();
            long currentTimeMillis = System.currentTimeMillis() / 1000L;
            for (DeviceStatus deviceStatus : deviceStatusList) {
                long offlineTimeStamp;
                Integer id = deviceStatus.getId();
                OnOffVo onlineVo = dmsOnlineMap.get(id);
                int online = onlineVo != null ? onlineVo.getOnline() : 0;
                long l = offlineTimeStamp = onlineVo != null ? onlineVo.getOfflineTimeStamp() : currentTimeMillis;
                if (offlineSecond != 0 && online == 0 && offlineTimeStamp != 0L && now - offlineTimeStamp < (long)offlineSecond) {
                    online = 1;
                }
                if (offLineTimeFilterSecond != null && offLineTimeFilterType != null) {
                    if (online == 1) continue;
                    if (offlineTimeStamp == 0L) {
                        offlineTimeStamp = currentTimeMillis;
                    }
                    if ((offLineTimeFilterType != 1 || (long)offLineTimeFilterSecond.intValue() >= currentTimeMillis - offlineTimeStamp) && (offLineTimeFilterType != 2 || (long)offLineTimeFilterSecond.intValue() <= currentTimeMillis - offlineTimeStamp)) continue;
                }
                DepartmentPojo departments = (DepartmentPojo)departmentsMap.get(deviceStatus.getDepId());
                DeviceStatusReportVo vo = new DeviceStatusReportVo();
                vo.setDeviceId(id);
                vo.setDeviceName(deviceStatus.getDeviceName());
                String mac = deviceStatus.getMac();
                if (StringUtils.isNotEmpty((CharSequence)mac)) {
                    vo.setMac(mac);
                } else {
                    String deviceCode = deviceStatus.getDeviceCode();
                    if (StringUtils.isNotEmpty((CharSequence)deviceCode)) {
                        vo.setMac(deviceCode);
                    } else {
                        vo.setMac(deviceStatus.getThirdpartDevId());
                    }
                }
                vo.setOnline(online);
                if (online != 1) {
                    vo.setOfflineTimeStamp(offlineTimeStamp);
                }
                if (onlineVo != null) {
                    vo.setOnlineTimeStamp(onlineVo.getOnlineTimeStamp());
                }
                vo.setdType(this.device18Service.dType_18(deviceStatus.getDType(), null));
                vo.setDeviceType(deviceStatus.getDeviceType());
                vo.setCreateTime(deviceStatus.getCreateTime() == null ? "" : DateUtils.parseTime((LocalDateTime)deviceStatus.getCreateTime(), (DateUtils.Format)DateUtils.Format.LONG_DATE_FORMAT_SLASH));
                if (departments != null) {
                    vo.setDepName(departments.getName());
                    vo.setDepOpenStatus(departments.getOpenStatus());
                    vo.setValidateStatus(departments.getValidateStatus());
                    String mobilePhone = departments.getPhone();
                    vo.setDepTel(mobilePhone);
                    vo.setShopId(departments.getShopId());
                    vo.setMenDianId(departments.getId());
                }
                deviceStatusReportVos.add(vo);
            }
            ArrayList<DeviceStatusReportVo> newDeviceStatusReportVos1 = new ArrayList<DeviceStatusReportVo>();
            ArrayList<DeviceStatusReportVo> arrayList = new ArrayList<DeviceStatusReportVo>();
            if (deviceOnline != null || searchName != null) {
                if (deviceOnline != null && searchName == null) {
                    for (DeviceStatusReportVo item : deviceStatusReportVos) {
                        if (!item.getOnline().equals(deviceOnline)) continue;
                        newDeviceStatusReportVos1.add(item);
                    }
                    data = newDeviceStatusReportVos1;
                }
                if (deviceOnline == null) {
                    for (DeviceStatusReportVo item : deviceStatusReportVos) {
                        if ((item.getDeviceName() == null || !item.getDeviceName().contains(searchName)) && (item.getMac() == null || !item.getMac().contains(searchName))) continue;
                        newDeviceStatusReportVos1.add(item);
                    }
                    data = newDeviceStatusReportVos1;
                }
                if (deviceOnline != null && searchName != null) {
                    for (DeviceStatusReportVo item : deviceStatusReportVos) {
                        if (!item.getOnline().equals(deviceOnline)) continue;
                        newDeviceStatusReportVos1.add(item);
                    }
                    for (DeviceStatusReportVo item : newDeviceStatusReportVos1) {
                        if ((item.getDeviceName() == null || !item.getDeviceName().contains(searchName)) && (item.getMac() == null || !item.getMac().contains(searchName))) continue;
                        arrayList.add(item);
                    }
                    data = arrayList;
                }
            } else {
                data = deviceStatusReportVos;
            }
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PageModel<DeviceRecordVo> getDeptDeviceRecordList(Integer userId, Integer enterpriseId, String date, Integer pageNum, Integer pageSize, String organizeId, Integer type, Integer devType, String deviceTypes, Integer openStatus, List<Integer> deptTagList) {
        Locale locale = Session.getOrCreate().get().clientInfo().getLocale();
        LocalDate parse = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        if (openStatus != null) {
            statusList.add(openStatus);
        }
        DepAndTagsPojo depAndTagsPojo = new DepAndTagsPojo();
        depAndTagsPojo.setOpenStatue(statusList);
        depAndTagsPojo.setUserId(userId);
        depAndTagsPojo.setGroupId(enterpriseId);
        ArrayList<Object> typeIds = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            typeIds.addAll(Arrays.asList(split));
        }
        if (Util.isNotEmpty(deptTagList)) {
            typeIds.addAll(deptTagList.stream().map(v -> "T_" + v).collect(Collectors.toList()));
        }
        if (Util.isEmpty(typeIds)) {
            Integer rootOrganize = this.rpcService.getRootOrganize(enterpriseId);
            typeIds.add("O_" + rootOrganize);
        }
        depAndTagsPojo.setTypeIds(typeIds);
        depAndTagsPojo.setContainAll(Boolean.valueOf(false));
        List deptIdList = this.rpcService.getUserPrivilegeDepByOrganizeIdsAndUser(depAndTagsPojo);
        if (Util.isEmpty((Collection)deptIdList)) {
            return PageModel.empty((long)pageNum.intValue(), (int)pageSize, (long)0L);
        }
        List departmentList = this.rpcService.departmentList(deptIdList);
        Map<Integer, DepartmentPojo> userDepNameMapNew = departmentList.stream().collect(Collectors.toMap(DepartmentPojo::getId, v -> v));
        if (Util.isEmpty(userDepNameMapNew)) {
            return PageModel.empty((long)pageNum.intValue(), (int)pageSize, (long)0L);
        }
        HashMap<Integer, String> userDepNameMap = new HashMap<Integer, String>();
        for (Integer deptId : userDepNameMapNew.keySet()) {
            DepartmentPojo departmentOrgMo = userDepNameMapNew.get(deptId);
            if (departmentOrgMo == null) continue;
            userDepNameMap.put(deptId, departmentOrgMo.getName());
        }
        depAndTagsPojo = new DepAndTagsPojo();
        depAndTagsPojo.setDepartmentIds(deptIdList);
        depAndTagsPojo.setGroupId(enterpriseId);
        Map tagByDepIdList = this.rpcService.getTagByDepIdList(depAndTagsPojo);
        HashMap<Integer, String> deptTagNameMap = new HashMap<Integer, String>();
        for (Map.Entry entry : tagByDepIdList.entrySet()) {
            Integer key = (Integer)entry.getKey();
            String s = ((List)entry.getValue()).stream().map(SimpleNamePojo::getName).collect(Collectors.joining(","));
            deptTagNameMap.put(key, s);
        }
        ArrayList<Integer> depList = new ArrayList<Integer>(userDepNameMap.keySet());
        ArrayList arrayList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)deviceTypes)) {
            String[] split = deviceTypes.split(",");
            List<String> list = Arrays.asList(split);
        }
        List userDeviceStatus = this.deviceStatusService.getUserDeviceStatus(userId, enterpriseId, depList);
        HashMap<Integer, DeviceStatus> userDeviceStatusMap = new HashMap<Integer, DeviceStatus>();
        block8: for (DeviceStatus deviceStatus : userDeviceStatus) {
            LocalDateTime createTime;
            void var24_27;
            Integer dType = deviceStatus.getDType();
            String deviceType = deviceStatus.getDeviceType();
            if (Util.isNotEmpty((Collection)var24_27) && !var24_27.contains(deviceType)) continue;
            if (devType != null) {
                switch (devType) {
                    case 1: {
                        if (VersionConstant.box.contains(dType)) break;
                        continue block8;
                    }
                    case 2: {
                        if (VersionConstant.ipc.contains(dType)) break;
                        continue block8;
                    }
                    case 3: {
                        if (VersionConstant.alg.contains(dType)) break;
                        continue block8;
                    }
                    case 4: {
                        if (22 == dType) break;
                        continue block8;
                    }
                }
            }
            if ((createTime = deviceStatus.getCreateTime()) == null || createTime.toLocalDate().compareTo(parse) > 0) continue;
            userDeviceStatusMap.put(deviceStatus.getId(), deviceStatus);
        }
        Integer onlineFlag = null;
        if (type == 1) {
            onlineFlag = 0;
        }
        if (type == 2) {
            onlineFlag = 1;
        }
        List<DeviceRecordVo> depDeviceStatusVoListFromDeviceStatusRecord = this.getDepDeviceStatusVoListFromDeviceStatusRecordV2(userId, parse, depList, enterpriseId, userDeviceStatusMap, userDepNameMapNew, onlineFlag, locale);
        int size = depDeviceStatusVoListFromDeviceStatusRecord.size();
        PageModel result = new PageModel();
        List list = new ArrayList(pageNum);
        list = ListUtil.subList(depDeviceStatusVoListFromDeviceStatusRecord, (Integer)pageNum, (Integer)pageSize);
        result.setTotal((long)size);
        result.setPageNumber((long)pageNum.intValue());
        result.setPageSize(pageSize.intValue());
        result.setData(list);
        List shopIdList = list.stream().filter(deviceStatusReportVo -> deviceStatusReportVo.getMenDianId() != null).map(deviceRecordVo -> (int)deviceRecordVo.getMenDianId()).collect(Collectors.toList());
        List pojoList = this.departmentFacade.getDepPathById(enterpriseId, shopIdList);
        if (Util.isNotEmpty((Collection)pojoList)) {
            block9: for (DeviceRecordVo deviceRecordVo2 : list) {
                for (SimplePojo simplePojo : pojoList) {
                    if (deviceRecordVo2.getMenDianId() == null || deviceRecordVo2.getMenDianId().compareTo(simplePojo.getId()) != 0) continue;
                    deviceRecordVo2.setOrgName(simplePojo.getName());
                    continue block9;
                }
            }
        }
        for (DeviceRecordVo deviceStatusReportVo2 : result.getData()) {
            Integer menDianId = deviceStatusReportVo2.getMenDianId();
            deviceStatusReportVo2.setTagNames((String)deptTagNameMap.get(menDianId));
        }
        return result;
    }
}

