/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportdisk;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.device.modules.reportdisk.DeviceDiskService;
import com.ovopark.device.modules.reportdisk.DiskTimeStatus;
import com.ovopark.device.modules.reportdisk.mysql.DiskStatusHistory;
import com.ovopark.device.modules.reportdisk.mysql.DiskStatusHistoryMapper;
import com.ovopark.kernel.shared.Util;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceDiskServiceImpl
implements DeviceDiskService {
    @Autowired
    private DiskStatusHistoryMapper diskStatusHistoryMapper;

    @Override
    public Map<Integer, List<DiskTimeStatus>> diskNumStatus(LocalDateTime startTime, LocalDateTime endTime, Integer type, Integer deviceStatusId, String serialNumber, Integer diskNum, Integer deptId) {
        LocalDate startTimeLocalDate = startTime.toLocalDate();
        LocalDate endTimeLocalDate = endTime.toLocalDate();
        long days = ChronoUnit.DAYS.between(startTimeLocalDate, endTimeLocalDate) + 1L;
        ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
        int i = 0;
        while ((long)i < days) {
            dateList.add(startTimeLocalDate.plusDays(i));
            ++i;
        }
        HashMap<Integer, List<DiskTimeStatus>> statusListMap = new HashMap<Integer, List<DiskTimeStatus>>();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(DiskStatusHistory::getCreateAt, (Object)startTimeLocalDate)).le(DiskStatusHistory::getCreateAt, (Object)endTimeLocalDate);
        if (type == 1 || type == 2) {
            queryWrapper.eq(DiskStatusHistory::getDeviceStatusId, (Object)deviceStatusId);
        } else {
            queryWrapper.eq(DiskStatusHistory::getDepId, (Object)deptId);
            queryWrapper.eq(DiskStatusHistory::getSerialNumber, (Object)serialNumber);
        }
        queryWrapper.orderByAsc(DiskStatusHistory::getCreateAt);
        List diskStatusHistories = this.diskStatusHistoryMapper.selectList((Wrapper)queryWrapper);
        diskStatusHistories.sort(Comparator.comparing(DiskStatusHistory::getDiskIndex));
        if (type == 1) {
            LinkedHashMap<Integer, Map> map = new LinkedHashMap<Integer, Map>();
            for (DiskStatusHistory item : diskStatusHistories) {
                Integer diskIndex = item.getDiskIndex();
                map.computeIfAbsent(diskIndex, k -> new HashMap()).put(item.getCreateAt(), item.getStatus());
            }
            ArrayList keyList = new ArrayList(map.keySet());
            List diskIndexList = keyList.subList(0, Math.min(diskNum, keyList.size()));
            for (Integer i2 : diskIndexList) {
                LinkedList<DiskTimeStatus> list = new LinkedList<DiskTimeStatus>();
                Map localDateIntegerMap = (Map)map.get(i2);
                for (LocalDate date : dateList) {
                    Integer status = localDateIntegerMap == null ? null : (Integer)localDateIntegerMap.get(date);
                    DiskTimeStatus diskTimeStatus = new DiskTimeStatus();
                    diskTimeStatus.setDiskNum(i2);
                    diskTimeStatus.setTime(date);
                    diskTimeStatus.setStatus((Integer)Util.convert2Self((Object)status, (Object)-1));
                    diskTimeStatus.setMiss(localDateIntegerMap == null);
                    list.add(diskTimeStatus);
                }
                statusListMap.put(i2, list);
            }
        } else if (type == 2 || type == 3) {
            HashMap<LocalDate, Integer> map = new HashMap<LocalDate, Integer>();
            for (DiskStatusHistory item : diskStatusHistories) {
                map.put(item.getCreateAt(), item.getStatus());
            }
            LinkedList<DiskTimeStatus> list = new LinkedList<DiskTimeStatus>();
            for (LocalDate date : dateList) {
                Integer status = (Integer)map.get(date);
                DiskTimeStatus diskTimeStatus = new DiskTimeStatus();
                diskTimeStatus.setDiskNum(1);
                diskTimeStatus.setTime(date);
                diskTimeStatus.setStatus((Integer)Util.convert2Self((Object)status, (Object)-1));
                list.add(diskTimeStatus);
            }
            statusListMap.put(0, list);
        }
        return statusListMap;
    }
}

