/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.videoconfig;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.device.cloud.api.DeviceStatusApi;
import com.ovopark.device.common.response.BaseResult;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.ListUtil;
import com.ovopark.device.modules.platform.PlatformsService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.modules.platform.mysql.Platforms;
import com.ovopark.device.modules.videoconfig.TimedVideoRecordingService;
import com.ovopark.device.modules.videoconfig.vo.TimedVideoRecordingBatchConfigMo;
import com.ovopark.device.modules.videoconfig.vo.TimedVideoRecordingMo;
import com.ovopark.device.modules.videoconfig.vo.TimedVideoRecordingVo;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.device.thirdparty.ovoIot.model.Dms2New1Res;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetTimerRecordTaskReq;
import com.ovopark.device.thirdparty.ovoIot.service.NvrService;
import com.ovopark.device.thirdparty.ovoIot.util.AbilityUtil;
import com.ovopark.device.thirdparty.ovoIot.util.IotJsonUtils;
import com.ovopark.organize.common.model.mo.DepIdsAndUserMo;
import com.ovopark.organize.common.model.mo.DepartmentOrgMo;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TimedVideoRecordingServiceImpl
implements TimedVideoRecordingService {
    private static final Logger log = LoggerFactory.getLogger(TimedVideoRecordingServiceImpl.class);
    @Resource
    private DepartmentFacade departmentFacade;
    @Resource
    private DeviceStatusMapper deviceStatusMapper;
    @Resource
    private DeviceStatusApi deviceStatusApi;
    @Resource
    private PlatformsService platformsService;
    @Resource
    private NvrService nvrService;

    @Override
    public List<TimedVideoRecordingVo> getList(TimedVideoRecordingMo mo, Integer userId) {
        ArrayList<TimedVideoRecordingVo> result = new ArrayList<TimedVideoRecordingVo>(mo.getPageSize() == Integer.MAX_VALUE ? 8 : mo.getPageSize());
        Map<Integer, String> departmentMap = this.getDepartmentMap(mo.getOrganizeIdList(), mo.getGroupId(), userId);
        if (CollectionUtils.isEmpty(departmentMap)) {
            return result;
        }
        List<DeviceStatus> deviceStatusList = this.getDeviceStatusList(new ArrayList<Integer>(departmentMap.keySet()), mo.getOnlineFlag(), mo.getGroupId(), mo.getDeviceTypes(), mo.getDeviceName(), mo.getPageNum(), mo.getPageSize(), mo.getNeedExportFlag());
        return this.getDeviceStatusVideoConfigList(deviceStatusList, departmentMap);
    }

    @Override
    public void batchConfig(TimedVideoRecordingBatchConfigMo mo, Integer userId) {
        Integer groupId = mo.getGroupId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(DeviceStatus::getGroupId, (Object)groupId)).in(DeviceStatus::getId, mo.getDeviceStatusIdList())).eq(DeviceStatus::getIsDelete, (Object)0)).isNotNull(DeviceStatus::getPlatformId)).orderByAsc(DeviceStatus::getDepId, new SFunction[]{DeviceStatus::getPId});
        List deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)queryWrapper);
        ArrayList<Integer> platformIdList = new ArrayList<Integer>();
        for (DeviceStatus deviceStatus : deviceStatusList) {
            Integer platformId = deviceStatus.getPlatformId();
            platformIdList.add(platformId);
        }
        List platforms = this.platformsService.getPlatforms(new ArrayList(platformIdList));
        HashMap<Integer, Platforms> platformMap = new HashMap<Integer, Platforms>();
        for (Platforms item : platforms) {
            platformMap.put(item.getId(), item);
        }
        ArrayList<SetTimerRecordTaskReq> reqList = new ArrayList<SetTimerRecordTaskReq>();
        SetTimerRecordTaskReq req = new SetTimerRecordTaskReq();
        req.setAllTimeRecord(mo.getAllTimeRecord());
        List<TimedVideoRecordingBatchConfigMo.TimeSectionInfosDTO> timeSectionInfos = mo.getTimeSectionInfos();
        for (TimedVideoRecordingBatchConfigMo.TimeSectionInfosDTO item : timeSectionInfos) {
            SetTimerRecordTaskReq.TimeSectionInfosDTO dto = new SetTimerRecordTaskReq.TimeSectionInfosDTO();
            dto.setBegin(item.getBegin());
            dto.setEnd(item.getEnd());
            req.getTimeSectionInfos().add(dto);
        }
        reqList.add(req);
        for (DeviceStatus deviceStatus : deviceStatusList) {
            boolean supportSetTimerRecordTaskReq = AbilityUtil.supportSetTimerRecordTaskReq((Integer)deviceStatus.getDType(), (String)deviceStatus.getExtendCapacity());
            if (!supportSetTimerRecordTaskReq) continue;
            try {
                Platforms platforms1 = (Platforms)platformMap.get(deviceStatus.getPlatformId());
                Dms2New1Res dms2New1Res = this.nvrService.setTimerRecordTaskReq(deviceStatus.getMac(), reqList, platforms1.getNewDmsFlag(), platforms1.getUpgradeServer(), platforms1.getUpgradePort());
                log.info("nvrService.setTimerRecordTaskReq res:{}", (Object)IotJsonUtils.beanToJsonStringForLog((Object)dms2New1Res));
            }
            catch (Exception e) {
                log.error("nvrService.setTimerRecordTask err {}", (Object)IotJsonUtils.beanToJsonStringForLog((Object)e));
            }
        }
    }

    public void export(TimedVideoRecordingMo mo, Integer userId) {
        mo.setNeedExportFlag(1);
        List<TimedVideoRecordingVo> list = this.getList(mo, userId);
    }

    private Map<Integer, String> getDepartmentMap(List<String> organizeIdList, Integer groupId, Integer userId) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        DepIdsAndUserMo mo = new DepIdsAndUserMo();
        mo.setIsDel(Integer.valueOf(0));
        mo.setUserGroupId(groupId);
        mo.setUserId(userId);
        mo.setOrganizeIdList(organizeIdList);
        Map userDepNameMapNew = this.departmentFacade.getUserDepNameMapNew(mo);
        for (Integer depId : userDepNameMapNew.keySet()) {
            DepartmentOrgMo departmentOrgMo = (DepartmentOrgMo)userDepNameMapNew.get(depId);
            if (departmentOrgMo == null) continue;
            result.put(depId, departmentOrgMo.getName());
        }
        return result;
    }

    private List<DeviceStatus> getDeviceStatusList(List<Integer> depIds, Integer onlineFlag, Integer groupId, List<String> deviceTypeList, String deviceName, Integer pageNum, Integer pageSize, Integer needExportFlag) {
        ArrayList<Integer> dtypeList = new ArrayList<Integer>();
        dtypeList.add(22);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(DeviceStatus::getGroupId, (Object)groupId)).eq(DeviceStatus::getIsDelete, (Object)0)).in(DeviceStatus::getDepId, depIds)).in(DeviceStatus::getDType, dtypeList)).in(!CollectionUtils.isEmpty(deviceTypeList), DeviceStatus::getDeviceType, deviceTypeList)).isNotNull(DeviceStatus::getPlatformId)).like(StringUtils.hasLength((String)deviceName), DeviceStatus::getDeviceName, (Object)("%" + deviceName + "%"))).orderByAsc(DeviceStatus::getDepId, new SFunction[]{DeviceStatus::getPId});
        List deviceStatuses = this.deviceStatusMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)deviceStatuses)) {
            return new ArrayList<DeviceStatus>();
        }
        List<DeviceStatus> needResList = new ArrayList();
        if (onlineFlag == null && needExportFlag == 0) {
            needResList = ListUtil.subList((List)deviceStatuses, (Integer)pageNum, (Integer)pageSize);
            if (CollectionUtils.isEmpty(needResList)) {
                return new ArrayList<DeviceStatus>();
            }
        } else {
            needResList = deviceStatuses;
        }
        ArrayList<Integer> deviceStatusIdList = new ArrayList<Integer>(needResList.size());
        for (DeviceStatus deviceStatus : needResList) {
            deviceStatusIdList.add(deviceStatus.getId());
        }
        Map onlineMap = new HashMap();
        try {
            BaseResult dmsOnlineMap = this.deviceStatusApi.getDmsOnlineMap(deviceStatusIdList);
            Map data = (Map)dmsOnlineMap.getData();
            if (data != null) {
                onlineMap = data;
            }
        }
        catch (Exception e) {
            log.error("deviceStatusApi.getDmsOnlineMap err");
            throw new CommonException(ExceptionEnum.CLOUD_EXCEPTION);
        }
        Iterator iterator = needResList.iterator();
        while (iterator.hasNext()) {
            DeviceStatus deviceStatus = (DeviceStatus)iterator.next();
            boolean supportSetTimerRecordTaskReq = AbilityUtil.supportSetTimerRecordTaskReq((Integer)deviceStatus.getDType(), (String)deviceStatus.getExtendCapacity());
            if (!supportSetTimerRecordTaskReq) {
                iterator.remove();
            }
            Integer online = (Integer)onlineMap.get(deviceStatus.getId());
            if (!(onlineFlag == null || online != null && online.equals(onlineFlag))) {
                iterator.remove();
                continue;
            }
            deviceStatus.setOnline(online);
        }
        if (needExportFlag == 0 && onlineFlag != null) {
            needResList = ListUtil.subList(needResList, (Integer)pageNum, (Integer)pageSize);
        }
        return needResList;
    }

    private List<TimedVideoRecordingVo> getDeviceStatusVideoConfigList(List<DeviceStatus> deviceStatusList, Map<Integer, String> departmentNameMap) {
        ArrayList<TimedVideoRecordingVo> result = new ArrayList<TimedVideoRecordingVo>(deviceStatusList.size());
        HashSet<Integer> platformIdList = new HashSet<Integer>();
        for (DeviceStatus deviceStatus : deviceStatusList) {
            Integer platformId = deviceStatus.getPlatformId();
            platformIdList.add(platformId);
        }
        List platforms = this.platformsService.getPlatforms(new ArrayList(platformIdList));
        HashMap<Integer, Platforms> platformMap = new HashMap<Integer, Platforms>();
        for (Platforms platforms2 : platforms) {
            platformMap.put(platforms2.getId(), platforms2);
        }
        for (DeviceStatus deviceStatus : deviceStatusList) {
            Integer online = deviceStatus.getOnline();
            TimedVideoRecordingVo vo = new TimedVideoRecordingVo();
            vo.setDeviceStatusId(deviceStatus.getId());
            vo.setDepId(deviceStatus.getDepId());
            vo.setDeviceName(deviceStatus.getDeviceName());
            vo.setDepName(departmentNameMap.get(deviceStatus.getDepId()));
            vo.setMac(deviceStatus.getMac());
            vo.setDeviceType(deviceStatus.getDeviceType());
            vo.setOnline(online);
            boolean supportSetTimerRecordTaskReq = AbilityUtil.supportSetTimerRecordTaskReq((Integer)deviceStatus.getDType(), (String)deviceStatus.getExtendCapacity());
            if (online != null && online == 1 && supportSetTimerRecordTaskReq) {
                try {
                    Platforms platforms1 = (Platforms)platformMap.get(deviceStatus.getPlatformId());
                    Dms2New1Res timerRecordTaskReq = this.nvrService.getTimerRecordTaskReq(deviceStatus.getMac(), platforms1.getUpgradeServer(), platforms1.getUpgradePort(), platforms1.getNewDmsFlag());
                    List data = (List)timerRecordTaskReq.getData();
                    if (data != null) {
                        SetTimerRecordTaskReq first = (SetTimerRecordTaskReq)data.getFirst();
                        vo.setAllTimeRecord(first.getAllTimeRecord());
                        List<TimedVideoRecordingVo.TimeSectionInfosDTO> timeSectionVoInfos1 = TimedVideoRecordingServiceImpl.getTimeSectionInfosDTOS(first);
                        vo.setTimeSectionInfos(timeSectionVoInfos1);
                    }
                }
                catch (Exception e) {
                    log.error("nvrService.getTimerRecordTaskReq :{}", (Object)IotJsonUtils.beanToJsonStringForLog((Object)e));
                }
            }
            result.add(vo);
        }
        return result;
    }

    @NotNull
    private static List<TimedVideoRecordingVo.TimeSectionInfosDTO> getTimeSectionInfosDTOS(SetTimerRecordTaskReq first) {
        List timeSectionInfos = first.getTimeSectionInfos();
        ArrayList<TimedVideoRecordingVo.TimeSectionInfosDTO> timeSectionVoInfos1 = new ArrayList<TimedVideoRecordingVo.TimeSectionInfosDTO>();
        for (SetTimerRecordTaskReq.TimeSectionInfosDTO item1 : timeSectionInfos) {
            TimedVideoRecordingVo.TimeSectionInfosDTO dto = new TimedVideoRecordingVo.TimeSectionInfosDTO();
            dto.setBegin(item1.getBegin());
            dto.setEnd(item1.getEnd());
            timeSectionVoInfos1.add(dto);
        }
        return timeSectionVoInfos1;
    }
}

