/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.videoconfig.report;

import com.ovopark.device.modules.videoconfig.TimedVideoRecordingService;
import com.ovopark.device.modules.videoconfig.report.TimedVideoRecordingExcel;
import com.ovopark.device.modules.videoconfig.vo.TimedVideoRecordingMo;
import com.ovopark.device.modules.videoconfig.vo.TimedVideoRecordingVo;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.Session;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="/ovopark-device-report-form/deviceReport/timedVideoReport")
public class TimedVideoReport
implements JobOutTaskFlow<TimedVideoRecordingMo> {
    private static final Logger log = LoggerFactory.getLogger(TimedVideoReport.class);
    @Autowired
    private TimedVideoRecordingService timedVideoRecordingService;
    @Autowired
    private MessageSource messageSource;

    public TimedVideoRecordingMo requestParamBody(String requestBody, Session session) throws NoPrivilegeException {
        log.info("requestParamBody : " + requestBody);
        log.info("session: " + JSONAccessor.impl().format((Object)session));
        TimedVideoRecordingMo paramMo = (TimedVideoRecordingMo)JSONAccessor.impl().read(requestBody, TimedVideoRecordingMo.class);
        paramMo.setLocale(session.clientInfo().getLocale());
        paramMo.setSessionUserId(session.getUserId());
        Integer sessionGroupId = session.getGroupId();
        if (sessionGroupId != null) {
            paramMo.setGroupId(sessionGroupId);
        }
        return paramMo;
    }

    public void execute(TimedVideoRecordingMo requestParamBody, OutStore outStore) {
        requestParamBody.setPageNum(1);
        requestParamBody.setPageSize(Integer.MAX_VALUE);
        List<TimedVideoRecordingVo> list = this.timedVideoRecordingService.getList(requestParamBody, requestParamBody.getSessionUserId());
        Locale locale = requestParamBody.getLocale();
        OutStore.SegmentWriter segment = outStore.createSegment("\u5f55\u50cf\u65f6\u95f4\u914d\u7f6e");
        segment.header().all(TimedVideoRecordingExcel.class, path -> this.messageSource.getMessage(path, null, locale));
        for (TimedVideoRecordingVo timedVideoRecordingVo : list) {
            TimedVideoRecordingExcel timedVideoRecordingExcel = new TimedVideoRecordingExcel();
            BeanUtils.copyProperties((Object)timedVideoRecordingVo, (Object)timedVideoRecordingExcel);
            if (Util.compare2((Comparable)timedVideoRecordingVo.getAllTimeRecord(), (Comparable)Integer.valueOf(1)) == 0) {
                timedVideoRecordingExcel.setTimeSectionInfos("\u5168\u65f6\u6bb5");
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                List<TimedVideoRecordingVo.TimeSectionInfosDTO> timeSectionInfos = timedVideoRecordingVo.getTimeSectionInfos();
                if (Util.isNotEmpty(timeSectionInfos)) {
                    for (TimedVideoRecordingVo.TimeSectionInfosDTO timeSectionInfo : timeSectionInfos) {
                        if (timeSectionInfo.getBegin().startsWith("24")) continue;
                        stringBuilder.append("," + timeSectionInfo.getBegin() + "-" + timeSectionInfo.getEnd());
                    }
                }
                if (!stringBuilder.isEmpty()) {
                    timedVideoRecordingExcel.setTimeSectionInfos(stringBuilder.substring(1));
                }
            }
            timedVideoRecordingExcel.setOnOffStr(Util.compare2((Comparable)timedVideoRecordingExcel.getOnline(), (Comparable)Integer.valueOf(1)) == 0 ? "\u5728\u7ebf" : "\u79bb\u7ebf");
            segment.append((Model)timedVideoRecordingExcel);
        }
        segment.commit();
    }
}

