/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.platform.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.CollectionUtils;

public class SmartDataQueryUtil {
    private static final Logger log = LoggerFactory.getLogger(SmartDataQueryUtil.class);
    private static final int SMALL_DATA_THRESHOLD = 1000;
    private static final int MEDIUM_DATA_THRESHOLD = 5000;
    private static final int LARGE_DATA_THRESHOLD = 20000;
    private static final int HUGE_DATA_THRESHOLD = 100000;
    private static final int EXTREME_DATA_THRESHOLD = 500000;
    private static final int MASSIVE_DATA_THRESHOLD = 1000000;
    private static final int SMALL_DATA_PARTITION_SIZE = 1000;
    private static final int MEDIUM_DATA_PARTITION_SIZE = 500;
    private static final int LARGE_DATA_PARTITION_SIZE = 1000;
    private static final int HUGE_DATA_PARTITION_SIZE = 2000;
    private static final int EXTREME_DATA_PARTITION_SIZE = 5000;
    private static final int MASSIVE_DATA_PARTITION_SIZE = 10000;
    private static final int TASK_TIMEOUT_SECONDS = 45;
    private static final int MAX_VIRTUAL_THREADS = 200;

    public static <T, R> List<R> executeSmartQuery(List<T> dataList, Function<List<T>, List<R>> queryFunction, String logPrefix) {
        if (CollectionUtils.isEmpty(dataList)) {
            return new ArrayList();
        }
        int dataSize = dataList.size();
        String strategy = SmartDataQueryUtil.getProcessingStrategy(dataSize);
        if (dataSize <= 1000) {
            log.info("{}\uff1a\u6570\u636e\u91cf({})\uff0c\u4f7f\u7528{}\u6a21\u5f0f", new Object[]{logPrefix, dataSize, strategy});
            return SmartDataQueryUtil.executeDirectQuery(dataList, queryFunction, logPrefix);
        }
        int partitionSize = SmartDataQueryUtil.getOptimalPartitionSize(dataSize);
        log.info("{}\uff1a\u6570\u636e\u91cf({})\uff0c\u4f7f\u7528{}\u6a21\u5f0f\uff0c\u5206\u7247\u5927\u5c0f={}", new Object[]{logPrefix, dataSize, strategy, partitionSize});
        return SmartDataQueryUtil.executeVirtualThreadQueryInternal(dataList, partitionSize, queryFunction, logPrefix);
    }

    private static <T, R> List<R> executeDirectQuery(List<T> dataList, Function<List<T>, List<R>> queryFunction, String logPrefix) {
        try {
            return queryFunction.apply(dataList);
        }
        catch (Exception e) {
            log.error("{}\u76f4\u63a5\u67e5\u8be2\u5f02\u5e38", (Object)logPrefix, (Object)e);
            return new ArrayList();
        }
    }

    private static <T, R> List<R> executeVirtualThreadQueryInternal(List<T> dataList, int partitionSize, Function<List<T>, List<R>> queryFunction, String logPrefix) {
        List<List<T>> dataPartitions = SmartDataQueryUtil.partitionList(dataList, partitionSize);
        int virtualThreadCount = SmartDataQueryUtil.calculateOptimalVirtualThreadCount(dataPartitions.size(), dataList.size());
        log.info("{}\uff1a\u6570\u636e\u91cf={}, \u5206\u7247\u6570={}, \u5206\u7247\u5927\u5c0f={}, \u4f7f\u7528\u865a\u62df\u7ebf\u7a0b\u6570={}", new Object[]{logPrefix, dataList.size(), dataPartitions.size(), partitionSize, virtualThreadCount});
        Map mdcContext = MDC.getCopyOfContextMap();
        try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
            List<R> list = SmartDataQueryUtil.processPartitionsWithVirtualThreads(dataPartitions, queryFunction, logPrefix, mdcContext, executor);
            return list;
        }
    }

    private static <T, R> List<R> processPartitionsWithVirtualThreads(List<List<T>> dataPartitions, Function<List<T>, List<R>> queryFunction, String logPrefix, Map<String, String> mdcContext, ExecutorService executor) {
        List<CompletableFuture> futures = dataPartitions.stream().map(partition -> CompletableFuture.supplyAsync(() -> {
            if (mdcContext != null) {
                MDC.setContextMap((Map)mdcContext);
            }
            try {
                List list = (List)queryFunction.apply((List)partition);
                return list;
            }
            finally {
                MDC.clear();
            }
        }, executor)).toList();
        ArrayList allResults = new ArrayList();
        for (CompletableFuture future : futures) {
            try {
                List results = (List)future.get(45L, TimeUnit.SECONDS);
                if (CollectionUtils.isEmpty((Collection)results)) continue;
                allResults.addAll(results);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.error("{}\u865a\u62df\u7ebf\u7a0b\u6267\u884c\u5f02\u5e38", (Object)logPrefix, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
        return allResults;
    }

    private static int calculateOptimalVirtualThreadCount(int partitionCount, int totalDataSize) {
        if (partitionCount <= 1) {
            return 1;
        }
        if (totalDataSize <= 1000) {
            return Math.min(partitionCount, 5);
        }
        if (totalDataSize <= 5000) {
            return Math.min(partitionCount, 20);
        }
        if (totalDataSize <= 20000) {
            return Math.min(partitionCount, 50);
        }
        if (totalDataSize <= 100000) {
            return Math.min(partitionCount, 100);
        }
        return Math.min(partitionCount, 200);
    }

    public static <T> List<List<T>> partitionList(List<T> list, int partitionSize) {
        if (CollectionUtils.isEmpty(list) || partitionSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<List<T>> partitions = new ArrayList<List<T>>();
        int size = list.size();
        for (int i = 0; i < size; i += partitionSize) {
            int end = Math.min(i + partitionSize, size);
            partitions.add(new ArrayList<T>(list.subList(i, end)));
        }
        return partitions;
    }

    public static String getProcessingStrategy(int dataSize) {
        if (dataSize <= 1000) {
            return "\u76f4\u63a5\u5904\u7406";
        }
        if (dataSize <= 5000) {
            return "\u6807\u51c6\u5206\u7247(500)";
        }
        if (dataSize <= 20000) {
            return "\u4f18\u5316\u5206\u7247(1000)";
        }
        if (dataSize <= 100000) {
            return "\u5c0f\u5206\u7247(2000)";
        }
        if (dataSize <= 500000) {
            return "\u6781\u5c0f\u5206\u7247(5000)";
        }
        if (dataSize <= 1000000) {
            return "\u6d77\u91cf\u5206\u7247(10000)";
        }
        return "\u6781\u9650\u5206\u7247(10000)";
    }

    public static int getOptimalPartitionSize(int dataSize) {
        if (dataSize <= 1000) {
            return dataSize;
        }
        if (dataSize <= 5000) {
            return 500;
        }
        if (dataSize <= 20000) {
            return 1000;
        }
        if (dataSize <= 100000) {
            return 2000;
        }
        if (dataSize <= 500000) {
            return 5000;
        }
        if (dataSize <= 1000000) {
            return 10000;
        }
        return 10000;
    }
}

