/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.platform.utils;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchProcessingMetrics {
    private static final Logger logger = LoggerFactory.getLogger(BatchProcessingMetrics.class);
    private final String methodName;
    private final int totalItems;
    private final int batchSize;
    private final int totalBatches;
    private final AtomicLong startTime = new AtomicLong();
    private final AtomicInteger completedBatches = new AtomicInteger(0);
    private final AtomicInteger processedItems = new AtomicInteger(0);
    private final AtomicInteger failedBatches = new AtomicInteger(0);

    public BatchProcessingMetrics(String methodName, int totalItems, int batchSize) {
        this.methodName = methodName;
        this.totalItems = totalItems;
        this.batchSize = batchSize;
        this.totalBatches = (int)Math.ceil((double)totalItems / (double)batchSize);
        this.startTime.set(System.currentTimeMillis());
    }

    public void batchStarted(int batchIndex) {
        logger.debug("{}: Batch {}/{} started", new Object[]{this.methodName, batchIndex + 1, this.totalBatches});
    }

    public void batchCompleted(int batchIndex, int itemsProcessed) {
        int completed = this.completedBatches.incrementAndGet();
        this.processedItems.addAndGet(itemsProcessed);
        long elapsedTime = System.currentTimeMillis() - this.startTime.get();
        double progress = (double)completed / (double)this.totalBatches * 100.0;
        double itemsPerSecond = (double)this.processedItems.get() / ((double)elapsedTime / 1000.0);
        logger.info("{}: Batch {}/{} completed - Progress: {:.1f}%, Items/sec: {:.0f}", new Object[]{this.methodName, batchIndex + 1, this.totalBatches, progress, itemsPerSecond});
        if (completed % 10 == 0 || progress % 10.0 < 1.0) {
            this.reportDetailedStatus();
        }
    }

    public void batchFailed(int batchIndex, String errorMessage) {
        this.failedBatches.incrementAndGet();
        logger.error("{}: Batch {}/{} failed - {}", new Object[]{this.methodName, batchIndex + 1, this.totalBatches, errorMessage});
    }

    public void reportDetailedStatus() {
        long elapsedTime = System.currentTimeMillis() - this.startTime.get();
        int completed = this.completedBatches.get();
        int processed = this.processedItems.get();
        int failed = this.failedBatches.get();
        double progress = (double)completed / (double)this.totalBatches * 100.0;
        double itemsPerSecond = (double)processed / ((double)elapsedTime / 1000.0);
        double estimatedRemainingTime = (double)(this.totalItems - processed) / itemsPerSecond;
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        double memoryUsage = (double)usedMemory / (double)maxMemory * 100.0;
        logger.info("{}: STATUS - Progress: {:.1f}% ({}/{} batches), Items: {}/{}, Failed: {}, Speed: {:.0f} items/sec, ETA: {:.0f}s, Memory: {:.1f}% used", new Object[]{this.methodName, progress, completed, this.totalBatches, processed, this.totalItems, failed, itemsPerSecond, estimatedRemainingTime, memoryUsage});
    }

    public void reportFinalResult() {
        long totalTime = System.currentTimeMillis() - this.startTime.get();
        int completed = this.completedBatches.get();
        int processed = this.processedItems.get();
        int failed = this.failedBatches.get();
        double successRate = (double)completed / (double)this.totalBatches * 100.0;
        double itemsPerSecond = (double)processed / ((double)totalTime / 1000.0);
        logger.info("{}: FINAL RESULT - Time: {}ms, Batches: {}/{}, Items: {}/{}, Success Rate: {:.1f}%, Speed: {:.0f} items/sec", new Object[]{this.methodName, totalTime, completed, this.totalBatches, processed, this.totalItems, successRate, itemsPerSecond});
        if (failed > 0) {
            logger.warn("{}: {} batches failed during processing", (Object)this.methodName, (Object)failed);
        }
    }

    public double getProgressPercentage() {
        return (double)this.completedBatches.get() / (double)this.totalBatches * 100.0;
    }

    public double getProcessingSpeed() {
        long elapsedTime = System.currentTimeMillis() - this.startTime.get();
        if (elapsedTime == 0L) {
            return 0.0;
        }
        return (double)this.processedItems.get() / ((double)elapsedTime / 1000.0);
    }

    public double getEstimatedRemainingTime() {
        double speed = this.getProcessingSpeed();
        if (speed == 0.0) {
            return Double.MAX_VALUE;
        }
        return (double)(this.totalItems - this.processedItems.get()) / speed;
    }

    public boolean isCompleted() {
        return this.completedBatches.get() + this.failedBatches.get() >= this.totalBatches;
    }

    public double getMemoryUsagePercentage() {
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        return (double)usedMemory / (double)maxMemory * 100.0;
    }
}

