/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.response.AllStorageInfoRes;
import com.ovopark.device.signalling.model.response.AllStorageInfoResData;
import com.ovopark.device.signalling.model.response.GetLocalStorageTypeRes;
import com.ovopark.device.signalling.model.response.ResultRes;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageInfoUtil {
    private static Logger log = LoggerFactory.getLogger(StorageInfoUtil.class);

    public static AllStorageInfoResData getAllStorageInfoReq(String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/getNvrStorageInfoReq", nvrMac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(reqName);
        req.setHost(upgradeServer);
        req.setPort(upgradePort);
        req.setAuthentication(authentication);
        req.setRespTimeout(10000);
        req.setConnectTimeout(3000);
        req.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(req);
        if (StringUtils.isEmpty((CharSequence)s)) {
            AllStorageInfoResData allStorageInfoResData = new AllStorageInfoResData();
            AllStorageInfoRes recRes = new AllStorageInfoRes();
            recRes.setResult(404003);
            allStorageInfoResData.setData(recRes);
            return allStorageInfoResData;
        }
        if (s.contains("result=404001")) {
            AllStorageInfoResData allStorageInfoResData = new AllStorageInfoResData();
            AllStorageInfoRes recRes = new AllStorageInfoRes();
            recRes.setResult(404001);
            allStorageInfoResData.setData(recRes);
            return allStorageInfoResData;
        }
        return (AllStorageInfoResData)JsonUtils.jsonToBean((String)s, AllStorageInfoResData.class);
    }

    public static Boolean setLocalStorageType(String nvrMac, Integer storageType, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/setLocalStorageType", nvrMac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(reqName);
        req.setHost(upgradeServer);
        req.setPort(upgradePort);
        req.setAuthentication(authentication);
        req.setRespTimeout(10000);
        req.setConnectTimeout(3000);
        req.setNeed2n(false);
        HashMap<String, Integer> reqMsg = new HashMap<String, Integer>();
        reqMsg.put("storageType", storageType);
        req.setMsgContent(JsonUtils.beanToJsonString(reqMsg));
        String s = SocketUtil.sendRequestToDmsGetStr(req);
        if (StringUtils.isEmpty((CharSequence)s)) {
            log.error("reqName:{},\u5931\u8d25", (Object)reqName);
            return false;
        }
        return ((ResultRes)Objects.requireNonNull(JsonUtils.jsonToBean((String)s, ResultRes.class))).getResult() == 200000;
    }

    public static GetLocalStorageTypeRes getLocalStorageType(String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/getLocalStorageType", nvrMac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(reqName);
        req.setHost(upgradeServer);
        req.setPort(upgradePort);
        req.setAuthentication(authentication);
        req.setRespTimeout(10000);
        req.setConnectTimeout(3000);
        req.setNeed2n(false);
        req.setMsgContent("");
        String s = SocketUtil.sendRequestToDmsGetStr(req);
        System.out.println(s);
        if (StringUtils.isEmpty((CharSequence)s)) {
            GetLocalStorageTypeRes res = new GetLocalStorageTypeRes();
            res.setResult(404003);
            return res;
        }
        if (s.contains("result=404001")) {
            GetLocalStorageTypeRes res = new GetLocalStorageTypeRes();
            res.setResult(404001);
            return res;
        }
        return (GetLocalStorageTypeRes)JsonUtils.jsonToBean((String)s, GetLocalStorageTypeRes.class);
    }
}

