/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.ovopark.device.common.util.JsonUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgUtil {
    private static Logger log = LoggerFactory.getLogger(MsgUtil.class);

    public static String parseResult(String reMsg) {
        String[] splits;
        if (reMsg != null && reMsg.length() > 0 && (splits = reMsg.split("\r\n")).length > 0) {
            reMsg = splits[splits.length - 1];
        }
        return reMsg == null ? "" : reMsg;
    }

    public static HashMap<String, Object> parseToMap(String reMsg) {
        HashMap map = new HashMap();
        if (reMsg != null) {
            String[] splits;
            for (String split : splits = reMsg.split("&")) {
                String[] parts = split.split("=");
                if (parts.length != 2) continue;
                map.put(parts[0], parts[1]);
            }
        }
        if (map.isEmpty()) {
            map = (HashMap)JsonUtils.jsonToBean((String)reMsg, HashMap.class);
        }
        return map;
    }

    public static String createMsgContent(String cmdName, String host, Integer port, int length, String authentication, String content, String sessionId) {
        if (StringUtils.isEmpty((CharSequence)sessionId)) {
            sessionId = System.currentTimeMillis() + (long)new Random().nextInt() + "";
        }
        String format = MessageFormat.format("POST /{0} RS/1.0\r\nHost: {1}:{2}\r\nContent-Length: {3}\r\nSession-Id: {4}\r\nAuthentication: Basic {5}\r\n\r\n{6}\r\n\r\n", cmdName, host, String.valueOf(port), String.valueOf(length), sessionId, authentication, content);
        log.info("\u53d1\u9001\u5185\u5bb9\uff1a{}", (Object)format.replace("\r\n", "\u6362\u884c"));
        return format;
    }

    public static String createSingleMsgContent(String cmdName, String host, Integer port, int length, String authentication, String content, String sessionId) {
        if (StringUtils.isEmpty((CharSequence)sessionId)) {
            sessionId = System.currentTimeMillis() + (long)new Random().nextInt() + "";
        }
        String format = MessageFormat.format("POST /{0} RS/1.0\r\nHost: {1}:{2}\r\nContent-Length: {3}\r\nSession-Id: {4}\r\nAuthentication: Basic {5}\r\n\r\n{6}\r\n", cmdName, host, String.valueOf(port), String.valueOf(length), sessionId, authentication, content);
        log.info("\u53d1\u9001\u5185\u5bb9\uff1a{}", (Object)format.replace("\r\n", "\u6362\u884c"));
        return format;
    }
}

