/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class HttpUtil {
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(2L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();

    public static String get(String url, Integer connectTimeout, Integer readTimeout) throws Exception {
        OkHttpClient clientNew = client.newBuilder().connectTimeout(connectTimeout == null ? 3000L : (long)connectTimeout.intValue(), TimeUnit.MILLISECONDS).readTimeout(readTimeout == null ? 30000L : (long)readTimeout.intValue(), TimeUnit.MILLISECONDS).build();
        Request request = new Request.Builder().url(url).build();
        try (Response response = clientNew.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String string = response.body().string();
            return string;
        }
    }

    public static String postJson(String url, String json, Integer connectTimeout, Integer readTimeout) throws Exception {
        OkHttpClient clientNew = client.newBuilder().connectTimeout(connectTimeout == null ? 3000L : (long)connectTimeout.intValue(), TimeUnit.MILLISECONDS).readTimeout(readTimeout == null ? 30000L : (long)readTimeout.intValue(), TimeUnit.MILLISECONDS).build();
        Request request = null;
        if (StringUtils.isEmpty((CharSequence)json)) {
            json = "{}";
        }
        RequestBody body = RequestBody.create((String)json, (MediaType)JSON);
        request = new Request.Builder().url(url).post(body).build();
        try (Response response = clientNew.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String string = response.body().string();
            return string;
        }
    }
}

