/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.signalling.contact.RequestNameContact;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.response.BaseRes;
import com.ovopark.device.signalling.model.response.PatrolLineItemRes;
import com.ovopark.device.signalling.model.response.RobotLocationBaseRes;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;

public class RobotUtil {
    public static BaseRes<List<RobotLocationBaseRes>> getLocation(String mac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getLocation, mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(10000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        BaseRes res = new BaseRes();
        try {
            res = (BaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<BaseRes<List<RobotLocationBaseRes>>>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return res;
    }

    public static BaseRes gotoLocation(String mac, String upgradeServer, Integer upgradePort, String authentication, Integer id) {
        String reqName = MessageFormat.format(RequestNameContact.gotoLocation, mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        HashMap<String, Integer> map = new HashMap<String, Integer>(1);
        map.put("id", id);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(map));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        BaseRes res = new BaseRes();
        try {
            res = (BaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<BaseRes>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return res;
    }

    public static BaseRes<List<PatrolLineItemRes>> getPatrolLine(String mac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getPatrolLine, mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        BaseRes res = new BaseRes();
        try {
            res = (BaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<BaseRes<List<PatrolLineItemRes>>>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return res;
    }

    public static BaseRes startPatrolLine(String mac, String upgradeServer, Integer upgradePort, String authentication, Integer id) {
        String reqName = MessageFormat.format(RequestNameContact.startPatrolLine, mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        HashMap<String, Integer> map = new HashMap<String, Integer>(1);
        map.put("id", id);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(map));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        BaseRes res = new BaseRes();
        try {
            res = (BaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<BaseRes>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return res;
    }

    public static BaseRes stopPatrol(String mac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.stopPatrol, mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        BaseRes res = new BaseRes();
        try {
            res = (BaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<BaseRes>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return res;
    }
}

