/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.request.SetPflowHotEnableReq;
import com.ovopark.device.signalling.model.response.ResultRes;
import com.ovopark.device.signalling.model.response.SetPflowHotEnableRes;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pc4Util {
    private static final Logger log = LoggerFactory.getLogger(Pc4Util.class);

    public static ResultRes setPflowHotEnable(String mac, Integer type, String upgradeServer, Integer upgradePort) {
        String reqName = MessageFormat.format("pu/{0}/setPflowHotEnable", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        SetPflowHotEnableReq req = new SetPflowHotEnableReq();
        req.setType(type);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(SocketUtil.authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        return (ResultRes)JsonUtils.jsonToBean((String)s, ResultRes.class);
    }

    public static SetPflowHotEnableRes getPflowHotEnable(String mac, String upgradeServer, Integer upgradePort) {
        String reqName = MessageFormat.format("pu/{0}/getPflowHotEnable", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(null);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(SocketUtil.authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        return (SetPflowHotEnableRes)JsonUtils.jsonToBean((String)s, SetPflowHotEnableRes.class);
    }
}

