/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.signalling.model.request.robot.RobotTaskReq;
import com.ovopark.device.signalling.model.response.Dms2New1Res;
import com.ovopark.device.signalling.model.response.ResultRes;
import com.ovopark.device.signalling.model.response.RobotGetChargerCfgRes;
import com.ovopark.device.signalling.model.response.RobotGetCurPositionRes;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RobotNewUtil {
    private static final Logger log = LoggerFactory.getLogger(RobotNewUtil.class);
    public static final Integer ROBOT_TRIGGERMAPPING_START = 1;
    public static final Integer ROBOT_TRIGGERMAPPING_STOP = 2;
    public static final Integer ROBOT_RESULT_SUCCESS = 200000;
    public static final Integer ROBOT_MAP_BUILD_CAN_NOT_USE = 420001;
    public static final Integer ROBOT_MAP_BUILD_SERVER_NO_RES = 420002;
    public static final Integer ROBOT_MAP_BUILD_TASK_CLASH = 420003;
    public static final Integer ROBOT_MAP_BUILD_TASK_NOT_EXIT = 420004;

    public static ResultRes triggerMapping(String nvrMac, Integer command, String taskId) {
        HashMap<String, Object> reqParam = new HashMap<String, Object>();
        reqParam.put("taskId", taskId);
        reqParam.put("command", command);
        String setChnNameConfig = SocketUtil.sendToDms2("triggerMapping", nvrMac, JsonUtils.beanToJsonString(reqParam), 10000);
        ResultRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (ResultRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<ResultRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static ResultRes setTimerTaskCfg(RobotTaskReq req, String robotMac) {
        String setChnNameConfig = SocketUtil.sendToDms2("setTimerTaskCfg", robotMac, JsonUtils.beanToJsonString((Object)req), 3000);
        ResultRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (ResultRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<ResultRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static ResultRes delTimerTaskCfg(List<Integer> taskIdList, String robotMac) {
        HashMap<String, List<Integer>> req = new HashMap<String, List<Integer>>();
        req.put("taskIdList", taskIdList);
        String setChnNameConfig = SocketUtil.sendToDms2("delTimerTaskCfg", robotMac, JsonUtils.beanToJsonString(req), 3000);
        ResultRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (ResultRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<ResultRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static Dms2New1Res<RobotGetCurPositionRes> getCurPosition(String robotMac) {
        String setChnNameConfig = SocketUtil.sendToDms2("robot/getCurPosition", robotMac, null, 3000);
        Dms2New1Res algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (Dms2New1Res)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<Dms2New1Res<RobotGetCurPositionRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static Dms2New1Res gotoPosition(String robotMac, RobotGetCurPositionRes req) {
        String setChnNameConfig = SocketUtil.sendToDms2("robot/gotoPosition", robotMac, JsonUtils.beanToJsonString((Object)req), 3000);
        Dms2New1Res algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (Dms2New1Res)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<Dms2New1Res<RobotGetCurPositionRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static Dms2New1Res setChargerCfg(String robotMac, RobotGetChargerCfgRes req) {
        String setChnNameConfig = SocketUtil.sendToDms2("robot/setChargerCfg", robotMac, JsonUtils.beanToJsonString((Object)req), 3000);
        Dms2New1Res algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (Dms2New1Res)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<Dms2New1Res<RobotGetCurPositionRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }
}

