/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.signalling.contact.Fr3RequestNameContact;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.TaskSnapshotByNvrMo;
import com.ovopark.device.signalling.model.request.TaskSnapshotByNvrReq;
import com.ovopark.device.signalling.model.response.BooleanAndResult;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotUtil {
    private static Logger log = LoggerFactory.getLogger(SnapshotUtil.class);

    private SnapshotUtil() {
    }

    public static BooleanAndResult taskSnapshotByNvr(TaskSnapshotByNvrMo mo, Integer connectTimeout, Integer respTimeout, String upgradeServer, Integer upgradePort, String authentication) {
        TaskSnapshotByNvrReq req = new TaskSnapshotByNvrReq();
        req.setVer("1.0");
        req.setSn(mo.getNvrMac());
        req.setIpcmac(mo.getIpcMac());
        req.setChannelId(mo.getChannelId());
        req.setAction(mo.getAction());
        req.setWaittimeBeforeSnap(mo.getWaitTimeBeforeSnap());
        req.setPreset(mo.getPreset());
        req.setTaskExpires(mo.getTaskExpires());
        req.setSnapType(mo.getSnapType());
        req.setTaskId(mo.getTaskId());
        req.setSessionId(mo.getSessionId());
        TaskSnapshotByNvrReq.UploadInfoBean uploadInfoBean = new TaskSnapshotByNvrReq.UploadInfoBean();
        uploadInfoBean.setUrl(mo.getUploadUrl());
        uploadInfoBean.setUser(mo.getUser());
        uploadInfoBean.setPass(mo.getPass());
        req.setStreamType(0);
        req.setUploadInfo(uploadInfoBean);
        String reqName = MessageFormat.format("pu/{0}/taskSnapshotByNvr", mo.getNvrMac());
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String s1 = null;
        try {
            s1 = mapper.writeValueAsString((Object)req);
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
        }
        socketBaseReq.setMsgContent(s1);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        if (connectTimeout != null) {
            socketBaseReq.setConnectTimeout(connectTimeout);
        }
        if (respTimeout != null) {
            socketBaseReq.setRespTimeout(respTimeout);
        }
        socketBaseReq.setNeed2n(false);
        Map<String, Object> stringStringMap = SocketUtil.sendRequestToDms(socketBaseReq);
        if (stringStringMap.get("result") != null && (Integer)stringStringMap.get("result") == 200000) {
            BooleanAndResult booleanAndResult = new BooleanAndResult();
            booleanAndResult.setSuccess(true);
            booleanAndResult.setResult(200000);
            return booleanAndResult;
        }
        BooleanAndResult booleanAndResult = new BooleanAndResult();
        booleanAndResult.setSuccess(false);
        booleanAndResult.setResult((Integer)stringStringMap.get("result"));
        return booleanAndResult;
    }

    public static BooleanAndResult snapshotByPc4(String mac, String url, String sessionId, Integer connectTimeout, Integer respTimeout, String upgradeServer, Integer upgradePort, String authentication) {
        TaskSnapshotByNvrReq req = new TaskSnapshotByNvrReq();
        req.setVer("1.0");
        req.setSn(mac);
        req.setSessionId(sessionId);
        TaskSnapshotByNvrReq.UploadInfoBean uploadInfoBean = new TaskSnapshotByNvrReq.UploadInfoBean();
        String postUrl = url + "?mac=" + mac + "&sessionId=" + sessionId;
        uploadInfoBean.setUrl(postUrl);
        uploadInfoBean.setPass("");
        uploadInfoBean.setUser("");
        req.setUploadInfo(uploadInfoBean);
        String reqName = MessageFormat.format("pu/{0}/snapshotByPc4", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        if (connectTimeout != null) {
            socketBaseReq.setConnectTimeout(connectTimeout);
        }
        if (respTimeout != null) {
            socketBaseReq.setRespTimeout(respTimeout);
        }
        socketBaseReq.setNeed2n(true);
        socketBaseReq.setSessionId(sessionId);
        Map<String, Object> stringStringMap = SocketUtil.sendRequestToDms(socketBaseReq);
        if (stringStringMap.get("result") != null && (Integer)stringStringMap.get("result") == 200000) {
            BooleanAndResult booleanAndResult = new BooleanAndResult();
            booleanAndResult.setSuccess(true);
            booleanAndResult.setResult(200000);
            return booleanAndResult;
        }
        BooleanAndResult booleanAndResult = new BooleanAndResult();
        booleanAndResult.setSuccess(false);
        booleanAndResult.setResult((Integer)stringStringMap.get("result"));
        return booleanAndResult;
    }

    public static BooleanAndResult fr3Snapshot(String mac, String url, String sessionId, Integer connectTimeout, Integer respTimeout, String upgradeServer, Integer upgradePort, String authentication) {
        String msgContent = url + "?mac=" + mac + "&sessionId=" + sessionId;
        String reqName = MessageFormat.format(Fr3RequestNameContact.FR3_SNAPSHOT, mac);
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("uploadurl", msgContent);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(map));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        if (connectTimeout != null) {
            socketBaseReq.setConnectTimeout(connectTimeout);
        }
        if (respTimeout != null) {
            socketBaseReq.setRespTimeout(respTimeout);
        }
        socketBaseReq.setNeed2n(false);
        Map<String, Object> stringStringMap = SocketUtil.sendRequestToDms(socketBaseReq);
        if (stringStringMap.get("result") != null && (Integer)stringStringMap.get("result") == 200000) {
            BooleanAndResult booleanAndResult = new BooleanAndResult();
            booleanAndResult.setSuccess(true);
            booleanAndResult.setResult(200000);
            return booleanAndResult;
        }
        BooleanAndResult booleanAndResult = new BooleanAndResult();
        booleanAndResult.setSuccess(false);
        booleanAndResult.setResult((Integer)stringStringMap.get("result"));
        return booleanAndResult;
    }
}

