/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.signalling.contact.RequestNameContact;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.response.BaseRes;
import com.ovopark.device.signalling.model.response.GetAreaOSDStatusRes;
import com.ovopark.device.signalling.model.response.PflowPeriodCompareLevelRes;
import com.ovopark.device.signalling.model.response.SetPflowReidCfgRes;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PassengerFlowUtil {
    public static BaseRes setPflowReidCfg(String nvrMac, String upgradeServer, Integer upgradePort, String authentication, SetPflowReidCfgRes mo) {
        String reqName = MessageFormat.format(RequestNameContact.setPflowReidCfg, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)mo));
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (BaseRes)JsonUtils.jsonToBean((String)s, BaseRes.class);
    }

    public static BaseRes<SetPflowReidCfgRes> getPflowReidCfg(String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getPflowReidCfg, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        try {
            return (BaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<BaseRes<SetPflowReidCfgRes>>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }

    public static BaseRes<List<PflowPeriodCompareLevelRes>> getPflowPeriodCompareLevel(String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getPflowPeriodCompareLevel, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        try {
            return (BaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<BaseRes<List<PflowPeriodCompareLevelRes>>>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }

    public static BaseRes setPflowPeriodCompareLevel(String nvrMac, String upgradeServer, Integer upgradePort, String authentication, List<PflowPeriodCompareLevelRes> req) {
        String reqName = MessageFormat.format(RequestNameContact.setPflowPeriodCompareLevel, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(req));
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        try {
            return (BaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<BaseRes>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }

    public static BaseRes setAreaOSDStatus(String nvrMac, String upgradeServer, Integer upgradePort, String authentication, int enable, Integer language, Integer drawBody, Integer drawBodyId, Integer drawMaskArea) {
        String reqName = MessageFormat.format(RequestNameContact.setAreaOSDStatus, nvrMac);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(1);
        paramMap.put("enable", enable);
        paramMap.put("language", language);
        paramMap.put("drawBody", drawBody);
        paramMap.put("drawBodyId", drawBodyId);
        paramMap.put("drawMaskArea", drawMaskArea);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(paramMap));
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (BaseRes)JsonUtils.jsonToBean((String)s, BaseRes.class);
    }

    public static BaseRes<GetAreaOSDStatusRes> getAreaOSDStatus(String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getAreaOSDStatus, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        try {
            return (BaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<BaseRes<GetAreaOSDStatusRes>>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }
}

