/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.signalling.contact.ConfigMap;
import com.ovopark.device.signalling.contact.RequestNameContact;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.request.AllChnMonthRecReqReq;
import com.ovopark.device.signalling.model.response.AllChnMonthRecRes;
import com.ovopark.device.signalling.model.response.ChnTimeCellRecRes;
import com.ovopark.device.signalling.model.response.GetRecMonthListRes;
import com.ovopark.device.signalling.model.response.RecDailyRes;
import com.ovopark.device.signalling.socket.SocketUtil;
import com.ovopark.device.signalling.util.AbilityUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecUtil {
    private static Logger log = LoggerFactory.getLogger(RecUtil.class);

    public static AllChnMonthRecRes getAllChnMonthRecReq(Integer year, Integer month, String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/getAllChnMonthRecReq", nvrMac);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("year", year);
        map.put("month", month);
        String jsonString = JsonUtils.beanToJsonString(map);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(reqName);
        req.setMsgContent(jsonString);
        req.setHost(upgradeServer);
        req.setPort(upgradePort);
        req.setAuthentication(authentication);
        req.setRespTimeout(10000);
        req.setConnectTimeout(3000);
        req.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(req);
        log.info("-------" + s);
        if (StringUtils.isEmpty((CharSequence)s)) {
            AllChnMonthRecRes recRes = new AllChnMonthRecRes();
            recRes.setResult(404003);
            return recRes;
        }
        if (s.contains("result=404001")) {
            AllChnMonthRecRes recRes = new AllChnMonthRecRes();
            recRes.setResult(404001);
            return recRes;
        }
        log.info("=========================" + s);
        return (AllChnMonthRecRes)JsonUtils.jsonToBean((String)s, AllChnMonthRecRes.class);
    }

    public static ChnTimeCellRecRes getChnTimeCellRecReq(AllChnMonthRecReqReq req, String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/getChnTimeCellRecReq", nvrMac);
        String jsonString = JsonUtils.beanToJsonString((Object)req);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(jsonString);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        return (ChnTimeCellRecRes)JsonUtils.jsonToBean((String)s, ChnTimeCellRecRes.class);
    }

    public static GetRecMonthListRes getRecMonthList(String nvrMac, String nvrExtendCapacity, String ipcMac, Integer channelId, Integer year, Integer month, String upgradeServer, Integer upgradePort, String authentication) {
        String msgContent = MessageFormat.format("mac={0}&ipcmac={1}|channelId={2}|year={3}|month={4}", nvrMac, ipcMac, channelId, String.valueOf(year), month);
        if (StringUtils.isEmpty((CharSequence)nvrExtendCapacity) || !AbilityUtil.supportXvr(nvrExtendCapacity)) {
            msgContent = MessageFormat.format("mac={0}&ipcmac={1}|year={2}|month={3}", nvrMac, ipcMac, String.valueOf(year), month);
        }
        String dms2Server = ConfigMap.map.get("DMS_2_SERVER_IP");
        HashMap<String, Integer> dmsReq = new HashMap<String, Integer>();
        boolean supportDms2Flag = StringUtils.equals((CharSequence)upgradeServer, (CharSequence)dms2Server);
        if (supportDms2Flag) {
            dmsReq.put("channelId", channelId);
            dmsReq.put("year", year);
            dmsReq.put("month", month);
            msgContent = JsonUtils.beanToJsonString(dmsReq);
        }
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(supportDms2Flag ? RequestNameContact.NVR_GetRecMonthList + "&" + nvrMac : RequestNameContact.NVR_GetRecMonthList);
        socketBaseReq.setMsgContent(msgContent);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            GetRecMonthListRes recRes = new GetRecMonthListRes();
            recRes.setResult(404003);
            return recRes;
        }
        if (s.contains("result=404001")) {
            GetRecMonthListRes recRes = new GetRecMonthListRes();
            recRes.setResult(404001);
            return recRes;
        }
        return (GetRecMonthListRes)JsonUtils.jsonToBean((String)s, GetRecMonthListRes.class);
    }

    public static RecDailyRes getRecDaily(String nvrMac, String nvrExtendCapacity, String ipcMac, Integer channelId, Long startTime, Long endTime, String upgradeServer, Integer upgradePort, String authentication) {
        List<Long> longs;
        List<List<Long>> result;
        String msgContent = MessageFormat.format("mac={0}&ipcmac={1}|channelId={2}|starttime={3}|endtime={4}", nvrMac, ipcMac, channelId, startTime.toString(), endTime.toString());
        if (StringUtils.isEmpty((CharSequence)nvrExtendCapacity) || !AbilityUtil.supportXvr(nvrExtendCapacity)) {
            msgContent = MessageFormat.format("mac={0}&ipcmac={1}|starttime={2}|endtime={3}", nvrMac, ipcMac, startTime.toString(), endTime.toString());
        }
        String dms2Server = ConfigMap.map.get("DMS_2_SERVER_IP");
        HashMap<String, Number> dmsReq = new HashMap<String, Number>();
        boolean supportDms2Flag = StringUtils.equals((CharSequence)upgradeServer, (CharSequence)dms2Server);
        if (supportDms2Flag) {
            dmsReq.put("channelId", channelId);
            dmsReq.put("starttime", startTime);
            dmsReq.put("endtime", endTime);
            msgContent = JsonUtils.beanToJsonString(dmsReq);
        }
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(supportDms2Flag ? RequestNameContact.NVR_GetRecDailyList + "&" + nvrMac : RequestNameContact.NVR_GetRecDailyList);
        socketBaseReq.setMsgContent(msgContent);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        RecDailyRes recDailyRes = new RecDailyRes();
        if (StringUtils.isEmpty((CharSequence)s)) {
            recDailyRes.setResult(404003);
            return recDailyRes;
        }
        if (s.contains("result=404001")) {
            recDailyRes.setResult(404001);
            return recDailyRes;
        }
        RecDailyRes recDailyRes1 = (RecDailyRes)JsonUtils.jsonToBean((String)s, RecDailyRes.class);
        if (recDailyRes1 == null) {
            recDailyRes.setResult(23333001);
            return recDailyRes;
        }
        RecDailyRes.ResultDetailBean resultDetail = recDailyRes1.getResultDetail();
        if (resultDetail != null && (result = resultDetail.getResult()) != null && !result.isEmpty() && (longs = result.get(0)) != null && longs.size() == 1) {
            resultDetail.setResult(new ArrayList<List<Long>>());
        }
        return recDailyRes1;
    }
}

