/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.signalling.contact.RequestNameContact;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.request.PtzKeepCtrlByNvrReq;
import com.ovopark.device.signalling.model.request.PtzMoveByNvrReq;
import com.ovopark.device.signalling.model.request.PtzPatrolCtrlByNvrReq;
import com.ovopark.device.signalling.model.request.PtzQwtPlotZoomerByNvrMo;
import com.ovopark.device.signalling.model.request.SetOnvifParkReqReq;
import com.ovopark.device.signalling.model.response.BooleanAndResult;
import com.ovopark.device.signalling.model.response.FlipDirectionRes;
import com.ovopark.device.signalling.model.response.PtzKeepCtrlByNvrRes;
import com.ovopark.device.signalling.model.response.PtzMoveByNvrRes;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtzUtil {
    private static Logger log = LoggerFactory.getLogger(PtzUtil.class);
    private static String userName = "admin";
    private static String passWord = "admin123";

    public static PtzKeepCtrlByNvrRes ptzKeepCtrlByNvr(String nvrMac, PtzKeepCtrlByNvrReq req, String host, Integer port, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/ptzKeepCtrlByNvr", nvrMac);
        String jsonString = JsonUtils.beanToJsonString((Object)req);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(jsonString);
        socketBaseReq.setHost(host);
        socketBaseReq.setPort(port);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        return (PtzKeepCtrlByNvrRes)JsonUtils.jsonToBean((String)s, PtzKeepCtrlByNvrRes.class);
    }

    public static PtzMoveByNvrRes ptzMoveByNvr(String nvrMac, PtzMoveByNvrReq req, String host, Integer port, String authentication) {
        String requstName = MessageFormat.format(RequestNameContact.ptzMoveByNvr, nvrMac);
        String msgContent = MessageFormat.format("devsn={0}&ipcmac={1}&channelId={2}&cmd={3}&para1={4}&para2={5}&para3={6}", nvrMac, req.getIpcMac(), req.getChannelId(), req.getCmd(), req.getStatus(), req.getTime() == null ? "" : req.getTime().toString(), req.getPresetNo() == null ? "" : req.getPresetNo());
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(requstName);
        socketBaseReq.setMsgContent(msgContent);
        socketBaseReq.setHost(host);
        socketBaseReq.setPort(port);
        socketBaseReq.setNeed2n(false);
        socketBaseReq.setAuthentication(authentication);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        return (PtzMoveByNvrRes)JsonUtils.jsonToBean((String)s, PtzMoveByNvrRes.class);
    }

    public static BooleanAndResult setOnvifParkReq(String nvrMac, SetOnvifParkReqReq req, String host, Integer port, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.setOnvifParkReq, nvrMac);
        if (StringUtils.isEmpty((CharSequence)req.getUserName())) {
            req.setUserName(userName);
        }
        if (StringUtils.isEmpty((CharSequence)req.getPassWord())) {
            req.setPassWord(passWord);
        }
        String jsonString = JsonUtils.beanToJsonString((Object)req);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(jsonString);
        socketBaseReq.setHost(host);
        socketBaseReq.setPort(port);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        Map<String, Object> stringStringMap = SocketUtil.sendRequestToDms(socketBaseReq);
        if (stringStringMap.get("result") == null) {
            BooleanAndResult booleanAndResult = new BooleanAndResult();
            booleanAndResult.setSuccess(false);
            booleanAndResult.setResult(404001);
            return booleanAndResult;
        }
        if (stringStringMap.get("result") != null && Integer.parseInt(stringStringMap.get("result").toString()) == 200000) {
            BooleanAndResult booleanAndResult = new BooleanAndResult();
            booleanAndResult.setSuccess(true);
            booleanAndResult.setResult(200000);
            return booleanAndResult;
        }
        BooleanAndResult booleanAndResult = new BooleanAndResult();
        booleanAndResult.setSuccess(false);
        booleanAndResult.setResult(Integer.parseInt(stringStringMap.get("result").toString()));
        return booleanAndResult;
    }

    public static BooleanAndResult setOnvifSww(String nvrMac, String ipcMac, Integer channelId, Integer presetNum, Integer openFlag, String host, Integer port, String authentication, Integer parkWaitingTime) {
        SetOnvifParkReqReq req = new SetOnvifParkReqReq();
        req.setIpcMac(ipcMac);
        req.setChannelId(channelId);
        req.setPresetNum(presetNum);
        req.setParkEnable(openFlag);
        req.setDevType(0);
        req.setParkType(0);
        req.setParkWaitTime(parkWaitingTime);
        return PtzUtil.setOnvifParkReq(nvrMac, req, host, port, authentication);
    }

    public static BooleanAndResult ptzPatrolCtrlByNvr(String nvrMac, PtzPatrolCtrlByNvrReq req, String host, Integer port, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.ptzPatrolCtrlByNvr, nvrMac);
        String jsonString = JsonUtils.beanToJsonString((Object)req);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(jsonString);
        socketBaseReq.setHost(host);
        socketBaseReq.setPort(port);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        Map<String, Object> stringStringMap = SocketUtil.sendRequestToDms(socketBaseReq);
        if (stringStringMap.get("result") != null && (Integer)stringStringMap.get("result") == 200000) {
            BooleanAndResult booleanAndResult = new BooleanAndResult();
            booleanAndResult.setSuccess(true);
            booleanAndResult.setResult(200000);
            return booleanAndResult;
        }
        BooleanAndResult booleanAndResult = new BooleanAndResult();
        booleanAndResult.setSuccess(false);
        booleanAndResult.setResult((Integer)stringStringMap.get("result"));
        return booleanAndResult;
    }

    public static BooleanAndResult setFlipDirection(String nvrMac, String ipcMac, Integer channelId, Integer direction, String host, Integer port, String authentication) {
        HashMap<String, Object> request = new HashMap<String, Object>(3);
        request.put("ipcmac", ipcMac);
        request.put("channelId", channelId);
        request.put("direction", direction);
        String jsonString = JsonUtils.beanToJsonString(request);
        String reqName = MessageFormat.format(RequestNameContact.setFlipDirection, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(jsonString);
        socketBaseReq.setHost(host);
        socketBaseReq.setPort(port);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        Map<String, Object> stringStringMap = SocketUtil.sendRequestToDms(socketBaseReq);
        if (stringStringMap.get("result") != null && (Integer)stringStringMap.get("result") == 200000) {
            BooleanAndResult booleanAndResult = new BooleanAndResult();
            booleanAndResult.setSuccess(true);
            booleanAndResult.setResult(200000);
            return booleanAndResult;
        }
        BooleanAndResult booleanAndResult = new BooleanAndResult();
        booleanAndResult.setSuccess(false);
        booleanAndResult.setResult((Integer)stringStringMap.get("result"));
        return booleanAndResult;
    }

    public static FlipDirectionRes getFlipDirection(String nvrMac, String host, Integer port, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getFlipDirection, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(null);
        socketBaseReq.setHost(host);
        socketBaseReq.setPort(port);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        FlipDirectionRes res = new FlipDirectionRes();
        if (StringUtils.isEmpty((CharSequence)s)) {
            res.setResult(404003);
            return res;
        }
        try {
            res = (FlipDirectionRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<FlipDirectionRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
        }
        return res;
    }

    public static BooleanAndResult ptzQwtPlotZoomerByNvr(String nvrMac, PtzQwtPlotZoomerByNvrMo mo, String host, Integer port, String authentication) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("ipcmac", mo.getIpcMac());
        request.put("channelId", mo.getChannelId());
        request.put("devType", mo.getDevType());
        request.put("cmd", mo.getCmd().toString());
        request.put("para1", mo.getPara1());
        request.put("para2", mo.getPara2());
        request.put("para3", mo.getPara3());
        request.put("para4", mo.getPara4());
        request.put("time", mo.getTime());
        String jsonString = JsonUtils.beanToJsonString(request);
        String reqName = MessageFormat.format(RequestNameContact.ptzQwtPlotZoomerByNvr, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(jsonString);
        socketBaseReq.setHost(host);
        socketBaseReq.setPort(port);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        Map<String, Object> stringStringMap = SocketUtil.sendRequestToDms(socketBaseReq);
        if (stringStringMap.get("result") != null && (Integer)stringStringMap.get("result") == 200000) {
            BooleanAndResult booleanAndResult = new BooleanAndResult();
            booleanAndResult.setSuccess(true);
            booleanAndResult.setResult(200000);
            return booleanAndResult;
        }
        BooleanAndResult booleanAndResult = new BooleanAndResult();
        booleanAndResult.setSuccess(false);
        booleanAndResult.setResult((Integer)stringStringMap.get("result"));
        return booleanAndResult;
    }
}

