/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.request.AlgoConfigReq;
import com.ovopark.device.signalling.model.request.ChnIdAndAlgiNameReq;
import com.ovopark.device.signalling.model.request.SetAlgoListReq;
import com.ovopark.device.signalling.model.request.SetAlgoRuleReq;
import com.ovopark.device.signalling.model.response.AlgoAlgoActiv;
import com.ovopark.device.signalling.model.response.AlgoSupportRes;
import com.ovopark.device.signalling.model.response.BaseRes;
import com.ovopark.device.signalling.model.response.Dms2New1Res;
import com.ovopark.device.signalling.model.response.DmsDeviceBaseRes;
import com.ovopark.device.signalling.model.response.GetAlgoListRes;
import com.ovopark.device.signalling.model.response.GetAlgoRuleRes;
import com.ovopark.device.signalling.model.response.GetAlgoTypeRes;
import com.ovopark.device.signalling.model.response.GetMultiLabelConfigRes;
import com.ovopark.device.signalling.model.response.ResultRes;
import com.ovopark.device.signalling.model.response.SetMultiReidCfgRes;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiUtil {
    private static Logger log = LoggerFactory.getLogger(AiUtil.class);
    public static final HashMap<String, String> labelNameMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("hat", "\u5e3d\u5b50");
            this.put("mask", "\u53e3\u7f69");
            this.put("work_clothes", "\u5de5\u670d");
            this.put("phone", "\u73a9\u624b\u673a");
            this.put("box", "\u7eb8\u7bb1");
        }
    };

    public static BaseRes<List<GetMultiLabelConfigRes>> getMultiLabelConfig(String mac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/getMultiLabelConfig", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        BaseRes listBaseRes = null;
        try {
            listBaseRes = (BaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<BaseRes<List<GetMultiLabelConfigRes>>>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        if (listBaseRes != null && listBaseRes.getData() != null) {
            for (GetMultiLabelConfigRes getMultiLabelConfigRes : (List)listBaseRes.getData()) {
                String label = getMultiLabelConfigRes.getLabel();
                String s1 = labelNameMap.get(label);
                getMultiLabelConfigRes.setLabelName(s1);
            }
        }
        return listBaseRes;
    }

    public static BaseRes setMultiLabelConfig(String mac, String upgradeServer, Integer upgradePort, String authentication, List<GetMultiLabelConfigRes> req) {
        String reqName = MessageFormat.format("pu/{0}/setMultiLabelConfig", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        BaseRes listBaseRes = null;
        try {
            listBaseRes = (BaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<BaseRes>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        return listBaseRes;
    }

    public static GetAlgoTypeRes getAlgoType(String mac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/getAlgoType", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (GetAlgoTypeRes)JsonUtils.jsonToBean((String)s, GetAlgoTypeRes.class);
    }

    public static ResultRes setAlgoType(String mac, Integer algoType, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/setAlgoType", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        HashMap<String, Integer> req = new HashMap<String, Integer>(1);
        req.put("algoType", algoType);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(20000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (ResultRes)JsonUtils.jsonToBean((String)s, ResultRes.class);
    }

    public static GetAlgoListRes getAlgoList(String mac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/getAlgoList", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (GetAlgoListRes)JsonUtils.jsonToBean((String)s, GetAlgoListRes.class);
    }

    public static ResultRes setAlgoList(String mac, SetAlgoListReq req, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/setAlgoList", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(20000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (ResultRes)JsonUtils.jsonToBean((String)s, ResultRes.class);
    }

    public static GetAlgoRuleRes getAlgoRule(String mac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/getAlgoRule", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (GetAlgoRuleRes)JsonUtils.jsonToBean((String)s, GetAlgoRuleRes.class);
    }

    public static ResultRes setAlgoRule(String mac, SetAlgoRuleReq req, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/setAlgoRule", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(20000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (ResultRes)JsonUtils.jsonToBean((String)s, ResultRes.class);
    }

    public static DmsDeviceBaseRes<AlgoSupportRes> getAlgoCapabilites(String mac) {
        String s = SocketUtil.sendToDms2("getAlgoCapabilites", mac, null, 10000);
        DmsDeviceBaseRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (DmsDeviceBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<DmsDeviceBaseRes<AlgoSupportRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static DmsDeviceBaseRes<AlgoSupportRes> getAlgoCapabilitesDms1(String mac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = "pu/" + mac + "/getAlgoCapabilites";
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(20000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        DmsDeviceBaseRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (DmsDeviceBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<DmsDeviceBaseRes<AlgoSupportRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static DmsDeviceBaseRes<AlgoAlgoActiv> getAlgoAlgoActiv(String mac) {
        String s = SocketUtil.sendToDms2("getAlgoActivate", mac, null, 10000);
        DmsDeviceBaseRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (DmsDeviceBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<DmsDeviceBaseRes<AlgoAlgoActiv>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static DmsDeviceBaseRes<AlgoAlgoActiv> getAlgoAlgoActivDms1(String mac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = "pu/" + mac + "/getAlgoActivate";
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(20000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        try {
            return (DmsDeviceBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<DmsDeviceBaseRes<AlgoAlgoActiv>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
    }

    public static DmsDeviceBaseRes setAlgoAlgoActiv(String mac, AlgoAlgoActiv config) {
        String s = SocketUtil.sendToDms2("setAlgoActivate", mac, JsonUtils.beanToJsonString((Object)config), 30000);
        DmsDeviceBaseRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (DmsDeviceBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<DmsDeviceBaseRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static DmsDeviceBaseRes setAlgoAlgoActivDms1(String mac, AlgoAlgoActiv config, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = "pu/" + mac + "/setAlgoActivate";
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)config));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(20000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        DmsDeviceBaseRes result = new DmsDeviceBaseRes();
        Map map = (Map)JsonUtils.jsonToBean((String)s, Map.class);
        Integer result1 = map.getOrDefault("result", 400000);
        result.setErrno(((Object)result1).toString());
        DmsDeviceBaseRes res = new DmsDeviceBaseRes();
        res.setErrno("comm_success");
        res.setMsg("comm_success");
        res.setData(result);
        return res;
    }

    public static DmsDeviceBaseRes<AlgoConfigReq> getAlgoAlgoConfig(String mac) {
        String s = SocketUtil.sendToDms2("getAlgoConfig", mac, null, 10000);
        DmsDeviceBaseRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (DmsDeviceBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<DmsDeviceBaseRes<AlgoConfigReq>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static DmsDeviceBaseRes setAlgoAlgoConfig(String mac, AlgoConfigReq req) {
        String s = SocketUtil.sendToDms2("setAlgoConfig", mac, JsonUtils.beanToJsonString((Object)req), 10000);
        DmsDeviceBaseRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (DmsDeviceBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<DmsDeviceBaseRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static DmsDeviceBaseRes setAlgoAlgoConfigDms1(String mac, AlgoConfigReq req, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = "pu/" + mac + "/setAlgoConfig";
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(20000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        DmsDeviceBaseRes algoSupportResDmsDeviceBaseRes = new DmsDeviceBaseRes();
        try {
            Map map = (Map)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Map<String, String>>(){});
            algoSupportResDmsDeviceBaseRes.setErrno((String)map.get("result"));
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static DmsDeviceBaseRes delAlgoConfig(String mac, List<ChnIdAndAlgiNameReq> reqList) {
        HashMap<String, List<ChnIdAndAlgiNameReq>> req = new HashMap<String, List<ChnIdAndAlgiNameReq>>(1);
        req.put("algoCnfDelete", reqList);
        String s = SocketUtil.sendToDms2("delAlgoConfig", mac, JsonUtils.beanToJsonString(req), 10000);
        DmsDeviceBaseRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (DmsDeviceBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<DmsDeviceBaseRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static DmsDeviceBaseRes<AlgoConfigReq> getAlgoAlgoConfigDms1(String mac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = "pu/" + mac + "/getAlgoConfig";
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(20000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        try {
            return (DmsDeviceBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<DmsDeviceBaseRes<AlgoConfigReq>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
    }

    public static DmsDeviceBaseRes delAlgoConfigDms1(String mac, List<ChnIdAndAlgiNameReq> delAlgoList, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = "pu/" + mac + "/delAlgoConfig";
        HashMap<String, List<ChnIdAndAlgiNameReq>> req = new HashMap<String, List<ChnIdAndAlgiNameReq>>(1);
        req.put("algoCnfDelete", delAlgoList);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(20000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        DmsDeviceBaseRes algoSupportResDmsDeviceBaseRes = new DmsDeviceBaseRes();
        try {
            Map map = (Map)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Map<String, String>>(){});
            algoSupportResDmsDeviceBaseRes.setErrno((String)map.get("result"));
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static Dms2New1Res<SetMultiReidCfgRes> getMultiReidCfg(String mac) {
        String s = SocketUtil.sendToDms2("getMultiReidCfg", mac, null, 5000);
        Dms2New1Res algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (Dms2New1Res)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<SetMultiReidCfgRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static Dms2New1Res setMultiReidCfg(String mac, SetMultiReidCfgRes config) {
        String s = SocketUtil.sendToDms2("setMultiReidCfg", mac, JsonUtils.beanToJsonString((Object)config), 5000);
        Dms2New1Res algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (Dms2New1Res)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }
}

