/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.response.BaseRes;
import com.ovopark.device.signalling.model.response.Pc6QueryDeviceConfigVo;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.text.MessageFormat;

public class Pc6Util {
    public BaseRes<Pc6QueryDeviceConfigVo> queryDeviceConfig(String mac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/queryDeviceConfig", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        try {
            return (BaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<BaseRes<Pc6QueryDeviceConfigVo>>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
    }

    public BaseRes setDeviceConfig(String mac, Pc6QueryDeviceConfigVo mo, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format("pu/{0}/setDeviceConfig", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)mo));
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        try {
            return (BaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<BaseRes>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
    }
}

