/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.signalling.model.response.IoSwitchRes;
import com.ovopark.device.signalling.model.response.SetChnNameConfigRes;
import com.ovopark.device.signalling.model.response.SubDeviceFactoryRes;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dms2SignallingUtil {
    private static final Logger log = LoggerFactory.getLogger(Dms2SignallingUtil.class);

    public static SetChnNameConfigRes setChnNameConfig(String nvrMac, Integer channelId, String name) {
        HashMap<String, Object> reqParam = new HashMap<String, Object>();
        reqParam.put("chnId", channelId);
        reqParam.put("chnName", name);
        String setChnNameConfig = SocketUtil.sendToDms2("setChnNameConfig", nvrMac, JsonUtils.beanToJsonString(reqParam), 3000);
        SetChnNameConfigRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (SetChnNameConfigRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<SetChnNameConfigRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static IoSwitchRes ioSwitch(String nvrMac, String signal, String capacity) {
        HashMap<String, String> reqParam = new HashMap<String, String>();
        reqParam.put("signal", signal);
        reqParam.put("capacity", capacity);
        String setChnNameConfig = SocketUtil.sendToDms2("switch", nvrMac, JsonUtils.beanToJsonString(reqParam), 3000);
        IoSwitchRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (IoSwitchRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<IoSwitchRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static SubDeviceFactoryRes subDeviceFactory(String nvrMac, Integer channelId, String ipcMac) {
        HashMap<String, Object> reqParam = new HashMap<String, Object>();
        reqParam.put("channelId", channelId);
        reqParam.put("ipcmac", ipcMac);
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        HashMap<String, ArrayList<HashMap<String, Object>>> p = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        list.add(reqParam);
        p.put("macInfo", list);
        String setChnNameConfig = SocketUtil.sendToDms2("subDeviceFactory", nvrMac, JsonUtils.beanToJsonString(p), 3000);
        SubDeviceFactoryRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (SubDeviceFactoryRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<SubDeviceFactoryRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }
}

