/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.signalling.contact.ConfigMap;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.request.DelShelfDetectTaskReq;
import com.ovopark.device.signalling.model.request.IpcUpgradeReq;
import com.ovopark.device.signalling.model.request.SetShelfDetectTaskReq;
import com.ovopark.device.signalling.model.request.SetShelfStandardInfoReq;
import com.ovopark.device.signalling.model.response.Dms2NewRes;
import com.ovopark.device.signalling.model.response.GetMoreSettingRes;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dms2NvrUtil {
    private static final Logger log = LoggerFactory.getLogger(Dms2NvrUtil.class);

    public static GetMoreSettingRes getOutputType(String nvrMac) {
        String setChnNameConfig = SocketUtil.sendToDms2("getOutputType", nvrMac, null, 3000);
        GetMoreSettingRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (GetMoreSettingRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<GetMoreSettingRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static Dms2NewRes setOutputType(String nvrMac, Integer playType) {
        HashMap<String, Integer> reqParam = new HashMap<String, Integer>();
        reqParam.put("playType", playType);
        String setChnNameConfig = SocketUtil.sendToDms2("setOutputType", nvrMac, JsonUtils.beanToJsonString(reqParam), 3000);
        Dms2NewRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (Dms2NewRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<Dms2NewRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static Dms2NewRes getShelfDetectTask(String mac) {
        String setChnNameConfig = SocketUtil.sendToDms2("getShelfDetectTask", mac, null, 3000);
        Dms2NewRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (Dms2NewRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<Dms2NewRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static Dms2NewRes setShelfDetectTask(String mac, SetShelfDetectTaskReq req) {
        HashMap map = new HashMap();
        ArrayList<SetShelfDetectTaskReq> list = new ArrayList<SetShelfDetectTaskReq>();
        list.add(req);
        map.put("taskInfo", list);
        String setChnNameConfig = SocketUtil.sendToDms2("setShelfDetectTask", mac, JsonUtils.beanToJsonString(map), 3000);
        Dms2NewRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (Dms2NewRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<Dms2NewRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static Dms2NewRes delShelfDetectTask(String mac, List<Integer> taskIdList) {
        DelShelfDetectTaskReq req = new DelShelfDetectTaskReq();
        ArrayList<DelShelfDetectTaskReq.TaskInfoDTO> list = new ArrayList<DelShelfDetectTaskReq.TaskInfoDTO>();
        for (Integer taskId : taskIdList) {
            DelShelfDetectTaskReq.TaskInfoDTO dto = new DelShelfDetectTaskReq.TaskInfoDTO();
            dto.setTaskId(taskId);
            list.add(dto);
        }
        req.setTaskInfo(list);
        String setChnNameConfig = SocketUtil.sendToDms2("delShelfDetectTask", mac, JsonUtils.beanToJsonString((Object)req), 3000);
        Dms2NewRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (Dms2NewRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<Dms2NewRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static Dms2NewRes setShelfStandardInfo(String mac, SetShelfStandardInfoReq req) {
        String setChnNameConfig = SocketUtil.sendToDms2("setShelfStandardInfo", mac, JsonUtils.beanToJsonString((Object)req), 3000);
        Dms2NewRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (Dms2NewRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<Dms2NewRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static Dms2NewRes delShelfStandardInfo(String mac, Integer channelId) {
        HashMap<String, Integer> req = new HashMap<String, Integer>();
        req.put("channelId", channelId);
        String setChnNameConfig = SocketUtil.sendToDms2("delShelfStandardInfo", mac, JsonUtils.beanToJsonString(req), 3000);
        Dms2NewRes algoSupportResDmsDeviceBaseRes = null;
        try {
            algoSupportResDmsDeviceBaseRes = (Dms2NewRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<Dms2NewRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            return null;
        }
        return algoSupportResDmsDeviceBaseRes;
    }

    public static Dms2NewRes upgradeIPCFirmware(String nvrMac, Integer channelId, String url) {
        IpcUpgradeReq req = new IpcUpgradeReq();
        req.setChannelID(channelId);
        req.setUrl(url);
        String reqName = MessageFormat.format("pu/{0}/upgradeIPCFirmware", nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        socketBaseReq.setAuthentication(SocketUtil.authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        socketBaseReq.setHost(ConfigMap.map.get("DMS_2_SERVER_IP"));
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        Dms2NewRes res = new Dms2NewRes();
        try {
            res = (Dms2NewRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2NewRes>(){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return res;
    }
}

