/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class HttpUtil {
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final OkHttpClient client;
    private static final Dispatcher dispatcher;

    private static OkHttpClient getClientWithTimeouts(Integer connectTimeout, Integer readTimeout) {
        if (connectTimeout == null && readTimeout == null) {
            return client;
        }
        OkHttpClient.Builder builder = client.newBuilder();
        if (connectTimeout != null) {
            builder.connectTimeout((long)connectTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        if (readTimeout != null) {
            builder.readTimeout((long)readTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        return builder.build();
    }

    public static String get(String url, Integer connectTimeout, Integer readTimeout) throws Exception {
        OkHttpClient clientNew = client.newBuilder().connectTimeout(connectTimeout == null ? 3000L : (long)connectTimeout.intValue(), TimeUnit.MILLISECONDS).readTimeout(readTimeout == null ? 30000L : (long)readTimeout.intValue(), TimeUnit.MILLISECONDS).build();
        Request request = new Request.Builder().url(url).build();
        try (Response response = clientNew.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String string = response.body().string();
            return string;
        }
    }

    public static String postJson(String url, String json, Integer connectTimeout, Integer readTimeout) throws Exception {
        OkHttpClient clientNew = client.newBuilder().connectTimeout(connectTimeout == null ? 3000L : (long)connectTimeout.intValue(), TimeUnit.MILLISECONDS).readTimeout(readTimeout == null ? 30000L : (long)readTimeout.intValue(), TimeUnit.MILLISECONDS).build();
        Request request = null;
        if (StringUtils.isEmpty((CharSequence)json)) {
            json = "{}";
        }
        RequestBody body = RequestBody.create((String)json, (MediaType)JSON);
        request = new Request.Builder().url(url).post(body).build();
        try (Response response = clientNew.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String string = response.body().string();
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String postJsonNew(String url, String json, Integer connectTimeout, Integer readTimeout) throws HttpException {
        OkHttpClient client = HttpUtil.getClientWithTimeouts(connectTimeout, readTimeout);
        if (json == null) {
            json = "{}";
        }
        RequestBody body = RequestBody.create((String)json, (MediaType)JSON);
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new HttpException("HTTP request failed: " + response, response.code());
            }
            String string = response.body().string();
            return string;
        }
        catch (IOException e) {
            throw new HttpException("Network error occurred", e);
        }
    }

    static {
        dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(1000);
        dispatcher.setMaxRequestsPerHost(200);
        ConnectionPool connectionPool = new ConnectionPool(500, 5L, TimeUnit.MINUTES);
        client = new OkHttpClient.Builder().connectTimeout(2L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).dispatcher(dispatcher).connectionPool(connectionPool).retryOnConnectionFailure(true).build();
    }

    public static class HttpException
    extends Exception {
        private final int statusCode;

        public HttpException(String message) {
            super(message);
            this.statusCode = -1;
        }

        public HttpException(String message, Throwable cause) {
            super(message, cause);
            this.statusCode = -1;
        }

        public HttpException(String message, int statusCode) {
            super(message);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

