/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.socket;

import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.signalling.contact.ConfigMap;
import com.ovopark.device.signalling.contact.RequestNameContact;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.response.Dms2Res;
import com.ovopark.device.signalling.model.response.SocketProxyRes;
import com.ovopark.device.signalling.util.HttpUtil;
import com.ovopark.device.signalling.util.MsgUtil;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketUtil {
    private static final Logger log = LoggerFactory.getLogger(SocketUtil.class);
    public static final String DEFAULT_ENCODE = "UTF8";
    public static final int contactTimeOut = 5000;
    public static final int requestTimeOut = 30000;
    public static final int defaultTimeOut = 30000;
    public static String authentication = "RGV2aWNlUmVnQWRtaW46RGV2aWNlUmVnQWRtaW4yMDEz";

    public static Map<String, Object> sendRequestToDms(SocketBaseReq req) {
        String s = SocketUtil.sendRequestToRegGetStr(req);
        return MsgUtil.parseToMap(s);
    }

    public static String sendRequestToDmsGetStr(SocketBaseReq req) {
        return SocketUtil.sendRequestToRegGetStr(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendRequestToRegGetStr(SocketBaseReq req) {
        Integer respTimeout;
        String sessionId;
        Boolean need2n;
        String requestName = req.getRequestName();
        String msgContent = req.getMsgContent();
        String s = ConfigMap.map.get("DMS_2_SERVER_IP");
        String host = req.getHost();
        Integer port = req.getPort();
        if (StringUtils.equals((CharSequence)s, (CharSequence)host)) {
            return SocketUtil.dms2(requestName, msgContent);
        }
        String SOCKET_PROXY_URL = ConfigMap.map.get("SOCKET_PROXY_URL");
        if (StringUtils.isNotEmpty((CharSequence)SOCKET_PROXY_URL)) {
            String charsetName;
            String sessionId2;
            Boolean need2n2 = req.getNeed2n();
            if (need2n2 == null) {
                need2n2 = Boolean.TRUE;
            }
            if (StringUtils.isEmpty((CharSequence)(sessionId2 = req.getSessionId()))) {
                sessionId2 = System.currentTimeMillis() + (long)new Random().nextInt() + "";
            }
            if (StringUtils.isEmpty((CharSequence)(charsetName = req.getCharsetName()))) {
                charsetName = DEFAULT_ENCODE;
            }
            req.setNeed2n(need2n2);
            req.setSessionId(sessionId2);
            req.setCharsetName(charsetName);
            return SocketUtil.sendToDms2(SOCKET_PROXY_URL, req);
        }
        String charsetName = req.getCharsetName();
        if (StringUtils.isEmpty((CharSequence)charsetName)) {
            charsetName = DEFAULT_ENCODE;
        }
        if ((need2n = req.getNeed2n()) == null) {
            need2n = Boolean.TRUE;
        }
        if (StringUtils.isEmpty((CharSequence)(sessionId = req.getSessionId()))) {
            sessionId = System.currentTimeMillis() + (long)new Random().nextInt() + "";
        }
        FilterOutputStream os = null;
        Object in = null;
        String reMsg = null;
        String result = null;
        Socket socket = null;
        Integer connectTimeout = req.getConnectTimeout();
        if (connectTimeout == null) {
            connectTimeout = 5000;
        }
        if ((respTimeout = req.getRespTimeout()) == null) {
            respTimeout = 30000;
        }
        try {
            socket = new Socket();
            socket.setReuseAddress(true);
            socket.connect(new InetSocketAddress(req.getHost(), (int)req.getPort()), connectTimeout);
            socket.setSoTimeout(respTimeout);
            os = new DataOutputStream(socket.getOutputStream());
            if (msgContent == null) {
                msgContent = "";
            }
            int length = msgContent.getBytes(charsetName).length;
            String content = null;
            content = need2n == Boolean.TRUE ? MsgUtil.createMsgContent(requestName, host, port, length, authentication, msgContent, sessionId) : MsgUtil.createSingleMsgContent(requestName, host, port, length, authentication, msgContent, sessionId);
            log.info("send cmd to " + host + ",requestName:" + requestName + ",msg:" + content);
            os.write(content.getBytes(charsetName));
            ((DataOutputStream)os).flush();
            reMsg = SocketUtil.readInputStream(socket.getInputStream(), charsetName);
            log.info("get result from " + host + ",requestName:" + requestName + ",result:" + reMsg);
            result = reMsg = MsgUtil.parseResult(reMsg);
            socket.close();
        }
        catch (IOException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)e));
            log.info("send cmd to " + host + ",requestName:" + requestName);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            try {
                assert (socket != null);
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public static String readInputStream(InputStream ins, String encode) {
        return SocketUtil.readInputStreamNew(ins, encode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInputStreamNew(InputStream ins, String encode) {
        long l = System.currentTimeMillis();
        BufferedInputStream bis = new BufferedInputStream(ins);
        try {
            int buffSize = 1024000;
            byte[] bufferTotal = new byte[buffSize];
            int readTotal = 0;
            int headerLength = 0;
            int bodyLength = 0;
            int total = 0;
            while (System.currentTimeMillis() - l <= 60000L) {
                String[] heads;
                byte[] buffer = new byte[1024];
                int read = bis.read(buffer);
                if (read > 0) {
                    readTotal = total + read;
                }
                for (int i = 0; i < read; ++i) {
                    bufferTotal[total] = buffer[i];
                    ++total;
                }
                String str = new String(bufferTotal, encode);
                int i = str.indexOf("\r\n\r\n", 0);
                if (i <= 0) continue;
                String s = str.substring(0, i);
                headerLength = s.length();
                for (String head : heads = s.split("\r\n")) {
                    String contentLengthStr = "Content-Length:";
                    if (!head.startsWith(contentLengthStr)) continue;
                    bodyLength = Integer.parseInt(head.split(":")[1].trim());
                    String body = str.substring(i + 4);
                    if (headerLength + 4 + bodyLength + 2 != readTotal) continue;
                    String string = body.trim().replaceAll("\r", "").replaceAll("\n", "").replaceAll("\"\t", "\"").replaceAll("\t\"", "\"").trim();
                    return string;
                }
            }
            String string = "";
            return string;
        }
        catch (IOException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)e));
            String string = "";
            return string;
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException e) {
                log.error(LogUtil.getStackTraceInfo((Exception)e));
            }
        }
    }

    public static String preseStr(String str) {
        log.info(str);
        return str.trim().replaceAll("\r", "").replaceAll("\n", "").replaceAll("\"\t", "\"").replaceAll("\t\"", "\"").trim();
    }

    public static String dms2(String requestName, String msgContent) {
        String nvrMac;
        block16: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            nvrMac = "";
                                            if (!StringUtils.equals((CharSequence)RequestNameContact.delDev, (CharSequence)requestName)) break block17;
                                            String[] split = msgContent.split("&");
                                            nvrMac = split[0].replace("mac=", "");
                                            ArrayList ipcList = new ArrayList();
                                            String[] split1 = split[1].split("\\|");
                                            for (int i = 0; i < split1.length; i += 2) {
                                                HashMap<String, Object> stringObjectHashMap = new HashMap<String, Object>();
                                                stringObjectHashMap.put("ipcmac", split1[i].replace("ipcmac=", ""));
                                                stringObjectHashMap.put("channelId", Integer.parseInt(split1[i + 1].replace("channelId=", "")));
                                                ipcList.add(stringObjectHashMap);
                                            }
                                            HashMap re = new HashMap();
                                            re.put("macInfo", ipcList);
                                            msgContent = JsonUtils.beanToJsonString(re);
                                            break block16;
                                        }
                                        if (!StringUtils.equals((CharSequence)"getDeviceStatus", (CharSequence)requestName)) break block18;
                                        nvrMac = msgContent.replace("macaddr=", "");
                                        break block16;
                                    }
                                    if (!requestName.startsWith("upgradeDevice")) break block19;
                                    String[] split = msgContent.split("&");
                                    for (int i = 0; i < split.length; ++i) {
                                        String temp = split[i];
                                        if (!temp.startsWith("macaddr=")) continue;
                                        nvrMac = temp.replace("macaddr=", "");
                                    }
                                    break block16;
                                }
                                if (!StringUtils.equals((CharSequence)"getDeviceVersion", (CharSequence)requestName)) break block20;
                                nvrMac = msgContent.replace("macaddr=", "");
                                break block16;
                            }
                            if (!requestName.startsWith(RequestNameContact.NVR_GetRecDailyList)) break block21;
                            nvrMac = requestName.split("&")[1];
                            requestName = requestName.split("&")[0];
                            break block16;
                        }
                        if (!requestName.startsWith(RequestNameContact.NVR_GetRecMonthList)) break block22;
                        nvrMac = requestName.split("&")[1];
                        requestName = requestName.split("&")[0];
                        break block16;
                    }
                    if (!requestName.startsWith("pu")) break block23;
                    nvrMac = requestName.split("/")[1];
                    if (!requestName.contains("setOnvifTimeSyncReq")) break block16;
                    HashMap<String, Integer> stringObjectHashMap = new HashMap<String, Integer>();
                    stringObjectHashMap.put("setFlag", Integer.valueOf(msgContent.replace("setFlag=", "")));
                    msgContent = JsonUtils.beanToJsonString(stringObjectHashMap);
                    break block16;
                }
                if (!requestName.startsWith("devmanage")) break block24;
                if (msgContent.contains("&")) {
                    String[] split;
                    for (String s1 : split = msgContent.split("&")) {
                        if (!s1.contains("mac=")) continue;
                        nvrMac = s1.replace("mac=", "");
                        break;
                    }
                } else {
                    String[] split;
                    for (String s1 : split = msgContent.split("\\|")) {
                        if (!s1.contains("mac=")) continue;
                        nvrMac = s1.replace("mac=", "");
                        break;
                    }
                }
                if (!requestName.contains("searchDev")) break block16;
                msgContent = "";
                break block16;
            }
            if (requestName.startsWith("queryDeviceConfig") || requestName.startsWith("setDeviceConfig")) {
                String[] split = requestName.split("?");
                nvrMac = split[1].replace("devsn=", "");
            } else if (requestName.startsWith("ctrlDevice")) {
                HashMap<String, Integer> reqMap = new HashMap<String, Integer>();
                String[] split = msgContent.split("&");
                Integer reboot = 0;
                Integer restore = 0;
                for (String s1 : split) {
                    if (s1.contains("macaddr=")) {
                        nvrMac = s1.replace("macaddr=", "");
                    }
                    if (s1.contains("reboot=")) {
                        reboot = Integer.valueOf(s1.replace("reboot=", ""));
                    }
                    if (!s1.contains("restore=")) continue;
                    restore = Integer.valueOf(s1.replace("restore=", ""));
                }
                reqMap.put("reboot", reboot);
                reqMap.put("restore", restore);
                msgContent = JsonUtils.beanToJsonString(reqMap);
            } else if (requestName.startsWith("snapshot") || requestName.startsWith("patrol") || requestName.startsWith("sysmanage") || requestName.startsWith("modifyDeviceInfo")) {
                String[] split;
                for (String s1 : split = msgContent.split("&")) {
                    if (!s1.contains("macaddr=")) continue;
                    nvrMac = s1.replace("macaddr=", "");
                    break;
                }
            }
        }
        return SocketUtil.sendToDms2(requestName, nvrMac, msgContent, null);
    }

    public static String sendToDms2(String requestName, String nvrMac, String jsonString, Integer requestTimeOut) {
        String url = MessageFormat.format(ConfigMap.map.get("DMS_PROXY"), nvrMac, requestName);
        log.info("dms2 url:{},body:{}", (Object)url, (Object)jsonString);
        String body = null;
        try {
            body = HttpUtil.postJson(url, jsonString, 2000, requestTimeOut);
            log.info("dms2\u8fd4\u56de:{}", (Object)body);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            LogUtil.getStackTraceInfo((Exception)e);
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        if (StringUtils.isEmpty((CharSequence)body)) {
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        Dms2Res dms2Res = (Dms2Res)JsonUtils.jsonToBean((String)body, Dms2Res.class);
        if (dms2Res == null) {
            log.error("dms2\u8bf7\u6c42\u5f02\u5e38,json\u8f6c\u6362\u5f02\u5e38,\u8fd4\u56de\u503c:{}", (Object)body);
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        String dmsErrno = dms2Res.getErrno();
        if (!StringUtils.equals((CharSequence)"comm_success", (CharSequence)dmsErrno)) {
            if (StringUtils.equals((CharSequence)"resp_device_offline", (CharSequence)dmsErrno)) {
                throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
            }
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        return SocketUtil.preseStr(dms2Res.getData());
    }

    public static String sendToDms2(String url, SocketBaseReq req) {
        log.info("socket proxy url:{},req body:{}", (Object)url, (Object)JsonUtils.beanToJsonStringForLog((Object)req));
        String body = null;
        Integer respTimeout = req.getRespTimeout();
        if (respTimeout == null) {
            respTimeout = 20000;
        }
        respTimeout = respTimeout + 1000;
        try {
            body = HttpUtil.postJsonNew(url, JsonUtils.beanToJsonString((Object)req), 2000, respTimeout);
            log.info("socket proxy res:{}", (Object)body);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            LogUtil.getStackTraceInfo((Exception)e);
            throw new CommonException(ExceptionEnum.CLOUD_EXCEPTION, "SOCKET_PROXY_ERR");
        }
        if (StringUtils.isEmpty((CharSequence)body)) {
            throw new CommonException(ExceptionEnum.CLOUD_EXCEPTION, "SOCKET_PROXY_ERR");
        }
        SocketProxyRes dms2Res = (SocketProxyRes)JsonUtils.jsonToBean((String)body, SocketProxyRes.class);
        if (dms2Res.getSuccess().booleanValue() && StringUtils.isNotEmpty((CharSequence)dms2Res.getResult())) {
            return MsgUtil.parseResult(dms2Res.getResult());
        }
        throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
    }

    public static void main(String[] args) {
        System.out.println(SocketUtil.preseStr("{\"data\":{\"errno\":200000,\"msg\":\"OK\"},\"errno\":\"comm_success\",\"msg\":\"comm_success\",\"result\":200000}"));
        String ma = "mac=sdfdf|----";
        String[] split = ma.split("\\|");
        System.out.println(split[0]);
    }
}

