/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.signalling.contact.RequestNameContact;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.request.GetVideoEncParamsReq;
import com.ovopark.device.signalling.model.request.SetVideoEncParamsReq;
import com.ovopark.device.signalling.model.response.GetVideoEncParamsRes;
import com.ovopark.device.signalling.model.response.SetVideoEncParamsRes;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoUtil {
    private static Logger log = LoggerFactory.getLogger(VideoUtil.class);
    public static final int PLAY_TYPE_RTSP = 1;
    public static final int PLAY_TYPE_RTMP = 2;

    public static GetVideoEncParamsRes getVideoEncParams(String nvrMac, GetVideoEncParamsReq req, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getVideoEncParams, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        GetVideoEncParamsRes getVideoEncParamsRes = new GetVideoEncParamsRes();
        if (StringUtils.isEmpty((CharSequence)s)) {
            getVideoEncParamsRes.setResult(404003);
        } else if (s.contains("result=404001")) {
            getVideoEncParamsRes.setResult(404001);
        } else {
            getVideoEncParamsRes = (GetVideoEncParamsRes)JsonUtils.jsonToBean((String)s, GetVideoEncParamsRes.class);
        }
        return getVideoEncParamsRes;
    }

    public static SetVideoEncParamsRes setVideoEncParams(String nvrMac, SetVideoEncParamsReq req, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.setVideoEncParams, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        SetVideoEncParamsRes getVideoEncParamsRes = new SetVideoEncParamsRes();
        if (StringUtils.isEmpty((CharSequence)s)) {
            getVideoEncParamsRes.setResult(404003);
        } else if (s.contains("result=404001")) {
            getVideoEncParamsRes.setResult(404001);
        } else {
            getVideoEncParamsRes = (SetVideoEncParamsRes)JsonUtils.jsonToBean((String)s, SetVideoEncParamsRes.class);
        }
        return getVideoEncParamsRes;
    }

    public static void rtspVideoPlay(String ip, Integer port, String mac, Integer streamID, Integer channelID, String transport, Boolean permanent, Integer timeout) {
    }
}

