/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.signalling.contact.ConfigMap;
import com.ovopark.device.signalling.contact.RequestNameContact;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.request.GetKeepScheduleReq;
import com.ovopark.device.signalling.model.request.ModifyDeviceInfoReq;
import com.ovopark.device.signalling.model.request.PtzTourCtrlReq;
import com.ovopark.device.signalling.model.request.QueryLogsReq;
import com.ovopark.device.signalling.model.request.SetDevTimeCfgReq;
import com.ovopark.device.signalling.model.request.SetKeepScheduleReq;
import com.ovopark.device.signalling.model.response.BaseRes;
import com.ovopark.device.signalling.model.response.BooleanAndResult;
import com.ovopark.device.signalling.model.response.GetAlarmSwitchStatusRes;
import com.ovopark.device.signalling.model.response.GetDevTimeCfgRes;
import com.ovopark.device.signalling.model.response.GetDiskAlarmCfgRes;
import com.ovopark.device.signalling.model.response.GetKeepScheduleRes;
import com.ovopark.device.signalling.model.response.GetNetLossRebootCfgRes;
import com.ovopark.device.signalling.model.response.GetTimerRebootRes;
import com.ovopark.device.signalling.model.response.NvrChildInfoRes;
import com.ovopark.device.signalling.model.response.PtzTourCtrlRes;
import com.ovopark.device.signalling.model.response.QueryLogRes;
import com.ovopark.device.signalling.model.response.RestartConfigReqRes;
import com.ovopark.device.signalling.model.response.ResultRes;
import com.ovopark.device.signalling.model.response.SetRestartConfigReq;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvrUtil {
    private static final Logger log = LoggerFactory.getLogger(NvrUtil.class);

    public static BooleanAndResult modifyDeviceInfo(String nvrMac, ModifyDeviceInfoReq req, String upgradeServer, Integer upgradePort, String authentication) {
        String[] params;
        String s = "";
        if (StringUtils.equals((CharSequence)ConfigMap.map.get("DMS_2_SERVER_IP"), (CharSequence)upgradeServer)) {
            HashMap<String, String> msgMap = new HashMap<String, String>();
            msgMap.put("macaddr", req.getMacaddr());
            msgMap.put("device_name", req.getDeviceName());
            msgMap.put("acc_usr", req.getAccUser());
            msgMap.put("acc_pw", req.getAccPw());
            msgMap.put("acc_pw_new", req.getAccPwNew());
            s = SocketUtil.sendToDms2(RequestNameContact.modifyDeviceInfo, nvrMac, JsonUtils.beanToJsonString(msgMap), null);
        } else {
            String reqName = RequestNameContact.modifyDeviceInfo;
            SocketBaseReq socketBaseReq = new SocketBaseReq();
            socketBaseReq.setRequestName(reqName);
            String req1 = "macaddr=" + req.getMacaddr() + "&device_name=" + req.getDeviceName() + "&acc_usr=" + req.getAccUser() + "&acc_pw=" + req.getAccPw() + "&acc_pw_new=" + req.getAccPwNew();
            socketBaseReq.setMsgContent(req1);
            socketBaseReq.setHost(upgradeServer);
            socketBaseReq.setPort(upgradePort);
            socketBaseReq.setAuthentication(authentication);
            socketBaseReq.setRespTimeout(10000);
            socketBaseReq.setConnectTimeout(2000);
            socketBaseReq.setNeed2n(false);
            s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        }
        BooleanAndResult booleanAndResult = new BooleanAndResult();
        if (s.isEmpty()) {
            booleanAndResult.setResult(200000);
            booleanAndResult.setSuccess(true);
            return booleanAndResult;
        }
        for (String param : params = s.split("&")) {
            String[] modAccPwString;
            Integer modAccPw;
            if (!param.contains("mod_acc_pw") || (modAccPw = Integer.valueOf(Integer.parseInt((modAccPwString = param.split("="))[1]))) != 1) continue;
            booleanAndResult.setResult(23333001);
            booleanAndResult.setSuccess(false);
            return booleanAndResult;
        }
        booleanAndResult.setResult(200000);
        booleanAndResult.setSuccess(true);
        return booleanAndResult;
    }

    public static GetKeepScheduleRes getKeepSchedule(String nvrMac, String ipcMac, Integer channel, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getKeepSchedule, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        GetKeepScheduleReq req = new GetKeepScheduleReq();
        req.setIpcNum(1);
        GetKeepScheduleReq.IpcInfoBean ipcInfoBean = new GetKeepScheduleReq.IpcInfoBean();
        ipcInfoBean.setChannelID(channel);
        ipcInfoBean.setIpcmac(ipcMac);
        ArrayList<GetKeepScheduleReq.IpcInfoBean> list = new ArrayList<GetKeepScheduleReq.IpcInfoBean>();
        list.add(ipcInfoBean);
        req.setIpcInfo(list);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (GetKeepScheduleRes)JsonUtils.jsonToBean((String)s, GetKeepScheduleRes.class);
    }

    public static ResultRes setKeepSchedule(String nvrMac, SetKeepScheduleReq req, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.setKeepSchedule, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(30000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (ResultRes)JsonUtils.jsonToBean((String)s, ResultRes.class);
    }

    public static QueryLogRes queryLogs(Long startTime, Long endTime, String nvrMac, List<Integer> logeTypeList, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.queryLogs, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        QueryLogsReq req = new QueryLogsReq();
        req.setStartTime(startTime);
        req.setEndTime(endTime);
        req.setLogType(logeTypeList);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(30000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        log.info("queryLogs res:{}", (Object)s);
        return (QueryLogRes)JsonUtils.jsonToBean((String)s, QueryLogRes.class);
    }

    public static ResultRes setDevTimeCfg(String nvrMac, SetDevTimeCfgReq req, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.setDevTimeCfg, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(30000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (ResultRes)JsonUtils.jsonToBean((String)s, ResultRes.class);
    }

    public static GetDevTimeCfgRes getDevTimeCfg(String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getDevTimeCfg, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(30000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (GetDevTimeCfgRes)JsonUtils.jsonToBean((String)s, GetDevTimeCfgRes.class);
    }

    public static GetAlarmSwitchStatusRes getAlarmSwitchStatus(String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getAlarmSwitchStatus, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (GetAlarmSwitchStatusRes)JsonUtils.jsonToBean((String)s, GetAlarmSwitchStatusRes.class);
    }

    public static BaseRes setRestartConfig(String nvrMac, String upgradeServer, Integer upgradePort, String authentication, SetRestartConfigReq req) {
        String reqName = MessageFormat.format(RequestNameContact.setRebootSchedule, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(30000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (BaseRes)JsonUtils.jsonToBean((String)s, BaseRes.class);
    }

    public static RestartConfigReqRes getRestartConfig(String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getRebootSchedule, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(30000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (RestartConfigReqRes)JsonUtils.jsonToBean((String)s, RestartConfigReqRes.class);
    }

    public static PtzTourCtrlRes ptzTourCtrl(String nvrMac, PtzTourCtrlReq req, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.ptzTourCtrl, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(30000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString((Object)req));
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (PtzTourCtrlRes)JsonUtils.jsonToBean((String)s, PtzTourCtrlRes.class);
    }

    public static NvrChildInfoRes getUnderNvrIpcInfoReq(String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getUnderNvrIpcInfoReq, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(30000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (NvrChildInfoRes)JsonUtils.jsonToBean((String)s, NvrChildInfoRes.class);
    }

    public static GetTimerRebootRes getTimerReboot(String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getTimerReboot, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(30000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (GetTimerRebootRes)JsonUtils.jsonToBean((String)s, GetTimerRebootRes.class);
    }

    public static BaseRes setTimerReboot(String nvrMac, GetTimerRebootRes.DataBean req, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.setTimerReboot, nvrMac);
        HashMap<String, GetTimerRebootRes.DataBean> paramMap = new HashMap<String, GetTimerRebootRes.DataBean>(1);
        paramMap.put("data", req);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(paramMap));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(30000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (BaseRes)JsonUtils.jsonToBean((String)s, BaseRes.class);
    }

    public static GetDiskAlarmCfgRes getDiskAlarmCfg(String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getDiskAlarmCfg, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(30000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (GetDiskAlarmCfgRes)JsonUtils.jsonToBean((String)s, GetDiskAlarmCfgRes.class);
    }

    public static BaseRes setDiskAlarmCfg(String nvrMac, String upgradeServer, Integer upgradePort, String authentication, String uploadUrl) {
        String reqName = MessageFormat.format(RequestNameContact.setDiskAlarmCfg, nvrMac);
        HashMap<String, String> paramMap = new HashMap<String, String>(1);
        paramMap.put("uploadUrl", uploadUrl);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(paramMap));
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(30000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (BaseRes)JsonUtils.jsonToBean((String)s, BaseRes.class);
    }

    public static BaseRes setSDAlarmCfg(String nvrMac, String upgradeServer, Integer upgradePort, String authentication, String uploadUrl) {
        String reqName = MessageFormat.format(RequestNameContact.setSDAlarmCfg, nvrMac);
        HashMap<String, String> paramMap = new HashMap<String, String>(1);
        paramMap.put("uploadUrl", uploadUrl);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(paramMap));
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(30000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (BaseRes)JsonUtils.jsonToBean((String)s, BaseRes.class);
    }

    public static BaseRes setKdPlatSwitch(String nvrMac, String upgradeServer, Integer upgradePort, String authentication, int enable) {
        String reqName = MessageFormat.format(RequestNameContact.setKdPlatSwitch, nvrMac);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(1);
        paramMap.put("enable", enable);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(paramMap));
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (BaseRes)JsonUtils.jsonToBean((String)s, BaseRes.class);
    }

    public static BaseRes getKdPlatSwitch(String nvrMac, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getKdPlatSwitch, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (BaseRes)JsonUtils.jsonToBean((String)s, BaseRes.class);
    }

    public static GetNetLossRebootCfgRes getNetLossRebootCfg(String nvrMac, String upgradeServer, Integer upgradePort) {
        if (StringUtils.equals((CharSequence)ConfigMap.map.get("DMS_2_SERVER_IP"), (CharSequence)upgradeServer)) {
            String setChnNameConfig = SocketUtil.sendToDms2("getNetLossRebootCfg", nvrMac, null, 3000);
            GetNetLossRebootCfgRes algoSupportResDmsDeviceBaseRes = null;
            try {
                algoSupportResDmsDeviceBaseRes = (GetNetLossRebootCfgRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<GetNetLossRebootCfgRes>(){});
            }
            catch (JsonProcessingException e) {
                log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
                return null;
            }
            return algoSupportResDmsDeviceBaseRes;
        }
        String reqName = MessageFormat.format(RequestNameContact.getNetLossRebootCfg, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(SocketUtil.authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (GetNetLossRebootCfgRes)JsonUtils.jsonToBean((String)s, GetNetLossRebootCfgRes.class);
    }

    public static ResultRes setNetLossRebootCfg(String nvrMac, Integer enable, Integer waitTime, String upgradeServer, Integer upgradePort) {
        HashMap<String, Integer> reqParam = new HashMap<String, Integer>();
        reqParam.put("enable", enable);
        reqParam.put("waitTime", waitTime);
        if (StringUtils.equals((CharSequence)ConfigMap.map.get("DMS_2_SERVER_IP"), (CharSequence)upgradeServer)) {
            String setChnNameConfig = SocketUtil.sendToDms2("setNetLossRebootCfg", nvrMac, JsonUtils.beanToJsonString(reqParam), 3000);
            ResultRes algoSupportResDmsDeviceBaseRes = null;
            try {
                algoSupportResDmsDeviceBaseRes = (ResultRes)JsonUtils.objectMapper.readValue(setChnNameConfig, (TypeReference)new TypeReference<ResultRes>(){});
            }
            catch (JsonProcessingException e) {
                log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
                return null;
            }
            return algoSupportResDmsDeviceBaseRes;
        }
        String reqName = MessageFormat.format(RequestNameContact.setNetLossRebootCfg, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(reqParam));
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(SocketUtil.authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        String s = SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return (ResultRes)JsonUtils.jsonToBean((String)s, ResultRes.class);
    }
}

