/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.signalling.util;

import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.signalling.contact.RequestNameContact;
import com.ovopark.device.signalling.model.SocketBaseReq;
import com.ovopark.device.signalling.model.request.AudioEncParams;
import com.ovopark.device.signalling.socket.SocketUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AudioUtil {
    public static String getAudioEncParams(String nvrMac, List<AudioEncParams> list, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.getAudioEncParams, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        HashMap requestMap = new HashMap();
        ArrayList macInfoList = new ArrayList();
        for (AudioEncParams item : list) {
            HashMap<String, Object> macInfo = new HashMap<String, Object>();
            macInfo.put("ipcmac", item.getIpcMac());
            macInfo.put("channelId", item.getChannelId());
            macInfo.put("isSecondVideo", 0);
            macInfoList.add(macInfo);
        }
        requestMap.put("macInfo", macInfoList);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(requestMap));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        return SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
    }

    public static String setAudioEncParams(String nvrMac, Map<String, Object> params, String upgradeServer, Integer upgradePort, String authentication) {
        String reqName = MessageFormat.format(RequestNameContact.setAudioEncParams, nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        HashMap requestMap = new HashMap();
        ArrayList<Map<String, Object>> macInfoList = new ArrayList<Map<String, Object>>();
        macInfoList.add(params);
        requestMap.put("audioEncParams", macInfoList);
        socketBaseReq.setMsgContent(JsonUtils.beanToJsonString(requestMap));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setAuthentication(authentication);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        return SocketUtil.sendRequestToDmsGetStr(socketBaseReq);
    }
}

