/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdpart.lecheng.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.thirdpart.lecheng.config.LCSysConfig;
import com.ovopark.device.thirdpart.lecheng.feign.LCBaseFeign;
import com.ovopark.device.thirdpart.lecheng.model.LCAccessTokenRes;
import com.ovopark.device.thirdpart.lecheng.model.LCBaseReq;
import com.ovopark.device.thirdpart.lecheng.model.LCBaseRes;
import com.ovopark.device.thirdpart.lecheng.model.LCSysTemReq;
import com.ovopark.device.thirdpart.lecheng.util.LCSignUtils;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LCTokenService {
    private static final Logger log = LoggerFactory.getLogger(LCTokenService.class);
    @Resource
    private LCSysConfig lcSysConfig;
    @Resource
    private LCBaseFeign lcBaseFeign;

    public LCBaseRes<LCAccessTokenRes> getLCAccessToken() {
        LCBaseReq req = new LCBaseReq();
        req.setParams(new HashMap());
        LCSysTemReq system = new LCSysTemReq();
        system.setAppId(this.lcSysConfig.getAppId());
        req.setSystem(system);
        LCSignUtils.sign(req, this.lcSysConfig.getAppSecret());
        log.info("lcBaseFeign.getAccessToken\u8bf7\u6c42\u53c2\u6570\uff1a{}", req);
        String accessToken = this.lcBaseFeign.getAccessToken(req);
        log.info("lcBaseFeign.getAccessToken\u8fd4\u56de\uff1a{}", (Object)accessToken);
        try {
            return (LCBaseRes)JsonUtils.objectMapper.readValue(accessToken, (TypeReference)new TypeReference<LCBaseRes<LCAccessTokenRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }
}

