/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdpart.lecheng.util;

import com.ovopark.device.common.constant.StringConstant;
import com.ovopark.device.thirdpart.lecheng.model.LCBaseReq;
import com.ovopark.device.thirdpart.lecheng.model.LCSysTemReq;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

public class LCSignUtils {
    public static void sign(LCBaseReq req, String appSecret) {
        Long time = Instant.now().getEpochSecond();
        String nonce = UUID.randomUUID().toString();
        String SIGN_TEMPLATE = MessageFormat.format("time:{0},nonce:{1},appSecret:{2}", time.toString(), nonce, appSecret);
        String sign = DigestUtils.md5Hex((String)SIGN_TEMPLATE);
        LCSysTemReq system = req.getSystem();
        system.setSign(sign);
        system.setTime(time);
        system.setNonce(nonce);
        String requestId = MDC.get((String)StringConstant.REQUEST_ID);
        if (StringUtils.isEmpty((CharSequence)requestId)) {
            requestId = UUID.randomUUID().toString();
        }
        req.setId(requestId);
    }
}

