/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdpart.lecheng.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.thirdpart.lecheng.feign.LCBaseFeign;
import com.ovopark.device.thirdpart.lecheng.model.LCBaseReq;
import com.ovopark.device.thirdpart.lecheng.model.LCBaseRes;
import com.ovopark.device.thirdpart.lecheng.model.LCDeviceOnlineRes;
import com.ovopark.device.thirdpart.lecheng.model.LCRes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LCDeviceService {
    private static final Logger log = LoggerFactory.getLogger(LCDeviceService.class);
    @Resource
    private LCBaseFeign lcBaseFeign;

    public Map<Integer, Integer> getDeviceOnline(String deviceId, String token) {
        HashMap<Integer, Integer> resultMap = new HashMap<Integer, Integer>();
        LCBaseReq<Map<String, String>> req = new LCBaseReq<Map<String, String>>();
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        stringStringHashMap.put("deviceId", deviceId);
        stringStringHashMap.put("token", token);
        req.setParams(stringStringHashMap);
        log.info("LC-deviceOnline\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)req.toString());
        String s = this.lcBaseFeign.deviceOnline(req);
        log.info("LC-deviceOnline\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)s);
        LCBaseRes lcDeviceOnlineResLCBaseRes = null;
        try {
            lcDeviceOnlineResLCBaseRes = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<LCDeviceOnlineRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcDeviceOnlineResLCBaseRes.getResult();
        String code = result.getCode();
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)code)) {
            throw new CommonException(ExceptionEnum.LC_ERROR, ExceptionEnum.LC_ERROR.getMessage() + result.getMsg());
        }
        LCDeviceOnlineRes data = (LCDeviceOnlineRes)result.getData();
        String onLine = data.getOnLine();
        resultMap.put(0, Integer.valueOf(onLine));
        List<LCDeviceOnlineRes.Channel> channels = data.getChannels();
        if (channels != null && !channels.isEmpty()) {
            for (LCDeviceOnlineRes.Channel item : channels) {
                resultMap.put(Integer.valueOf(item.getChannelId()), Integer.valueOf(item.getOnLine()));
            }
        }
        return resultMap;
    }

    public String queryLocalRecordBitmap(String deviceId, String token, Integer year, Integer month, Integer channelId) {
        HashMap resultMap = new HashMap();
        LCBaseReq<Map<String, Object>> req = new LCBaseReq<Map<String, Object>>();
        HashMap<String, Object> stringStringHashMap = new HashMap<String, Object>();
        stringStringHashMap.put("deviceId", deviceId);
        stringStringHashMap.put("token", token);
        stringStringHashMap.put("year", year);
        stringStringHashMap.put("month", month);
        stringStringHashMap.put("channelId", channelId + "");
        req.setParams(stringStringHashMap);
        log.info("LC-deviceOnline\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)req.toString());
        String s = this.lcBaseFeign.queryLocalRecordBitmap(req);
        log.info("LC-deviceOnline\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)s);
        LCBaseRes lcDeviceOnlineResLCBaseRes = null;
        try {
            lcDeviceOnlineResLCBaseRes = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<Map<String, String>>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcDeviceOnlineResLCBaseRes.getResult();
        String code = result.getCode();
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)code)) {
            throw new CommonException(ExceptionEnum.LC_ERROR, ExceptionEnum.LC_ERROR.getMessage() + result.getMsg());
        }
        Map data = (Map)result.getData();
        return (String)data.get("bitmap");
    }
}

