/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdpart.lecheng.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.common.constant.StringConstant;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.thirdpart.lecheng.config.LCSysConfig;
import com.ovopark.device.thirdpart.lecheng.feign.LCBaseFeign;
import com.ovopark.device.thirdpart.lecheng.model.LCAccessTokenRes;
import com.ovopark.device.thirdpart.lecheng.model.LCBaseReq;
import com.ovopark.device.thirdpart.lecheng.model.LCBaseRes;
import com.ovopark.device.thirdpart.lecheng.model.LCDeviceOnlineRes;
import com.ovopark.device.thirdpart.lecheng.model.LCKitTokenRes;
import com.ovopark.device.thirdpart.lecheng.model.LCListDeviceDetailsByIdsReq;
import com.ovopark.device.thirdpart.lecheng.model.LCListDeviceDetailsByIdsRes;
import com.ovopark.device.thirdpart.lecheng.model.LCRes;
import com.ovopark.device.thirdpart.lecheng.model.LCSysTemReq;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class LCSDKService {
    private static final Logger log = LoggerFactory.getLogger(LCSDKService.class);
    @Resource
    private LCBaseFeign lcBaseFeign;
    @Resource
    private LCSysConfig lcSysConfig;

    public Map<Integer, Integer> getDeviceOnline(String deviceId, String token) {
        HashMap<Integer, Integer> resultMap = new HashMap<Integer, Integer>();
        LCBaseReq<Map<String, String>> req = new LCBaseReq<Map<String, String>>();
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        stringStringHashMap.put("deviceId", deviceId);
        stringStringHashMap.put("token", token);
        req.setParams(stringStringHashMap);
        log.info("LC-deviceOnline\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)req.toString());
        String s = this.lcBaseFeign.deviceOnline(req);
        log.info("LC-deviceOnline\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)s);
        LCBaseRes lcDeviceOnlineResLCBaseRes = null;
        try {
            lcDeviceOnlineResLCBaseRes = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<LCDeviceOnlineRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcDeviceOnlineResLCBaseRes.getResult();
        String code = result.getCode();
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)code)) {
            throw new CommonException(ExceptionEnum.LC_ERROR, ExceptionEnum.LC_ERROR.getMessage() + result.getMsg());
        }
        LCDeviceOnlineRes data = (LCDeviceOnlineRes)result.getData();
        String onLine = data.getOnLine();
        resultMap.put(0, Integer.valueOf(onLine));
        List<LCDeviceOnlineRes.Channel> channels = data.getChannels();
        if (channels != null && !channels.isEmpty()) {
            for (LCDeviceOnlineRes.Channel item : channels) {
                resultMap.put(Integer.valueOf(item.getChannelId()), Integer.valueOf(item.getOnLine()));
            }
        }
        return resultMap;
    }

    public String queryLocalRecordBitmap(String deviceId, String token, Integer year, Integer month, Integer channelId) {
        HashMap resultMap = new HashMap();
        LCBaseReq<Map<String, Object>> req = new LCBaseReq<Map<String, Object>>();
        HashMap<String, Object> stringStringHashMap = new HashMap<String, Object>();
        stringStringHashMap.put("deviceId", deviceId);
        stringStringHashMap.put("token", token);
        stringStringHashMap.put("year", year);
        stringStringHashMap.put("month", month);
        stringStringHashMap.put("channelId", channelId + "");
        req.setParams(stringStringHashMap);
        log.info("LC-deviceOnline\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)req.toString());
        String s = this.lcBaseFeign.queryLocalRecordBitmap(req);
        log.info("LC-deviceOnline\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)s);
        LCBaseRes lcDeviceOnlineResLCBaseRes = null;
        try {
            lcDeviceOnlineResLCBaseRes = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<Map<String, String>>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcDeviceOnlineResLCBaseRes.getResult();
        String code = result.getCode();
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)code)) {
            throw new CommonException(ExceptionEnum.LC_ERROR, ExceptionEnum.LC_ERROR.getMessage() + result.getMsg());
        }
        Map data = (Map)result.getData();
        return (String)data.get("bitmap");
    }

    public LCKitTokenRes getKitToken(String deviceId, Integer channelId, String token) {
        LCBaseReq<Map<String, String>> req = new LCBaseReq<Map<String, String>>();
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        stringStringHashMap.put("deviceId", deviceId);
        stringStringHashMap.put("type", "0");
        stringStringHashMap.put("token", token);
        stringStringHashMap.put("channelId", channelId + "");
        req.setParams(stringStringHashMap);
        this.sign(req);
        log.info("LC-getKitToken\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)req.toString());
        String s = this.lcBaseFeign.getKitToken(req);
        log.info("LC-getKitToken\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)s);
        LCBaseRes lcListDeviceDetailsByIdsReqLCBaseReq = null;
        try {
            lcListDeviceDetailsByIdsReqLCBaseReq = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<LCKitTokenRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcListDeviceDetailsByIdsReqLCBaseReq.getResult();
        String code = result.getCode();
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)code)) {
            throw new CommonException(ExceptionEnum.LC_ERROR, ExceptionEnum.LC_ERROR.getMessage() + result.getMsg());
        }
        return (LCKitTokenRes)result.getData();
    }

    public void sign(LCBaseReq req) {
        Long time = Instant.now().getEpochSecond();
        String nonce = UUID.randomUUID().toString();
        String SIGN_TEMPLATE = MessageFormat.format("time:{0},nonce:{1},appSecret:{2}", time.toString(), nonce, this.lcSysConfig.getAppSecret());
        String sign = DigestUtils.md5Hex((String)SIGN_TEMPLATE);
        LCSysTemReq system = new LCSysTemReq();
        system.setSign(sign);
        system.setAppId(this.lcSysConfig.getAppId());
        system.setTime(time);
        system.setNonce(nonce);
        req.setSystem(system);
        String requestId = MDC.get((String)StringConstant.REQUEST_ID);
        if (StringUtils.isEmpty((CharSequence)requestId)) {
            requestId = UUID.randomUUID().toString();
        }
        req.setId(requestId);
    }

    public LCBaseRes<LCAccessTokenRes> getLCAccessToken() {
        LCBaseReq req = new LCBaseReq();
        req.setParams(new HashMap());
        this.sign(req);
        log.info("lcBaseFeign.getAccessToken\u8bf7\u6c42\u53c2\u6570\uff1a{}", req);
        String accessToken = this.lcBaseFeign.getAccessToken(req);
        log.info("lcBaseFeign.getAccessToken\u8fd4\u56de\uff1a{}", (Object)accessToken);
        try {
            return (LCBaseRes)JsonUtils.objectMapper.readValue(accessToken, (TypeReference)new TypeReference<LCBaseRes<LCAccessTokenRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }

    public LCListDeviceDetailsByIdsRes listDeviceDetailsByIds(LCListDeviceDetailsByIdsReq req) {
        LCBaseReq<LCListDeviceDetailsByIdsReq> param = new LCBaseReq<LCListDeviceDetailsByIdsReq>();
        param.setParams(req);
        this.sign(param);
        log.info("lcBaseFeign.listDeviceDetailsByIds\uff1a{}", param);
        String s = this.lcBaseFeign.listDeviceDetailsByIds(param);
        log.info("lcBaseFeign.listDeviceDetailsByIds\uff1a{}", (Object)s);
        LCBaseRes lcListDeviceDetailsByIdsReqLCBaseReq = null;
        try {
            lcListDeviceDetailsByIdsReqLCBaseReq = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<LCListDeviceDetailsByIdsRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcListDeviceDetailsByIdsReqLCBaseReq.getResult();
        String code = result.getCode();
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)code)) {
            throw new CommonException(ExceptionEnum.LC_ERROR, ExceptionEnum.LC_ERROR.getMessage() + result.getMsg());
        }
        return (LCListDeviceDetailsByIdsRes)result.getData();
    }
}

