/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdpart.lecheng.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.common.constant.StringConstant;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.thirdpart.lecheng.feign.LCBaseFeign;
import com.ovopark.device.thirdpart.lecheng.model.BindDeviceLiveReq;
import com.ovopark.device.thirdpart.lecheng.model.BindDeviceLiveRes;
import com.ovopark.device.thirdpart.lecheng.model.ControlMovePTZReq;
import com.ovopark.device.thirdpart.lecheng.model.CreateDeviceFlvLiveReq;
import com.ovopark.device.thirdpart.lecheng.model.CreateDeviceFlvLiveRes;
import com.ovopark.device.thirdpart.lecheng.model.DeviceSdcardStatusReq;
import com.ovopark.device.thirdpart.lecheng.model.DeviceSdcardStatusRes;
import com.ovopark.device.thirdpart.lecheng.model.DeviceSnapReq;
import com.ovopark.device.thirdpart.lecheng.model.DeviceSnapRes;
import com.ovopark.device.thirdpart.lecheng.model.DeviceStorageRes;
import com.ovopark.device.thirdpart.lecheng.model.GetLiveStreamInfoReq;
import com.ovopark.device.thirdpart.lecheng.model.GetLiveStreamInfoRes;
import com.ovopark.device.thirdpart.lecheng.model.LCAccessTokenRes;
import com.ovopark.device.thirdpart.lecheng.model.LCBaseReq;
import com.ovopark.device.thirdpart.lecheng.model.LCBaseRes;
import com.ovopark.device.thirdpart.lecheng.model.LCDeviceOnlineRes;
import com.ovopark.device.thirdpart.lecheng.model.LCKitTokenRes;
import com.ovopark.device.thirdpart.lecheng.model.LCListDeviceDetailsByIdsReq;
import com.ovopark.device.thirdpart.lecheng.model.LCListDeviceDetailsByIdsRes;
import com.ovopark.device.thirdpart.lecheng.model.LCRes;
import com.ovopark.device.thirdpart.lecheng.model.LCSysTemReq;
import com.ovopark.device.thirdpart.lecheng.model.ListDeviceDetailsByPageReq;
import com.ovopark.device.thirdpart.lecheng.model.ListDeviceDetailsByPageRes;
import com.ovopark.device.thirdpart.lecheng.model.QueryLocalRecordsReq;
import com.ovopark.device.thirdpart.lecheng.model.QueryLocalRecordsRes;
import com.ovopark.device.thirdpart.lecheng.model.SetDeviceAuthStatusReq;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class LCSDKService {
    private static final Logger log = LoggerFactory.getLogger(LCSDKService.class);
    @Autowired
    private LCBaseFeign lcBaseFeign;
    @Autowired
    private RestTemplate restTemplate;

    public Map<Integer, Integer> getDeviceOnline(String deviceId, String token) {
        HashMap<Integer, Integer> resultMap = new HashMap<Integer, Integer>();
        LCBaseReq<Map<String, String>> req = new LCBaseReq<Map<String, String>>();
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        stringStringHashMap.put("deviceId", deviceId);
        stringStringHashMap.put("token", token);
        req.setParams(stringStringHashMap);
        log.info("LC-deviceOnline\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(req));
        String s = this.lcBaseFeign.deviceOnline(req);
        log.info("LC-deviceOnline\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)s);
        LCBaseRes lcDeviceOnlineResLCBaseRes = null;
        try {
            lcDeviceOnlineResLCBaseRes = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<LCDeviceOnlineRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcDeviceOnlineResLCBaseRes.getResult();
        String code = result.getCode();
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)code)) {
            log.error("lc_ERR:{}", result);
            throw new CommonException(ExceptionEnum.LC_ERROR);
        }
        LCDeviceOnlineRes data = (LCDeviceOnlineRes)result.getData();
        String onLine = data.getOnLine();
        resultMap.put(0, Integer.valueOf(onLine));
        List<LCDeviceOnlineRes.Channel> channels = data.getChannels();
        if (channels != null && !channels.isEmpty()) {
            for (LCDeviceOnlineRes.Channel item : channels) {
                resultMap.put(Integer.valueOf(item.getChannelId()), Integer.valueOf(item.getOnLine()));
            }
        }
        return resultMap;
    }

    public String queryLocalRecordBitmap(String deviceId, String token, Integer year, Integer month, Integer channelId, String appSecret, String appId) {
        LCBaseReq<Map<String, Object>> req = new LCBaseReq<Map<String, Object>>();
        HashMap<String, Object> stringStringHashMap = new HashMap<String, Object>();
        stringStringHashMap.put("deviceId", deviceId);
        stringStringHashMap.put("token", token);
        stringStringHashMap.put("year", year);
        stringStringHashMap.put("month", month);
        stringStringHashMap.put("channelId", channelId + "");
        req.setParams(stringStringHashMap);
        this.sign(req, appSecret, appId);
        log.info("LC-deviceOnline\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(req));
        String s = this.lcBaseFeign.queryLocalRecordBitmap(req);
        log.info("LC-deviceOnline\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)s);
        LCBaseRes lcDeviceOnlineResLCBaseRes = null;
        try {
            lcDeviceOnlineResLCBaseRes = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<Map<String, String>>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcDeviceOnlineResLCBaseRes.getResult();
        String code = result.getCode();
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)code)) {
            log.error("lc_ERR:{}", result);
            throw new CommonException(ExceptionEnum.LC_ERROR);
        }
        Map data = (Map)result.getData();
        return (String)data.get("bitmap");
    }

    public LCKitTokenRes getKitToken(String deviceId, Integer channelId, String token, String appSecret, String appId) {
        LCBaseReq<Map<String, String>> req = new LCBaseReq<Map<String, String>>();
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        stringStringHashMap.put("deviceId", deviceId);
        stringStringHashMap.put("type", "0");
        stringStringHashMap.put("token", token);
        stringStringHashMap.put("channelId", channelId + "");
        req.setParams(stringStringHashMap);
        this.sign(req, appSecret, appId);
        log.info("LC-getKitToken\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(req));
        String s = this.lcBaseFeign.getKitToken(req);
        log.info("LC-getKitToken\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)s);
        LCBaseRes lcListDeviceDetailsByIdsReqLCBaseReq = null;
        try {
            lcListDeviceDetailsByIdsReqLCBaseReq = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<LCKitTokenRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcListDeviceDetailsByIdsReqLCBaseReq.getResult();
        String code = result.getCode();
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)code)) {
            log.error("lc_ERR:{}", result);
            throw new CommonException(ExceptionEnum.LC_ERROR);
        }
        return (LCKitTokenRes)result.getData();
    }

    private void sign(LCBaseReq req, String appSecret, String appId) {
        Long time = Instant.now().getEpochSecond();
        String nonce = UUID.randomUUID().toString();
        String SIGN_TEMPLATE = MessageFormat.format("time:{0},nonce:{1},appSecret:{2}", time.toString(), nonce, appSecret);
        String sign = DigestUtils.md5Hex((String)SIGN_TEMPLATE);
        LCSysTemReq system = new LCSysTemReq();
        system.setSign(sign);
        system.setAppId(appId);
        system.setTime(time);
        system.setNonce(nonce);
        req.setSystem(system);
        String requestId = MDC.get((String)StringConstant.REQUEST_ID);
        if (StringUtils.isEmpty((CharSequence)requestId)) {
            requestId = UUID.randomUUID().toString();
        }
        req.setId(requestId);
    }

    public LCBaseRes<LCAccessTokenRes> getLCAccessToken(String appSecret, String appId) {
        LCBaseReq req = new LCBaseReq();
        req.setParams(new HashMap());
        this.sign(req, appSecret, appId);
        log.info("lcBaseFeign.getAccessToken\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(req));
        String accessToken = this.lcBaseFeign.getAccessToken(req);
        log.info("lcBaseFeign.getAccessToken\u8fd4\u56de\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog((Object)accessToken));
        try {
            return (LCBaseRes)JsonUtils.objectMapper.readValue(accessToken, (TypeReference)new TypeReference<LCBaseRes<LCAccessTokenRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }

    public LCListDeviceDetailsByIdsRes listDeviceDetailsByIds(LCListDeviceDetailsByIdsReq req, String appSecret, String appId) {
        LCBaseReq<LCListDeviceDetailsByIdsReq> param = new LCBaseReq<LCListDeviceDetailsByIdsReq>();
        param.setParams(req);
        this.sign(param, appSecret, appId);
        log.info("lcBaseFeign.listDeviceDetailsByIds\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(param));
        String s = this.lcBaseFeign.listDeviceDetailsByIds(param);
        log.info("lcBaseFeign.listDeviceDetailsByIds\uff1a{}", (Object)s);
        LCBaseRes lcListDeviceDetailsByIdsReqLCBaseReq = null;
        try {
            lcListDeviceDetailsByIdsReqLCBaseReq = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<LCListDeviceDetailsByIdsRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcListDeviceDetailsByIdsReqLCBaseReq.getResult();
        String code = result.getCode();
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)code)) {
            log.error("lc_ERR:{}", result);
            throw new CommonException(ExceptionEnum.LC_ERROR);
        }
        return (LCListDeviceDetailsByIdsRes)result.getData();
    }

    public CreateDeviceFlvLiveRes createDeviceFlvLive(CreateDeviceFlvLiveReq req, String appSecret, String appId) {
        LCBaseReq<CreateDeviceFlvLiveReq> param = new LCBaseReq<CreateDeviceFlvLiveReq>();
        param.setParams(req);
        if (StringUtils.equals((CharSequence)"realTime", (CharSequence)req.getType())) {
            CreateDeviceFlvLiveRes data;
            log.info("lcBaseFeign.queryDeviceFlvLive\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(param));
            this.sign(param, appSecret, appId);
            String query = this.lcBaseFeign.queryDeviceFlvLive(param);
            log.info("lcBaseFeign.queryDeviceFlvLive\uff1a{}", (Object)query);
            LCBaseRes queryRes = null;
            try {
                queryRes = (LCBaseRes)JsonUtils.objectMapper.readValue(query, (TypeReference)new TypeReference<LCBaseRes<CreateDeviceFlvLiveRes>>(){});
            }
            catch (JsonProcessingException e) {
                log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
                throw new CommonException(ExceptionEnum.JSON_ERR);
            }
            if (queryRes.getResult() != null && queryRes.getResult().getData() != null && StringUtils.isNotEmpty((CharSequence)(data = (CreateDeviceFlvLiveRes)queryRes.getResult().getData()).getFlv())) {
                return data;
            }
        }
        log.info("lcBaseFeign.createDeviceFlvLive\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(param));
        this.sign(param, appSecret, appId);
        String s = this.lcBaseFeign.createDeviceFlvLive(param);
        log.info("lcBaseFeign.createDeviceFlvLive\uff1a{}", (Object)s);
        LCBaseRes lcListDeviceDetailsByIdsReqLCBaseReq = null;
        try {
            lcListDeviceDetailsByIdsReqLCBaseReq = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<CreateDeviceFlvLiveRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcListDeviceDetailsByIdsReqLCBaseReq.getResult();
        String code = result.getCode();
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)code)) {
            log.error("lc_ERR:{}", result);
            throw new CommonException(ExceptionEnum.LC_ERROR);
        }
        return (CreateDeviceFlvLiveRes)result.getData();
    }

    public BindDeviceLiveRes.StreamsDTO createLiveHls(BindDeviceLiveReq req, String appSecret, String appId) {
        String callId;
        long startTime;
        block14: {
            Integer streamId1;
            startTime = System.currentTimeMillis();
            callId = "call_" + startTime + "_" + Thread.currentThread().getId();
            log.info("[{}] ====== \u5f00\u59cb\u8c03\u7528 createLiveHls \u65b9\u6cd5 ======", (Object)callId);
            log.info("[{}] \u8bf7\u6c42\u53c2\u6570: streamId={}, deviceId={}, channelId={}, appId={}", new Object[]{callId, req.getStreamId(), req.getDeviceId(), req.getChannelId(), appId});
            BindDeviceLiveRes.StreamsDTO res = new BindDeviceLiveRes.StreamsDTO();
            Integer streamId = req.getStreamId();
            boolean querySuccess = false;
            long queryStartTime = System.currentTimeMillis();
            try {
                log.info("[{}] \u5f00\u59cb\u67e5\u8be2\u76f4\u64ad\u6d41\u4fe1\u606f, \u8017\u65f6\u76d1\u63a7\u5f00\u59cb", (Object)callId);
                GetLiveStreamInfoReq getLiveStreamInfoReq = new GetLiveStreamInfoReq();
                getLiveStreamInfoReq.setDeviceId(req.getDeviceId());
                getLiveStreamInfoReq.setChannelId(req.getChannelId());
                getLiveStreamInfoReq.setToken(req.getToken());
                LCBaseReq<GetLiveStreamInfoReq> param1 = new LCBaseReq<GetLiveStreamInfoReq>();
                param1.setParams(getLiveStreamInfoReq);
                this.sign(param1, appSecret, appId);
                log.info("[{}] lcBaseFeign.getLiveStreamInfo req:{}", (Object)callId, (Object)JsonUtils.beanToJsonStringForLog(param1));
                String liveStreamInfo = this.lcBaseFeign.getLiveStreamInfo(param1);
                long queryEndTime = System.currentTimeMillis();
                log.info("[{}] lcBaseFeign.getLiveStreamInfo res:{}, \u67e5\u8be2\u8017\u65f6: {}ms", new Object[]{callId, JsonUtils.beanToJsonStringForLog((Object)liveStreamInfo), queryEndTime - queryStartTime});
                LCBaseRes liveStreamInfoResLCBaseRes = null;
                try {
                    liveStreamInfoResLCBaseRes = (LCBaseRes)JsonUtils.objectMapper.readValue(liveStreamInfo, (TypeReference)new TypeReference<LCBaseRes<GetLiveStreamInfoRes>>(){});
                }
                catch (JsonProcessingException e) {
                    log.error("[{}] \u67e5\u8be2\u76f4\u64ad\u6d41\u4fe1\u606fJSON\u89e3\u6790\u5931\u8d25\uff0c\u7ee7\u7eed\u6267\u884c\u521b\u5efa\u6d41\u7a0b:{}", (Object)callId, (Object)LogUtil.getStackTraceInfo((Exception)((Object)e)));
                    throw e;
                }
                String code = liveStreamInfoResLCBaseRes.getResult().getCode();
                log.info("[{}] \u67e5\u8be2\u76f4\u64ad\u6d41\u8fd4\u56de\u7801: {}", (Object)callId, (Object)code);
                if (StringUtils.equals((CharSequence)code, (CharSequence)"0")) {
                    GetLiveStreamInfoRes data = (GetLiveStreamInfoRes)liveStreamInfoResLCBaseRes.getResult().getData();
                    List<GetLiveStreamInfoRes.StreamsDTO> streams = data.getStreams();
                    log.info("[{}] \u67e5\u8be2\u5230 {} \u4e2a\u6d41\u4fe1\u606f", (Object)callId, (Object)streams.size());
                    for (GetLiveStreamInfoRes.StreamsDTO item : streams) {
                        String status = item.getStatus();
                        streamId1 = item.getStreamId();
                        log.info("[{}] \u6d41\u4fe1\u606f: streamId={}, status={}", new Object[]{callId, streamId1, status});
                        if (!Objects.equals(streamId1, streamId) || !Objects.equals(status, "0") && !Objects.equals(status, "1")) continue;
                        res.setCoverUrl(item.getCoverUrl());
                        res.setStreamId(item.getStreamId());
                        res.setHls(item.getHls());
                        log.info("[{}] \u67e5\u8be2\u6210\u529f\uff0c\u627e\u5230\u5339\u914d\u7684\u6d41\u4fe1\u606f\uff0c\u8fd4\u56de\u7ed3\u679c: streamId={}, hls={}", new Object[]{callId, res.getStreamId(), res.getHls()});
                        long totalTime = System.currentTimeMillis() - startTime;
                        log.info("[{}] ====== createLiveHls \u65b9\u6cd5\u8c03\u7528\u5b8c\u6210 (\u67e5\u8be2\u6a21\u5f0f) ====== \u603b\u8017\u65f6: {}ms", (Object)callId, (Object)totalTime);
                        return res;
                    }
                    log.info("[{}] \u67e5\u8be2\u672a\u627e\u5230\u5339\u914d\u7684\u6d41\u4fe1\u606f\uff0c\u7ee7\u7eed\u6267\u884c\u521b\u5efa\u6d41\u7a0b", (Object)callId);
                } else {
                    log.warn("[{}] \u67e5\u8be2\u76f4\u64ad\u6d41\u4fe1\u606f\u8fd4\u56de\u9519\u8bef\u7801:{}\uff0c\u7ee7\u7eed\u6267\u884c\u521b\u5efa\u6d41\u7a0b", (Object)callId, (Object)code);
                }
                querySuccess = true;
            }
            catch (Exception e) {
                log.error("[{}] \u67e5\u8be2\u76f4\u64ad\u6d41\u4fe1\u606f\u5931\u8d25\uff0c\u7ee7\u7eed\u6267\u884c\u521b\u5efa\u6d41\u7a0b:{}", (Object)callId, (Object)LogUtil.getStackTraceInfo((Exception)e));
            }
            long createStartTime = System.currentTimeMillis();
            try {
                log.info("[{}] \u5f00\u59cb\u521b\u5efa\u76f4\u64ad\u6d41\u4fe1\u606f, \u8017\u65f6\u76d1\u63a7\u5f00\u59cb", (Object)callId);
                LCBaseReq<BindDeviceLiveReq> param = new LCBaseReq<BindDeviceLiveReq>();
                param.setParams(req);
                this.sign(param, appSecret, appId);
                log.info("[{}] lcBaseFeign.bindDeviceLive req:{}", (Object)callId, (Object)JsonUtils.beanToJsonStringForLog(param));
                String s = this.lcBaseFeign.bindDeviceLive(param);
                long createEndTime = System.currentTimeMillis();
                log.info("[{}] lcBaseFeign.bindDeviceLive res:{}, \u521b\u5efa\u8017\u65f6: {}ms", new Object[]{callId, JsonUtils.beanToJsonStringForLog((Object)s), createEndTime - createStartTime});
                LCBaseRes queryRes = null;
                try {
                    queryRes = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<BindDeviceLiveRes>>(){});
                }
                catch (JsonProcessingException e) {
                    log.error("[{}] \u521b\u5efa\u76f4\u64ad\u6d41JSON\u89e3\u6790\u5931\u8d25:{}", (Object)callId, (Object)LogUtil.getStackTraceInfo((Exception)((Object)e)));
                    throw new CommonException(ExceptionEnum.JSON_ERR);
                }
                String code = queryRes.getResult().getCode();
                log.info("[{}] \u521b\u5efa\u76f4\u64ad\u6d41\u8fd4\u56de\u7801: {}", (Object)callId, (Object)code);
                if (StringUtils.equals((CharSequence)code, (CharSequence)"0")) {
                    BindDeviceLiveRes bindDeviceLiveRes = (BindDeviceLiveRes)queryRes.getResult().getData();
                    List<BindDeviceLiveRes.StreamsDTO> streams = bindDeviceLiveRes.getStreams();
                    log.info("[{}] \u521b\u5efa\u6210\u529f\uff0c\u5f97\u5230 {} \u4e2a\u6d41\u4fe1\u606f", (Object)callId, (Object)streams.size());
                    for (BindDeviceLiveRes.StreamsDTO item : streams) {
                        streamId1 = item.getStreamId();
                        log.info("[{}] \u6d41\u4fe1\u606f: streamId={}", (Object)callId, (Object)streamId1);
                        if (!Objects.equals(streamId1, streamId)) continue;
                        res.setCoverUrl(item.getCoverUrl());
                        res.setStreamId(item.getStreamId());
                        res.setHls(item.getHls());
                        log.info("[{}] \u521b\u5efa\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c: streamId={}, hls={}", new Object[]{callId, res.getStreamId(), res.getHls()});
                        long totalTime = System.currentTimeMillis() - startTime;
                        log.info("[{}] ====== createLiveHls \u65b9\u6cd5\u8c03\u7528\u5b8c\u6210 (\u521b\u5efa\u6a21\u5f0f) ====== \u603b\u8017\u65f6: {}ms", (Object)callId, (Object)totalTime);
                        return res;
                    }
                } else {
                    log.error("[{}] \u521b\u5efa\u76f4\u64ad\u6d41\u8fd4\u56de\u9519\u8bef\u7801:{}", (Object)callId, (Object)code);
                }
            }
            catch (Exception e) {
                log.error("[{}] \u521b\u5efa\u76f4\u64ad\u6d41\u5931\u8d25:{}", (Object)callId, (Object)LogUtil.getStackTraceInfo((Exception)e));
                if (querySuccess) break block14;
                log.error("[{}] \u67e5\u8be2\u548c\u521b\u5efa\u76f4\u64ad\u6d41\u90fd\u5931\u8d25\uff0c\u8fd4\u56denull", (Object)callId);
            }
        }
        long totalTime = System.currentTimeMillis() - startTime;
        log.warn("[{}] \u65b9\u6cd5\u8c03\u7528\u7ed3\u675f\uff0c\u8fd4\u56denull\uff0c\u603b\u8017\u65f6: {}ms", (Object)callId, (Object)totalTime);
        return null;
    }

    public ListDeviceDetailsByPageRes listDeviceDetailsByPage(Integer pageNum, Integer pageSize, String source, String token, String appSecret, String appId) {
        ListDeviceDetailsByPageReq req = new ListDeviceDetailsByPageReq();
        req.setPageSize(pageSize);
        req.setPage((long)pageNum);
        req.setToken(token);
        req.setSource(source);
        LCBaseReq<ListDeviceDetailsByPageReq> param = new LCBaseReq<ListDeviceDetailsByPageReq>();
        param.setParams(req);
        this.sign(param, appSecret, appId);
        log.info("lcBaseFeign.listDeviceDetailsByPage\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(param));
        String s = this.lcBaseFeign.listDeviceDetailsByPage(param);
        log.info("lcBaseFeign.listDeviceDetailsByPage\uff1a{}", (Object)s);
        LCBaseRes lcListDeviceDetailsByIdsReqLCBaseReq = null;
        try {
            lcListDeviceDetailsByIdsReqLCBaseReq = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<ListDeviceDetailsByPageRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        return (ListDeviceDetailsByPageRes)lcListDeviceDetailsByIdsReqLCBaseReq.getResult().getData();
    }

    public List<QueryLocalRecordsRes.RecordsDTO> queryLocalRecords(String deviceId, Integer channelId, String startTime, String endTime, String token, String appSecret, String appId, Integer count) {
        QueryLocalRecordsReq req = new QueryLocalRecordsReq();
        req.setDeviceId(deviceId);
        req.setChannelId(channelId.toString());
        req.setBeginTime(startTime);
        req.setEndTime(endTime);
        req.setType("All");
        req.setCount(count);
        req.setToken(token);
        LCBaseReq<QueryLocalRecordsReq> param = new LCBaseReq<QueryLocalRecordsReq>();
        param.setParams(req);
        this.sign(param, appSecret, appId);
        log.info("lcBaseFeign.queryLocalRecords\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(param));
        String s = this.lcBaseFeign.queryLocalRecords(param);
        log.info("lcBaseFeign.queryLocalRecords\uff1a{}", (Object)s);
        LCBaseRes lcListDeviceDetailsByIdsReqLCBaseReq = null;
        try {
            lcListDeviceDetailsByIdsReqLCBaseReq = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<QueryLocalRecordsRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcListDeviceDetailsByIdsReqLCBaseReq.getResult();
        QueryLocalRecordsRes data = (QueryLocalRecordsRes)result.getData();
        return data.getRecords();
    }

    public Boolean controlMovePTZ(String deviceId, Integer channelId, String operation, Integer duration, String token, String appSecret, String appId) {
        ControlMovePTZReq req = new ControlMovePTZReq();
        req.setDeviceId(deviceId);
        req.setChannelId(channelId.toString());
        req.setOperation(operation);
        req.setDuration(duration.toString());
        req.setToken(token);
        LCBaseReq<ControlMovePTZReq> param = new LCBaseReq<ControlMovePTZReq>();
        param.setParams(req);
        this.sign(param, appSecret, appId);
        log.info("lcBaseFeign.controlMovePTZ\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(param));
        String s = this.lcBaseFeign.controlMovePTZ(param);
        log.info("lcBaseFeign.controlMovePTZ\uff1a{}", (Object)s);
        LCBaseRes lcListDeviceDetailsByIdsReqLCBaseReq = null;
        try {
            lcListDeviceDetailsByIdsReqLCBaseReq = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcListDeviceDetailsByIdsReqLCBaseReq.getResult();
        if (result == null) {
            return false;
        }
        return StringUtils.equals((CharSequence)"0", (CharSequence)result.getCode());
    }

    public String setDeviceSnap(String deviceId, Integer channelId, String token, String appSecret, String appId) {
        DeviceSnapReq req = new DeviceSnapReq();
        req.setDeviceId(deviceId);
        req.setChannelId(channelId.toString());
        req.setToken(token);
        LCBaseReq<DeviceSnapReq> param = new LCBaseReq<DeviceSnapReq>();
        param.setParams(req);
        this.sign(param, appSecret, appId);
        log.info("lcBaseFeign.setDeviceSnapEnhanced\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(param));
        String s = this.lcBaseFeign.setDeviceSnapEnhanced(param);
        log.info("lcBaseFeign.setDeviceSnapEnhanced\uff1a{}", (Object)s);
        LCBaseRes lcListDeviceDetailsByIdsReqLCBaseReq = null;
        try {
            lcListDeviceDetailsByIdsReqLCBaseReq = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<DeviceSnapRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcListDeviceDetailsByIdsReqLCBaseReq.getResult();
        if (result == null) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        DeviceSnapRes data = (DeviceSnapRes)result.getData();
        if (data == null) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        for (int i = 0; i <= 4; ++i) {
            try {
                ResponseEntity forEntity = this.restTemplate.getForEntity(data.getUrl(), String.class, new Object[0]);
                HttpStatus statusCode = forEntity.getStatusCode();
                if (statusCode.is2xxSuccessful()) break;
                log.warn("\u4e50\u6a59\u56fe\u7247\u8d44\u6e90\u83b7\u53d6\u5931\u8d25\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog((Object)forEntity));
            }
            catch (Exception e) {
                log.error("\u4e50\u6a59\u56fe\u7247\u8d44\u6e90\u83b7\u53d6\u5931\u8d25\uff1a{}", (Object)LogUtil.getStackTraceInfo((Exception)e));
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return data.getUrl();
    }

    public DeviceStorageRes deviceStorage(String deviceId, String token, String appSecret, String appId) {
        DeviceSdcardStatusReq req = new DeviceSdcardStatusReq();
        req.setDeviceId(deviceId);
        req.setToken(token);
        LCBaseReq<DeviceSdcardStatusReq> param = new LCBaseReq<DeviceSdcardStatusReq>();
        param.setParams(req);
        this.sign(param, appSecret, appId);
        log.info("lcBaseFeign.deviceStorage\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(param));
        String s = this.lcBaseFeign.deviceStorage(param);
        log.info("lcBaseFeign.deviceStorage\uff1a{}", (Object)s);
        LCBaseRes lcListDeviceDetailsByIdsReqLCBaseReq = null;
        try {
            lcListDeviceDetailsByIdsReqLCBaseReq = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<DeviceStorageRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcListDeviceDetailsByIdsReqLCBaseReq.getResult();
        if (result == null) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        DeviceStorageRes data = (DeviceStorageRes)result.getData();
        if (data == null) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return data;
    }

    public DeviceSdcardStatusRes deviceSdcardStatus(String deviceId, String token, String appSecret, String appId) {
        DeviceSdcardStatusReq req = new DeviceSdcardStatusReq();
        req.setDeviceId(deviceId);
        req.setToken(token);
        LCBaseReq<DeviceSdcardStatusReq> param = new LCBaseReq<DeviceSdcardStatusReq>();
        param.setParams(req);
        this.sign(param, appSecret, appId);
        log.info("lcBaseFeign.deviceSdcardStatus\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(param));
        String s = this.lcBaseFeign.deviceSdcardStatus(param);
        log.info("lcBaseFeign.deviceSdcardStatus\uff1a{}", (Object)s);
        LCBaseRes lcListDeviceDetailsByIdsReqLCBaseReq = null;
        try {
            lcListDeviceDetailsByIdsReqLCBaseReq = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes<DeviceSdcardStatusRes>>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcListDeviceDetailsByIdsReqLCBaseReq.getResult();
        if (result == null) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        DeviceSdcardStatusRes data = (DeviceSdcardStatusRes)result.getData();
        if (data == null) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return data;
    }

    public Boolean setDeviceAuthStatus(String token, String appSecret, String appId, List<SetDeviceAuthStatusReq.DeviceListDTO> deviceList, String status) {
        SetDeviceAuthStatusReq req = new SetDeviceAuthStatusReq();
        req.setStatus(status);
        req.setToken(token);
        req.setDeviceList(deviceList);
        LCBaseReq<SetDeviceAuthStatusReq> param = new LCBaseReq<SetDeviceAuthStatusReq>();
        param.setParams(req);
        this.sign(param, appSecret, appId);
        log.info("lcBaseFeign.setDeviceAuthStatus\uff1a{}", (Object)JsonUtils.beanToJsonStringForLog(param));
        String s = this.lcBaseFeign.setDeviceAuthStatus(param);
        log.info("lcBaseFeign.setDeviceAuthStatus\uff1a{}", (Object)s);
        LCBaseRes lcListDeviceDetailsByIdsReqLCBaseReq = null;
        try {
            lcListDeviceDetailsByIdsReqLCBaseReq = (LCBaseRes)JsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<LCBaseRes>(){});
        }
        catch (JsonProcessingException e) {
            log.error(LogUtil.getStackTraceInfo((Exception)((Object)e)));
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        LCRes result = lcListDeviceDetailsByIdsReqLCBaseReq.getResult();
        if (result == null) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        String code = result.getCode();
        return "0".equals(code) || StringUtils.equals((CharSequence)"AU1009", (CharSequence)code);
    }
}

