package com.ovopark.marketing.common.enums;


public enum MsgTypeEnum {

    TASK_EXPIRED(1, "任务过期"),
    TASK_EXPIRE_SOON(2, "任务即将过期"),
    NO_TASK_DEVICE(3, "无任务设备");

    private Integer key;
    private String value;

    private MsgTypeEnum(Integer key, String value) {
        this.key = key;
        this.value = value;
    }

    public Integer getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public static String getValueByKey(Integer key) {
        if (key == null) {
            return null;
        }
        for (MsgTypeEnum e : MsgTypeEnum.values()) {
            if (e.getKey().equals(key)) {
                return e.getValue();
            }
        }
        return null;
    }

}
