package com.ovopark.marketing.common.model;

/**
 * 请求异常的枚举类  后期所有code 这里维护
 */
public enum ExceptionEnum {

    SUCCESS("0","ok"),
    ERROR("1","ERROR"),
    PARAM_ERROR("-1","PARAM_ERROR"),
    RESULT_FAILED("-2","RESULT_FAILED"),
    INVALID_TOKEN("-3","INVALID_TOKEN"),
    SIGNATURE_ERROR("-4","SIGNATURE_ERROR"),
    user_NOT_EXIST("-5","user_NOT_EXIST"),
    ILLEGAL_ACCESS_ERROR("-6","ILLEGAL_ACCESS"),
    NO_PRIVILEGE("99990001","NO_PRIVILEGE"),

    TOKEN_NOT_EXIT("9990001","TOKEN_NOT_EXIT"),
    TOKEN_EXPIRATION("9990002","TOKEN_EXPIRATION"),
    /**
     * 平台相关20000
     */
    PLATFORM_NOT_EXIST("20000","PLATFORM_NOT_EXIST"),

    /**
     * 门店相关30000
     */
    SHOP_NOT_EXIST("30000","SHOP_NOT_EXIST"),
    /**
     * 异常错误
     */
    RESULT_EXCEPTION("99999","RESULT_EXCEPTION"),
    CLOUD_EXCEPTION("199999","CLOUD_EXCEPTION"),

    FOLDER_ALREADY_EXIST("10001", "FOLDER_ALREADY_EXIST"),
    RESOURCES_NAME_ALREADY_EXIST("10002", "RESOURCES_NAME_ALREADY_EXIST"),

    LICENSE_SAME_ERROR("11000011", "Mac地址已存在"),

    LICENSE_NOT_EXIST_ERROR("11000012", "LICENSE_NOT_EXIST"),

    OVO_STATION_VAILDTIME_ERROR("1000001", "有效时间错误"),

    UNABLE_TO_DELETE_ERROR("1000002", "UNABLE_TO_DELETE"),//该任务类型已被使用，无法删除

    LABEL_DEVICE_NOT_EXIST_ERROR("1000003", "LABEL_DEVICE_NOT_EXIST"),//标签下无设备，请先绑定设备

    TASK_PRIORITY_EXIST_ERROR("1000004", "TASK_PRIORITY_EXIST"),//优先级已存在

    NEW_XIAOYIN_ERROR("1000005", "NEW_XIAOYIN"),//新设备，未注册过！

    DATA_NOT_EXIST_ERROR("1000006", "DATA_NOT_EXIST"),//数据不存在！

    FORBID_TO_DELETE_ERROR("1000007", "FORBID_TO_DELETE"), //数据不可删除

    USER_NOT_EXIST_ERROR("1000008", "USER_NOT_EXIST"), //用户名密码不正确

    DEVICE_NOT_EXIST_ERROR("1000009", "DEVICE_NOT_EXIST"), //设备不存在

    DEVICE_NOT_BELONG_GROUP_ERROR("1000010", "DEVICE_NOT_BELONG_GROUP"), //设备不属于该企业，无法删除

    UNIQUE_CODE_NOT_EXIST_ERROR("1000011", "UNIQUE_CODE_NOT_EXIST"), //信发唯一码不存在

    NEW_ANDROID_CODE_EXIST_ERROR("1000012", "NEW_ANDROID_CODE_EXIST"), //新安卓id 已存在
    ;

    private String code;
    private String message;

    ExceptionEnum(String code, String message){
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}