package com.ovopark.marketing.common.enums;


public enum DeviceTypeEnum {

    XINFA(1, "信发"),
    XIAOYIN(2, "小音");

    private Integer key;
    private String value;

    private DeviceTypeEnum(Integer key, String value) {
        this.key = key;
        this.value = value;
    }

    public Integer getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public static String getValueByKey(Integer key) {
        if (key == null) {
            return null;
        }
        for (DeviceTypeEnum e : DeviceTypeEnum.values()) {
            if (e.getKey().equals(key)) {
                return e.getValue();
            }
        }
        return null;
    }

}
