package com.ovopark.marketing.common.model;

import java.io.Serializable;

public class TokenValue implements Serializable {
    private static final long serialVersionUID = -3609898030503404872L;
    /**
     * 用户id
     */
    private Integer userId;
    /**
     * 登录类型 1web  2 ios 3 Android
     */
    private Integer loginType;
    /**
     * token 过期时间戳
     */
    private Long tokenExpirationTimestamp;
    /**
     * token 刷新过期时间戳
     */
    private Long refreshExpirationTimestamp;
    /**
     * 创建时间戳
     */
    private Long createAtTimestamp;
    /**
     * token
     */
    private String token;

    /**
     * groupId
     */
    private Integer groupId;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 代理商字段
     */
    private Integer isAgency;

    public Integer getUserId() {
        return userId;
    }

    public TokenValue setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public Integer getLoginType() {
        return loginType;
    }

    public TokenValue setLoginType(Integer loginType) {
        this.loginType = loginType;
        return this;
    }

    public Long getTokenExpirationTimestamp() {
        return tokenExpirationTimestamp;
    }

    public TokenValue setTokenExpirationTimestamp(Long tokenExpirationTimestamp) {
        this.tokenExpirationTimestamp = tokenExpirationTimestamp;
        return this;
    }

    public Long getRefreshExpirationTimestamp() {
        return refreshExpirationTimestamp;
    }

    public TokenValue setRefreshExpirationTimestamp(Long refreshExpirationTimestamp) {
        this.refreshExpirationTimestamp = refreshExpirationTimestamp;
        return this;
    }

    public Long getCreateAtTimestamp() {
        return createAtTimestamp;
    }

    public TokenValue setCreateAtTimestamp(Long createAtTimestamp) {
        this.createAtTimestamp = createAtTimestamp;
        return this;
    }

    public String getToken() {
        return token;
    }

    public TokenValue setToken(String token) {
        this.token = token;
        return this;
    }

    public Integer getGroupId() {
        return groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Integer getIsAgency() {
        return isAgency;
    }

    public void setIsAgency(Integer isAgency) {
        this.isAgency = isAgency;
    }

    @Override
    public String toString() {
        return "TokenValue{" +
                "userId=" + userId +
                ", loginType=" + loginType +
                ", tokenExpirationTimestamp=" + tokenExpirationTimestamp +
                ", refreshExpirationTimestamp=" + refreshExpirationTimestamp +
                ", createAtTimestamp=" + createAtTimestamp +
                ", token='" + token + '\'' +
                ", groupId=" + groupId +
                ", userName='" + userName + '\'' +
                ", isAgency=" + isAgency +
                '}';
    }
}
