package com.ovopark.marketing.api;

import com.ovopark.marketing.common.model.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author : S.  J Y
 * @description
 * @date : 2022-12-06 21:51
 **/
@FeignClient(value = "ovopark-marketing")
public interface MarketingApi {

    @PostMapping("/ovopark-marketing/xinfaMission/deleteDeviceByDeptIds")
    BaseResult deleteByIds(@RequestBody List<Integer> deptIds);

    @PostMapping("/ovopark-marketing/deviceSummary/getDeviceNumByDepId")
    BaseResult<List<IdNumDTO>> getDeviceNumByDepId(@RequestBody List<Long> deptIdList);

    @PostMapping("/ovopark-marketing/deviceSummary/getHasXinfaDeviceDeptIds")
    BaseResult<List<Integer>> getHasXinfaDeviceDeptIds(@RequestBody List<Integer> deptIds);

    @PostMapping("/ovopark-marketing/marketingFeign/saveXiaoyinDevice")
    BaseResult saveXiaoyinDevice(@RequestBody SaveXiaoyinDevice device);

    @PostMapping("/ovopark-marketing/marketingFeign/delXiaoyinDevice")
    BaseResult delXiaoyinDevice(@RequestParam String deviceMac);

    @PostMapping("/ovopark-marketing/marketingFeign/sendXiaoyinTask")
    BaseResult<Void> sendXiaoyinTask(@RequestBody List<Integer> idList);

    @PostMapping("/ovopark-marketing/xinfaMission/retryExportMissionAndDevice")
    BaseResult retryExportMissionAndDevice(@RequestParam Integer taskId);

    @PostMapping("/ovopark-marketing/dataExport/retryExportLabelDevice")
    BaseResult retryExportLabelDevice(@RequestParam Integer taskId);

    @PostMapping("/ovopark-marketing/marketingFeign/getMarketingDeptDeviceList")
    BaseResult<List<MarketingDeptDeviceDto>> getMarketingDeptDeviceList(@RequestBody List<Long> deptIds);

    @PostMapping("/ovopark-marketing/versionException/retryExportVersionException")
    BaseResult retryExportVersionException(@RequestParam Integer taskId);
}
