/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = -6582473365671012877L;
    public static final int MAX_PAGE_SIZE = Integer.MAX_VALUE;
    private int pageNumber = 1;
    private int pageSize = 20;
    private Long totalCount = 0L;
    private Long pageCount = 0L;
    private Integer id;
    private List<T> content = new ArrayList<T>();

    public Page() {
    }

    public Page(List<T> content) {
        if (null == content) {
            throw new IllegalArgumentException("Content must not be null!");
        }
        this.content.addAll(content);
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber < 1 ? 1 : pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize < 1) {
            pageSize = 1;
        } else if (pageSize > Integer.MAX_VALUE) {
            pageSize = Integer.MAX_VALUE;
        }
        this.pageSize = pageSize;
    }

    public List<T> getContent() {
        return this.content;
    }

    public void setContent(List<T> content) {
        this.content = content;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
        Long pageCount = totalCount % (long)this.pageSize == 0L ? totalCount / (long)this.pageSize : totalCount / (long)this.pageSize + 1L;
        this.setPageCount(pageCount);
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public void setPageCount(Long pageCount) {
        this.pageCount = pageCount;
    }

    public Long getPageCount() {
        return this.pageCount;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.pageNumber ^ this.pageNumber >>> 32);
        result = 31 * result + (int)(this.totalCount ^ this.totalCount >>> 32);
        result = 31 * result + (int)(this.pageCount ^ this.pageCount >>> 32);
        result = 31 * result + this.content.hashCode();
        return result;
    }
}

