/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.compare;

import com.ovopark.compare.Compare;
import com.ovopark.compare.CompareNode;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class CompareUtils<T> {
    public static final String NAME = "name";
    public static final String OLD_VALUE = "oldValue";
    public static final String NEW_VALUE = "newValue";
    public static final String NEW_VALUE_DESC = "newValueDesc";
    private static final String UNDER_LINE = "_";

    public LinkedList<Map> compare(T source, T target) {
        return this.compare(source, target, null);
    }

    public LinkedList<Map> compare(T source, T target, List<String> ignoreCompareFields) {
        if (Objects.isNull(source) && Objects.isNull(target)) {
            return null;
        }
        Map<String, CompareNode> sourceMap = this.getFiledValueMap(source);
        Map<String, CompareNode> targetMap = this.getFiledValueMap(target);
        if (sourceMap.isEmpty() && targetMap.isEmpty()) {
            return null;
        }
        LinkedList<Map> maps = this.doCompare(sourceMap, targetMap, ignoreCompareFields);
        return maps;
    }

    private LinkedList<Map> doCompare(Map<String, CompareNode> sourceMap, Map<String, CompareNode> targetMap, List<String> ignoreCompareFields) {
        LinkedList<Map> mapList = new LinkedList<Map>();
        Set<String> keys = sourceMap.keySet();
        for (String key : keys) {
            String tv;
            String sv;
            CompareNode sn = sourceMap.get(key);
            CompareNode tn = targetMap.get(key);
            if (Objects.nonNull(ignoreCompareFields) && ignoreCompareFields.contains(sn.getFieldKey()) || (sv = Optional.ofNullable(sn.getFieldValue()).orElse("").toString()).equals(tv = Optional.ofNullable(tn.getFieldValue()).orElse("").toString())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(NAME, sn.getFieldName());
            map.put(OLD_VALUE, sv);
            map.put(NEW_VALUE, tv);
            map.put(NEW_VALUE_DESC, sn.getReplaceMap().get(tv));
            mapList.add(map);
        }
        return mapList;
    }

    private Map<String, CompareNode> getFiledValueMap(T t) {
        if (Objects.isNull(t)) {
            return Collections.emptyMap();
        }
        Field[] fields = t.getClass().getDeclaredFields();
        if (Objects.isNull(fields) || fields.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, CompareNode> map = new LinkedHashMap<String, CompareNode>();
        for (Field field : fields) {
            Compare compareAnnotation = field.getAnnotation(Compare.class);
            if (Objects.isNull(compareAnnotation)) continue;
            field.setAccessible(true);
            try {
                String fieldKey = field.getName();
                CompareNode node = new CompareNode();
                node.setFieldKey(fieldKey);
                node.setFieldValue(field.get(t));
                node.setFieldName(compareAnnotation.value());
                HashMap<String, String> replaceMap = new HashMap<String, String>();
                if (compareAnnotation.replace() != null) {
                    for (String replace : Arrays.asList(compareAnnotation.replace())) {
                        String[] split = replace.split(UNDER_LINE);
                        if (split.length != 2) continue;
                        replaceMap.put(split[1], split[0]);
                    }
                }
                node.setReplaceMap(replaceMap);
                map.put(field.getName(), node);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return map;
    }
}

