/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.update;

import com.ovopark.pojo.UpdateFieldVo;
import com.ovopark.update.DefaultTypeConverters;
import com.ovopark.update.TypeConverter;
import com.ovopark.update.UpdateField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldUpdaterUtils {
    private static final Logger log = LoggerFactory.getLogger(FieldUpdaterUtils.class);
    private final Map<Class<?>, TypeConverter> typeConverters;

    public FieldUpdaterUtils(Map<Class<?>, TypeConverter> typeConverters) {
        this.typeConverters = typeConverters;
    }

    public static FieldUpdaterUtils getDefaultInstance() {
        return new FieldUpdaterUtils(new HashMap(DefaultTypeConverters.CONVERTERS));
    }

    public <T> boolean checkCanUpdateFields(T targetObject, List<UpdateFieldVo> updateFields, Integer taskType, Integer id) throws Exception {
        Class<?> clazz = targetObject.getClass();
        Map<String, Field> fieldMap = this.getFieldMap(clazz);
        boolean hasApplicableField = false;
        ArrayList<String> nonApplicableFields = new ArrayList<String>();
        for (UpdateFieldVo vo : updateFields) {
            String fieldName = vo.getFieldName();
            if (!fieldMap.containsKey(fieldName)) {
                nonApplicableFields.add(fieldName);
                continue;
            }
            Field field = fieldMap.get(fieldName);
            field.setAccessible(true);
            UpdateField anno = field.getAnnotation(UpdateField.class);
            int[] applicableTypes = anno.applicableTypes();
            if (applicableTypes.length == 0) {
                hasApplicableField = true;
                continue;
            }
            if (taskType != null) {
                boolean matched = false;
                for (int t : applicableTypes) {
                    if (t != taskType) continue;
                    matched = true;
                    break;
                }
                if (matched) {
                    hasApplicableField = true;
                    continue;
                }
                nonApplicableFields.add(fieldName);
                continue;
            }
            nonApplicableFields.add(fieldName);
        }
        if (!nonApplicableFields.isEmpty()) {
            log.info("templateId = {} The following fields are not applicable to the current task type and will not be updated: {}", (Object)id, nonApplicableFields);
        }
        return hasApplicableField;
    }

    public <T> void updateFields(T targetObject, List<UpdateFieldVo> updateFields) throws Exception {
        Class<?> clazz = targetObject.getClass();
        Map<String, Field> fieldMap = this.getFieldMap(clazz);
        for (UpdateFieldVo vo : updateFields) {
            String fieldName = vo.getFieldName();
            String fieldValue = vo.getFieldValue();
            if (!fieldMap.containsKey(fieldName)) {
                throw new IllegalArgumentException("\u5b57\u6bb5[" + fieldName + "]\u4e0d\u5141\u8bb8\u66f4\u65b0");
            }
            Field field = fieldMap.get(fieldName);
            field.setAccessible(true);
            UpdateField anno = field.getAnnotation(UpdateField.class);
            Class<?> targetType = anno.type();
            TypeConverter converter = this.typeConverters.get(targetType);
            if (converter == null) {
                throw new IllegalArgumentException("\u5b57\u6bb5[" + fieldName + "]\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\uff1a" + targetType.getName());
            }
            Object convertedValue = converter.convert(fieldValue, targetType);
            field.set(targetObject, convertedValue);
        }
    }

    private Map<String, Field> getFieldMap(Class<?> clazz) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(UpdateField.class)) continue;
            UpdateField anno = field.getAnnotation(UpdateField.class);
            fieldMap.put(anno.value(), field);
        }
        return fieldMap;
    }
}

