/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.pr.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.pr.api.dto.BaseResult;
import com.ovopark.pr.api.query.BasicQuery;
import com.ovopark.pr.dao.entity.DeviceFlowTag;
import com.ovopark.pr.dao.entity.ShopFlowTag;
import com.ovopark.pr.dao.repository.DeviceFlowTagRepository;
import com.ovopark.pr.dao.repository.ShopFlowTagRepository;
import com.ovopark.pr.manager.common.Context;
import com.ovopark.pr.manager.exception.BizException;
import com.ovopark.pr.manager.export.dataobj.MoreSheetExportDataBo;
import com.ovopark.pr.manager.service.DepartmentService;
import com.ovopark.pr.manager.support.basic.dto.DepartmentDTO;
import com.ovopark.pr.manager.support.basic.dto.DeviceDTO;
import com.ovopark.pr.manager.support.basic.dto.UserDTO;
import com.ovopark.pr.manager.support.basic.rpc.DeviceProvider;
import com.ovopark.pr.service.OperationsAnalysisService;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service(value="operationsAnalysisService")
public class OperationsAnalysisServiceImpl
implements OperationsAnalysisService {
    @Resource
    private DepartmentService departmentService;
    @Resource
    private ShopFlowTagRepository shopFlowTagRepository;
    @Resource
    private DeviceFlowTagRepository deviceFlowTagRepository;
    @Resource
    private DeviceProvider deviceProvider;

    @Override
    public MoreSheetExportDataBo exportPrimaryPortTrafficDetail(BasicQuery query) {
        UserDTO user = Context.getContextFromThreadLocal().getUser();
        List deps = this.departmentService.getDepsByIdStr(query.getId(), user.getEnterpriseId(), user.getId());
        if (CollectionUtils.isEmpty((Collection)deps)) {
            throw new BizException(BaseResult.ResultCodeEnum.EMPTY_STORE.getCode(), BaseResult.ResultCodeEnum.EMPTY_STORE.getMessage());
        }
        List<Integer> depIds = deps.stream().map(DepartmentDTO::getId).toList();
        List primaryTags = this.shopFlowTagRepository.getPrimaryTags(depIds);
        List tagIds = primaryTags.stream().map(ShopFlowTag::getId).collect(Collectors.toList());
        Map<Integer, Integer> depIdTagIdMap = primaryTags.stream().collect(Collectors.toMap(ShopFlowTag::getDeptId, ShopFlowTag::getId, (t1, t2) -> t1));
        List deviceFlowTags = this.deviceFlowTagRepository.listByTagIds(tagIds);
        Map<Integer, List<DeviceFlowTag>> tagsMap = deviceFlowTags.stream().collect(Collectors.groupingBy(DeviceFlowTag::getTagId));
        List deviceIds = deviceFlowTags.stream().map(DeviceFlowTag::getDeviceId).distinct().collect(Collectors.toList());
        Map<Integer, String> deviceNameMap = this.deviceProvider.listByIds(deviceIds).stream().collect(Collectors.toMap(DeviceDTO::getId, DeviceDTO::getName, (t1, t2) -> t1));
        return null;
    }
}

