/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.pr.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.pr.dao.entity.ShopFlowTag;
import com.ovopark.pr.dao.repository.ShopFlowTagRepository;
import com.ovopark.pr.manager.service.DepartmentService;
import com.ovopark.pr.manager.support.basic.dto.DepartmentDTO;
import com.ovopark.pr.manager.support.basic.dto.DeviceDTO;
import com.ovopark.pr.manager.support.basic.dto.OrganizeDTO;
import com.ovopark.pr.manager.support.basic.rpc.DepartmentProvider;
import com.ovopark.pr.manager.support.basic.rpc.DeviceProvider;
import com.ovopark.pr.manager.support.basic.rpc.OrganizeProvider;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="departmentService")
public class DepartmentServiceImpl
implements DepartmentService {
    @Resource
    private DepartmentProvider departmentProvider;
    @Resource
    private ShopFlowTagRepository shopFlowTagRepository;
    @Resource
    private DeviceProvider deviceProvider;
    @Resource
    private OrganizeProvider organizeProvider;

    public List<Integer> getDepIdsByIdStr(String id, Integer enterpriseId, Integer userId) {
        if (StringUtils.isBlank((CharSequence)id) || enterpriseId == null || userId == null) {
            return new ArrayList<Integer>();
        }
        if ("UASs".equals(id)) {
            return this.departmentProvider.getUASIds(enterpriseId, userId);
        }
        ArrayList<String> orgIds = new ArrayList<String>();
        ArrayList<String> storeIds = new ArrayList<String>();
        ArrayList<String> storeTagIds = new ArrayList<String>();
        ArrayList<String> paxTagIds = new ArrayList<String>();
        ArrayList<String> paxDeviceIds = new ArrayList<String>();
        HashSet depIdSet = new HashSet();
        for (String idStr : id.split(",")) {
            if (idStr.startsWith("O_")) {
                orgIds.add(idStr);
                continue;
            }
            if (idStr.startsWith("S_")) {
                storeIds.add(idStr);
                continue;
            }
            if (idStr.startsWith("ST_")) {
                storeTagIds.add(idStr);
                continue;
            }
            if (idStr.startsWith("T_")) {
                paxTagIds.add(idStr);
                continue;
            }
            if (!idStr.startsWith("F_")) continue;
            paxDeviceIds.add(idStr);
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            List ids = orgIds.stream().map(i -> Integer.parseInt(i.split("_")[1])).collect(Collectors.toList());
            depIdSet.addAll(this.departmentProvider.getOrgDepartments(ids, enterpriseId, userId).stream().flatMap(s -> s.getDepIds().stream()).distinct().collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(storeIds)) {
            List depNodeIds = storeIds.stream().map(s -> Integer.parseInt(s.replace("S_", ""))).collect(Collectors.toList());
            depIdSet.addAll(depNodeIds);
        }
        if (CollectionUtils.isNotEmpty(storeTagIds)) {
            List tagNodeIds = storeTagIds.stream().map(s -> Integer.parseInt(s.replace("ST_", ""))).distinct().collect(Collectors.toList());
            List departments = this.departmentProvider.listDepartmentByUserTagIds(enterpriseId, userId, tagNodeIds);
            depIdSet.addAll(departments.stream().map(DepartmentDTO::getId).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(paxTagIds)) {
            List tagIds = paxTagIds.stream().map(s -> Integer.parseInt(s.replace("T_", ""))).distinct().collect(Collectors.toList());
            this.shopFlowTagRepository.listByIds(tagIds).stream().map(ShopFlowTag::getDeptId).forEach(depIdSet::add);
        }
        if (CollectionUtils.isNotEmpty(paxDeviceIds)) {
            List deviceIds = paxDeviceIds.stream().map(s -> Integer.parseInt(s.split("_")[2])).distinct().collect(Collectors.toList());
            this.deviceProvider.listByIds(deviceIds).stream().map(DeviceDTO::getDepId).forEach(depIdSet::add);
        }
        ArrayList<Integer> depIds = new ArrayList<Integer>(depIdSet);
        return depIds;
    }

    public List<DepartmentDTO> getDepsByIdStr(String id, Integer enterpriseId, Integer userId) {
        if ("UASs".equals(id)) {
            return this.departmentProvider.getUASs(enterpriseId, userId);
        }
        List<Integer> depIds = this.getDepIdsByIdStr(id, enterpriseId, userId);
        return this.departmentProvider.listByIds(depIds);
    }

    public String getNameByIdStr(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        String[] idStrArr = id.split(",");
        if (idStrArr.length > 1) {
            return "\u591a\u5e97\u6c47\u603b";
        }
        String name = null;
        if (Objects.equals(id, "UASs")) {
            name = "\u6211\u7684\u95e8\u5e97";
        } else if (id.startsWith("O_")) {
            name = Optional.ofNullable(this.organizeProvider.getById(Integer.valueOf(Integer.parseInt(id.split("_")[1])))).map(OrganizeDTO::getName).orElse(null);
        } else if (id.startsWith("S_")) {
            name = Optional.ofNullable(this.departmentProvider.getById(Integer.valueOf(Integer.parseInt(id.split("_")[1])))).map(DepartmentDTO::getName).orElse(null);
        } else if (!id.startsWith("ST_")) {
            if (id.startsWith("T_")) {
                name = Optional.ofNullable((ShopFlowTag)this.shopFlowTagRepository.getById((Serializable)Integer.valueOf(Integer.parseInt(id.split("_")[1])))).map(ShopFlowTag::getName).orElse(null);
            } else if (id.startsWith("F_")) {
                name = Optional.ofNullable(this.deviceProvider.getById(Integer.valueOf(Integer.parseInt(id.split("_")[2])))).map(DeviceDTO::getName).orElse(null);
            }
        }
        return name;
    }

    public Boolean isStore(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return false;
        }
        String[] idStrArr = id.split(",");
        if (idStrArr.length > 1) {
            return false;
        }
        return id.startsWith("S_");
    }
}

