/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.jdk21.test;

import com.ovopark.kernel.shared.ServiceProvider;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.CacheService;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E {
    private static final Logger log = LoggerFactory.getLogger(E.class);
    private static Map<Comparable, CacheService.MapCacheService.Entry> longDelay = new ConcurrentHashMap<Comparable, CacheService.MapCacheService.Entry>();
    static volatile boolean stopSchedule = true;

    public static void main(String[] args) throws InterruptedException {
        final AtomicLong expiredCount = new AtomicLong();
        final AtomicLong writeCount = new AtomicLong();
        CacheService.MapCacheService CS = new CacheService.MapCacheService(true, new CacheService.MapCacheService.RemovedCallBack(){

            public void call(CacheService.MapCacheService.Entry entry, long startTime, long scanTime, long expiredTime) {
                Comparable key = entry.getKey();
                LocalDateTime triggerTime = Util.dateTime((long)(startTime + expiredTime));
                LocalDateTime now = LocalDateTime.now();
                long realDelay = now.toInstant(Util.GMT_08).toEpochMilli() - startTime;
                if (realDelay - expiredTime > 1000L) {
                    if (longDelay.size() < 10000) {
                        longDelay.put(key, entry);
                    }
                    log.info(String.valueOf(key) + ",delay(ms):" + expiredTime + "/(" + realDelay + "+" + (realDelay - expiredTime) + "), start: " + Util.formatTime((LocalDateTime)Util.dateTime((long)startTime), (String[])new String[]{"HH:mm:ss.SSS"}) + ", trigger: " + Util.formatTime((LocalDateTime)triggerTime, (String[])new String[]{"HH:mm:ss.SSS"}) + ", now: " + Util.formatTime((LocalDateTime)now, (String[])new String[]{"HH:mm:ss.SSS"}));
                }
                expiredCount.incrementAndGet();
            }
        });
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        final Random random = new Random();
        int i = 0;
        while (i < 10000000) {
            int j = i++;
            executorService.execute(new Runnable(){
                final /* synthetic */ CacheService val$CS;
                final /* synthetic */ int val$j;
                final /* synthetic */ AtomicLong val$writeCount;
                {
                    this.val$CS = cacheService;
                    this.val$j = n;
                    this.val$writeCount = atomicLong;
                }

                @Override
                public void run() {
                    final int time = random.nextInt(10, 180000);
                    this.val$CS.putIfAbsentAndGet((Comparable)((Object)("i-" + this.val$j)), (Supplier)new ServiceProvider<String>(){

                        public String get() {
                            return "expired(ms): " + time;
                        }
                    }, (long)time, TimeUnit.MILLISECONDS);
                    this.val$writeCount.incrementAndGet();
                }
            });
        }
        for (i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
            Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable(){
                final /* synthetic */ CacheService val$CS;
                final /* synthetic */ AtomicLong val$writeCount;
                {
                    this.val$CS = cacheService;
                    this.val$writeCount = atomicLong;
                }

                @Override
                public void run() {
                    if (stopSchedule) {
                        return;
                    }
                    for (int i1 = 0; i1 < 100; ++i1) {
                        final int time = random.nextInt(10, 900000);
                        this.val$CS.putIfAbsentAndGet((Comparable)((Object)("i-" + Util.uniqueFirstPart() + "-" + time)), (Supplier)new ServiceProvider<String>(){

                            public String get() {
                                return "expired(ms): " + time;
                            }
                        }, (long)time, TimeUnit.MILLISECONDS);
                        this.val$writeCount.incrementAndGet();
                    }
                }
            }, 0L, 30L, TimeUnit.MILLISECONDS);
        }
        Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable(){
            long temp;
            final /* synthetic */ CacheService val$CS;
            {
                this.val$CS = cacheService;
            }

            @Override
            public void run() {
                long c = expiredCount.get();
                log.info("write count: " + writeCount.get() + ", expired: " + c + "(+" + (c - this.temp) + ")");
                this.temp = c;
                final int time = random.nextInt(10, 1000);
                this.val$CS.putIfAbsentAndGet((Comparable)((Object)("i-" + Util.uniqueFirstPart() + "-" + time)), (Supplier)new ServiceProvider<String>(){

                    public String get() {
                        return "expired(ms): " + time;
                    }
                }, (long)time, TimeUnit.MILLISECONDS);
                writeCount.incrementAndGet();
            }
        }, 0L, 3L, TimeUnit.SECONDS);
        TimeUnit.SECONDS.sleep(30000L);
    }
}

