/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.jdk21.test;

import com.ovopark.kernel.shared.Processing;
import com.ovopark.kernel.shared.Util;
import java.time.LocalDateTime;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class A {
    private static final Logger log = LoggerFactory.getLogger(A.class);

    public static void main(String[] args) throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        int c = 1000;
        final CountDownLatch countDownLatch = new CountDownLatch(c);
        for (int i = 0; i < c; ++i) {
            final String id = UUID.randomUUID().toString();
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    log.info("start: " + id);
                    Processing processing = Processing.start((String)id);
                    try {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    String content = Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]) + ", " + Thread.currentThread().getName();
                    processing.trace(content);
                    log.info("end: " + id + ", " + content);
                    countDownLatch.countDown();
                }
            });
        }
        countDownLatch.await();
        log.info("test all completely,");
        TimeUnit.SECONDS.sleep(300L);
        Processing processing = Processing.start((String)"abc");
        for (int i = 0; i < 93; ++i) {
            processing.trace(" c: " + i);
        }
        processing.forEach(arg_0 -> ((Logger)log).info(arg_0));
        System.out.println("end");
        TimeUnit.SECONDS.sleep(7L);
        processing.trace("err???");
        processing.forEach(arg_0 -> ((Logger)log).info(arg_0));
    }
}

