/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.jdk21.test;

import com.ovopark.kernel.shared.kv.KVEngine;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E5 {
    private static final Logger log = LoggerFactory.getLogger(E5.class);
    private static Map<Comparable, Object> longDelay = new ConcurrentHashMap<Comparable, Object>();
    static volatile boolean stopSchedule = false;

    public static void main(String[] args) throws InterruptedException {
        int minute = 3;
        final int defCount = 70000000;
        final AtomicLong expiredCount = new AtomicLong();
        final AtomicLong writeCount = new AtomicLong();
        final AtomicLong sameCount = new AtomicLong();
        final AtomicLong runCount = new AtomicLong();
        final long start = System.currentTimeMillis();
        final KVEngine.TtlFunc CS = KVEngine.ttl();
        CS.subscribeTtl(k -> true, (KVEngine.TtlListener)new KVEngine.TtlListener<String>(){

            public void onTtl(KVEngine.GetResult<String, ?> getResult, long startMillis, long expiredMillis) {
                expiredCount.incrementAndGet();
            }
        });
        final Random random = new Random();
        Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable(){
            long temp;

            @Override
            public void run() {
                long c = expiredCount.get();
                log.info(" \r\nwrite count: " + writeCount.get() + ", expired: " + c + "(+" + (c - this.temp) + "),  same: " + sameCount.get() + "/" + runCount.get() + "/" + defCount + " , rest: " + CS.size() + " , check " + (c + sameCount.get() + (long)CS.size()) + "/" + defCount);
                this.temp = c;
                if (writeCount.get() > 300000000L || System.currentTimeMillis() - start > 300000L) {
                    stopSchedule = true;
                }
            }
        }, 0L, 3L, TimeUnit.SECONDS);
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (int i = 0; i < defCount; ++i) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    runCount.incrementAndGet();
                    final int time = random.nextInt(10, 180000);
                    KVEngine.PutResult putResult = CS.putAndGet((Comparable)((Object)("i-" + time)), (KVEngine.Upset)new KVEngine.Upset<String, Object, Object>(){

                        public Object apply(KVEngine.GetResult<String, Object> getResult) {
                            if (getResult.exists()) {
                                sameCount.incrementAndGet();
                            }
                            writeCount.incrementAndGet();
                            return "expired(ms): " + time;
                        }
                    }, KVEngine.TTL.from((long)random.nextInt(1, 3), (TimeUnit)TimeUnit.SECONDS));
                    if (putResult == null || putResult.value() == null) {
                        throw new IllegalStateException();
                    }
                }
            });
        }
        TimeUnit.SECONDS.sleep(3000000L);
    }
}

